/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import oracle.jakarta.jms.AQjmsAgent;
import oracle.jakarta.jms.AQjmsConstants;
import oracle.jakarta.jms.AQjmsDestination;
import oracle.jakarta.jms.AQjmsDestinationProperty;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsException;
import oracle.jakarta.jms.AQjmsGenMessage_C;
import oracle.jakarta.jms.AQjmsMessageFormatException;
import oracle.jakarta.jms.AQjmsMessageHeaderExt;
import oracle.jakarta.jms.AQjmsMessageID;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsPropDatum;
import oracle.jakarta.jms.AQjmsProperty;
import oracle.jakarta.jms.AQjmsPropertyList;
import oracle.jakarta.jms.AQjmsSession;
import oracle.jakarta.jms.AQjmsSignature;
import oracle.jakarta.jms.AQjmsTempLobTruncateException;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleData;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.saga.SagaUtils;
import oracle.sql.BLOB;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class AQjmsMessage
implements Message {
    static final Class m_boolClass = new Boolean(false).getClass();
    static final Class m_byteClass = new Byte(0).getClass();
    static final Class m_shortClass = new Byte(0).getClass();
    static final Class m_intClass = new Integer(0).getClass();
    static final Class m_longClass = new Long(0L).getClass();
    static final Class m_floatClass = new Float(0.0f).getClass();
    static final Class m_doubleClass = new Double(0.0).getClass();
    static final Class m_strClass = new String(" ").getClass();
    static Hashtable m_systemProperties;
    static HashSet m_settableSystemProperties;
    AQjmsMessageHeaderExt header_ext;
    AQjmsMessageID message_id;
    long enqueue_time;
    String corr_id;
    Destination msg_dest;
    int del_mode;
    boolean redelivered;
    long expiration;
    int priority;
    Hashtable msg_properties;
    int access_mode;
    boolean prop_read_only;
    long recv_time;
    int msg_state;
    String excp_queue;
    int msg_delay;
    byte[] orig_msg_id;
    AQjmsAgent sender_id;
    int attempts;
    AQjmsSignature m_signature;
    AQjmsSession session;
    boolean m_hdrOnly;
    boolean m_isjmsbody;
    boolean compliant;
    boolean largeBody;
    long bodyLength;
    InputStream m_inputStream;
    byte[] lobLocator;
    private static final String JMS_REPLY_TO = "JMSReplyTo";
    boolean m_writeLobLater = false;
    Object m_tempLob = null;

    private void init(boolean jmsbody) {
        this.message_id = new AQjmsMessageID();
        this.enqueue_time = 0L;
        this.msg_dest = null;
        this.del_mode = 2;
        this.corr_id = "";
        this.redelivered = false;
        this.expiration = 0L;
        this.compliant = this.session == null ? AQjmsConstants.IS_COMPLIANT : this.session.getCompliant();
        this.priority = jmsbody && this.compliant ? 4 : 1;
        this.msg_properties = new Hashtable();
        this.access_mode = 2;
        this.prop_read_only = false;
        this.recv_time = 0L;
        this.excp_queue = null;
        this.msg_delay = 0;
        this.orig_msg_id = null;
        this.m_signature = null;
        this.m_hdrOnly = false;
        this.m_isjmsbody = jmsbody;
        this.header_ext = new AQjmsMessageHeaderExt();
    }

    AQjmsMessage(boolean jmsbody) {
        this.init(jmsbody);
    }

    AQjmsMessage(AQjmsSession session, boolean jmsbody) {
        this.session = session;
        this.init(jmsbody);
    }

    AQjmsMessage(AQjmsMessage inmsg) {
        this(inmsg.session, inmsg.m_isjmsbody);
        this.header_ext = inmsg.header_ext;
        this.message_id = inmsg.message_id;
        this.enqueue_time = inmsg.enqueue_time;
        this.corr_id = inmsg.corr_id;
        this.msg_dest = inmsg.msg_dest;
        this.del_mode = inmsg.del_mode;
        this.redelivered = inmsg.redelivered;
        this.expiration = inmsg.expiration;
        this.priority = inmsg.priority;
        this.msg_properties = inmsg.msg_properties;
        this.access_mode = inmsg.access_mode;
        this.prop_read_only = inmsg.prop_read_only;
        this.recv_time = inmsg.recv_time;
        this.msg_state = inmsg.msg_state;
        this.excp_queue = inmsg.excp_queue;
        this.msg_delay = inmsg.msg_delay;
        this.orig_msg_id = inmsg.orig_msg_id;
        this.sender_id = inmsg.sender_id;
        this.attempts = inmsg.attempts;
        this.m_signature = inmsg.m_signature;
        this.m_hdrOnly = inmsg.m_hdrOnly;
    }

    AQjmsMessageHeaderExt getMessageHeaderExt() {
        return this.header_ext;
    }

    Hashtable getPropertiesHashtable() {
        return this.msg_properties;
    }

    void setPropertiesHashtable(Hashtable props) {
        this.msg_properties = props;
    }

    public String getJMSMessageID() throws JMSException {
        return this.message_id.getJMSMessageID();
    }

    public byte[] getJMSMessageIDAsBytes() throws JMSException {
        return this.message_id.getJMSMessageIDAsBytes();
    }

    void setJMSMessageID(byte[] id) throws JMSException {
        this.message_id.setJMSMessageID(id);
    }

    public void setJMSMessageID(String id) throws JMSException {
        this.message_id.setJMSMessageID(id);
    }

    public long getJMSTimestamp() throws JMSException {
        long timestamp;
        Object timeObj = this.getObjectProperty("JMS_OracleTimestamp");
        if (timeObj != null && timeObj instanceof Long) {
            timestamp = (Long)timeObj;
            AQjmsOracleDebug.trace(5, "AQjmsMessage.getJMSTimestamp", "JMSTimestamp from property:" + timestamp);
        } else {
            timestamp = this.getEnqueueTime();
            AQjmsOracleDebug.trace(5, "AQjmsMessage.getJMSTimestamp", "JMSTimestamp from AQ enqueue_time:" + timestamp);
        }
        return timestamp;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.setLongProperty2("JMS_OracleTimestamp", timestamp);
        AQjmsOracleDebug.println("setJMSTimestamp. timestamp: " + timestamp);
    }

    long getEnqueueTime() {
        return this.enqueue_time;
    }

    void setEnqueueTime(long timestamp) {
        this.enqueue_time = timestamp;
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.corr_id;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (this.corr_id == null) {
            return null;
        }
        return this.corr_id.getBytes();
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.corr_id = correlationID;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this.corr_id = correlationID == null ? null : new String(correlationID);
    }

    public Destination getJMSReplyTo() throws JMSException {
        Object ret = null;
        try {
            ret = this.header_ext.getReplyto();
            if (ret != null) {
                String n = ((AQjmsAgent)ret).getName();
                if (n != null && n.equalsIgnoreCase(JMS_REPLY_TO)) {
                    ret = AQjmsMessage.deserializeDest(((AQjmsAgent)ret).getAddress());
                }
                if (ret instanceof AQjmsAgent) {
                    String a = ((AQjmsAgent)ret).getAddress();
                    if ((n == null || n.equals("") || n.equals(" ")) && (a == null || a.equals(""))) {
                        ret = null;
                    }
                }
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        return ret;
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        try {
            if (replyTo instanceof AQjmsAgent) {
                String n = ((AQjmsAgent)replyTo).getName();
                if (n != null && n.equalsIgnoreCase(JMS_REPLY_TO)) {
                    AQjmsError.throwEx(147);
                }
                this.header_ext.setReplyto((AQjmsAgent)replyTo);
            } else if (replyTo instanceof AQjmsDestination) {
                this.header_ext.setReplyto(new AQjmsAgent(JMS_REPLY_TO, AQjmsMessage.serializeDest((AQjmsDestination)replyTo)));
            } else if (replyTo == null) {
                this.header_ext.setReplyto(new AQjmsAgent(JMS_REPLY_TO, null));
            } else {
                AQjmsError.throwEx(147);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public Destination getJMSDestination() throws JMSException {
        return this.msg_dest;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.msg_dest = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.del_mode;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode != 2 && deliveryMode != 1) {
            AQjmsError.throwEx(101, Integer.toString(deliveryMode));
        }
        this.del_mode = deliveryMode;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.redelivered;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.redelivered = redelivered;
    }

    public String getJMSType() throws JMSException {
        try {
            return this.header_ext.getType();
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public void setJMSType(String type) throws JMSException {
        try {
            this.header_ext.setType(type);
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public long getJMSExpiration() throws JMSException {
        return this.expiration;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.expiration = expiration;
    }

    public int getJMSPriority() throws JMSException {
        return this.priority;
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.priority = priority;
    }

    public String getSagaSender() throws JMSException {
        return this.getStringProperty("jms_oracle_aq$_saga_sender");
    }

    public void setSagaSender(String saga_sender) throws JMSException {
        this.setSagaSender(saga_sender, true);
    }

    public void setSagaSender(String saga_sender, boolean is_canonicalized) throws JMSException {
        if (is_canonicalized) {
            saga_sender = SagaUtils.canonicalize((String)saga_sender);
        }
        this.setStringProperty2("jms_oracle_aq$_saga_sender", saga_sender);
    }

    public String getSagaRecipient() throws JMSException {
        return this.getStringProperty("jms_oracle_aq$_saga_recipient");
    }

    public void setSagaRecipient(String saga_recipient) throws JMSException {
        this.setSagaRecipient(saga_recipient, true);
    }

    public void setSagaRecipient(String saga_recipient, boolean is_canonicalized) throws JMSException {
        if (is_canonicalized) {
            saga_recipient = SagaUtils.canonicalize((String)saga_recipient);
        }
        this.setStringProperty2("jms_oracle_aq$_saga_recipient", saga_recipient);
    }

    public String getSagaId() throws JMSException {
        return this.getStringProperty("jms_oracle_aq$_saga_id");
    }

    public void setSagaId(String saga_id) throws JMSException {
        this.setStringProperty2("jms_oracle_aq$_saga_id", saga_id);
    }

    public String getSagaCoordinator() throws JMSException {
        return this.getStringProperty("jms_oracle_aq$_saga_coordinator");
    }

    public void setSagaCoordinator(String saga_coordinator) throws JMSException {
        this.setSagaCoordinator(saga_coordinator, true);
    }

    public void setSagaCoordinator(String saga_coordinator, boolean is_canonicalized) throws JMSException {
        if (is_canonicalized) {
            saga_coordinator = SagaUtils.canonicalize((String)saga_coordinator);
        }
        this.setStringProperty2("jms_oracle_aq$_saga_coordinator", saga_coordinator);
    }

    public Integer getSagaTimeout() throws JMSException {
        if (!this.propertyExists("jms_oracle_aq$_saga_timeout")) {
            return null;
        }
        return this.getIntProperty("jms_oracle_aq$_saga_timeout");
    }

    private void setSagaTimeout(Integer saga_timeout) throws JMSException {
        this.setIntProperty("jms_oracle_aq$_saga_timeout", saga_timeout);
    }

    public Integer getSagaVersion() throws JMSException {
        if (!this.propertyExists("jms_oracle_aq$_saga_version")) {
            return null;
        }
        return this.getIntProperty("jms_oracle_aq$_saga_version");
    }

    public void setSagaVersion(Integer saga_version) throws JMSException {
        this.setIntProperty("jms_oracle_aq$_saga_version", saga_version);
    }

    public String getSagaSpare() throws JMSException {
        return this.getStringProperty("jms_oracle_aq$_saga_spare");
    }

    public void setSagaSpare(String saga_spare) throws JMSException {
        this.setSagaSpare(saga_spare, true);
    }

    public void setSagaSpare(String saga_spare, boolean is_canonicalized) throws JMSException {
        if (saga_spare != null) {
            if (is_canonicalized) {
                saga_spare = SagaUtils.canonicalize((String)saga_spare);
            }
            this.setStringProperty2("jms_oracle_aq$_saga_spare", saga_spare);
        }
    }

    public String getSagaBeginTime() throws JMSException {
        return this.getStringProperty("jms_oracle_aq$_saga_begin_time");
    }

    private void setSagaBeginTime(String begin_time) throws JMSException {
        if (begin_time != null) {
            this.setStringProperty2("jms_oracle_aq$_saga_begin_time", begin_time);
        }
    }

    public void clearProperties() throws JMSException {
        if (this.msg_properties != null) {
            this.msg_properties.clear();
        }
        if (this.header_ext != null) {
            try {
                this.header_ext.setUserid(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.header_ext.setAppid(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.header_ext.setGroupid(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.header_ext.setGroupseq(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.header_ext.setProperties(null);
            }
            catch (Exception ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsMessage.clearProperties", ex);
            }
        }
        this.attempts = 0;
        this.msg_state = 0;
        this.recv_time = 0L;
        this.excp_queue = null;
        this.msg_delay = 0;
        this.orig_msg_id = null;
        this.m_signature = null;
        this.setPropReadOnly(false);
    }

    public boolean propertyExists(String name) throws JMSException {
        this.checkNullPropertyName(name);
        if (m_systemProperties.containsKey(name)) {
            try {
                return this.getSystemProperty(name) != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        return this.msg_properties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value;
        block11: {
            AQjmsPropDatum prop_datum = null;
            value = null;
            this.checkNullPropertyName(name);
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null && cl == m_strClass) {
                        String str = (String)value;
                        return Boolean.valueOf(str);
                    }
                    break block11;
                }
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 20: {
                            int val = ((Datum)value).intValue();
                            return val != 0;
                        }
                        case 27: {
                            String str = (String)value;
                            return Boolean.valueOf(str);
                        }
                    }
                    break block11;
                }
                return false;
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value;
        block12: {
            AQjmsPropDatum prop_datum = null;
            value = null;
            this.checkNullPropertyName(name);
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null && cl == m_strClass) {
                        String str = (String)value;
                        return Byte.parseByte(str);
                    }
                    break block12;
                }
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 21: {
                            int val = ((Datum)value).intValue();
                            return (byte)val;
                        }
                        case 27: {
                            String str = (String)value;
                            return Byte.parseByte(str);
                        }
                    }
                    break block12;
                }
                throw new NumberFormatException("getByteProperty() -> null");
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public short getShortProperty(String name) throws JMSException {
        Object value;
        block12: {
            AQjmsPropDatum prop_datum = null;
            value = null;
            this.checkNullPropertyName(name);
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null && cl == m_strClass) {
                        String str = (String)value;
                        return Short.parseShort(str);
                    }
                    break block12;
                }
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 21: 
                        case 22: {
                            int val = ((Datum)value).intValue();
                            return (short)val;
                        }
                        case 27: {
                            String str = (String)value;
                            return Short.parseShort(str);
                        }
                    }
                    break block12;
                }
                throw new NumberFormatException("getShortProperty() -> null");
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public int getIntProperty(String name) throws JMSException {
        Object value;
        block13: {
            AQjmsPropDatum prop_datum = null;
            value = null;
            this.checkNullPropertyName(name);
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null) {
                        if (cl == m_strClass) {
                            String str = (String)value;
                            return Integer.parseInt(str);
                        }
                        return ((Datum)value).intValue();
                    }
                    break block13;
                }
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 21: 
                        case 22: 
                        case 23: {
                            return ((Datum)value).intValue();
                        }
                        case 27: {
                            String str = (String)value;
                            return Integer.parseInt(str);
                        }
                    }
                    break block13;
                }
                throw new NumberFormatException("getIntProperty() -> null");
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public long getLongProperty(String name) throws JMSException {
        Object value;
        block15: {
            AQjmsPropDatum prop_datum = null;
            value = null;
            this.checkNullPropertyName(name);
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null && cl == m_strClass) {
                        String str = (String)value;
                        return Long.parseLong(str);
                    }
                    if (cl == m_intClass) {
                        return ((Datum)value).intValue();
                    }
                    if (cl == m_longClass) {
                        return ((Datum)value).longValue();
                    }
                    break block15;
                }
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 21: 
                        case 22: 
                        case 23: {
                            return ((Datum)value).intValue();
                        }
                        case 24: {
                            return ((Datum)value).longValue();
                        }
                        case 27: {
                            String str = (String)value;
                            return Long.parseLong(str);
                        }
                    }
                    break block15;
                }
                throw new NumberFormatException("getLongProperty() -> null");
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public float getFloatProperty(String name) throws JMSException {
        AQjmsPropDatum prop_datum = null;
        Object value = null;
        this.checkNullPropertyName(name);
        try {
            Class cl = (Class)m_systemProperties.get(name);
            if (cl != null) {
                value = this.getSystemProperty(name);
                if (value != null && cl == m_strClass) {
                    String str = (String)value;
                    return Float.parseFloat(str);
                }
            } else {
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 25: {
                            return ((Float)value).floatValue();
                        }
                        case 27: {
                            String str = (String)value;
                            return Float.parseFloat(str);
                        }
                    }
                }
            }
        }
        catch (SQLException sq_ex) {
            throw new AQjmsMessageFormatException(sq_ex);
        }
        catch (Exception e) {
            AQjmsError.throwMsgFormatEx(117, e.getMessage());
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public double getDoubleProperty(String name) throws JMSException {
        AQjmsPropDatum prop_datum = null;
        Object value = null;
        this.checkNullPropertyName(name);
        try {
            Class cl = (Class)m_systemProperties.get(name);
            if (cl != null) {
                value = this.getSystemProperty(name);
                if (value != null && cl == m_strClass) {
                    String str = (String)value;
                    return Double.parseDouble(str);
                }
            } else {
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 25: {
                            return ((Float)value).floatValue();
                        }
                        case 26: {
                            return (Double)value;
                        }
                        case 27: {
                            String str = (String)value;
                            return Double.parseDouble(str);
                        }
                    }
                }
            }
        }
        catch (SQLException sq_ex) {
            throw new AQjmsMessageFormatException(sq_ex);
        }
        catch (Exception e) {
            AQjmsError.throwMsgFormatEx(117, e.getMessage());
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public String getStringProperty(String name) throws JMSException {
        AQjmsPropDatum prop_datum = null;
        Object value = null;
        this.checkNullPropertyName(name);
        try {
            Class cl = (Class)m_systemProperties.get(name);
            if (cl != null) {
                value = this.getSystemProperty(name);
                if (value != null) {
                    if (cl == m_strClass) {
                        return (String)value;
                    }
                    return ((Datum)value).stringValue();
                }
            } else {
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 20: {
                            int val = ((Datum)value).intValue();
                            if (val > 0) {
                                return "true";
                            }
                            return "false";
                        }
                        case 25: {
                            return ((Float)value).toString();
                        }
                        case 26: {
                            return ((Double)value).toString();
                        }
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: {
                            return ((Datum)value).stringValue();
                        }
                    }
                    return (String)value;
                }
            }
        }
        catch (SQLException sq_ex) {
            throw new AQjmsMessageFormatException(sq_ex);
        }
        catch (Exception e) {
            AQjmsError.throwMsgFormatEx(117, e.getMessage());
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return null;
    }

    public Object getObjectProperty(String name) throws JMSException {
        AQjmsPropDatum prop_datum = null;
        Object value = null;
        this.checkNullPropertyName(name);
        try {
            Class cl = (Class)m_systemProperties.get(name);
            if (cl != null) {
                if (cl == m_strClass && (value = this.getSystemProperty(name)) != null) {
                    return value;
                }
                if (cl == m_intClass && (value = this.getSystemProperty(name)) != null) {
                    return new Integer(((Datum)value).intValue());
                }
                if (cl == m_longClass && (value = this.getSystemProperty(name)) != null) {
                    return new Long(((Datum)value).longValue());
                }
            } else {
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 20: {
                            int val1 = ((Datum)value).intValue();
                            return new Boolean(val1 > 0);
                        }
                        case 21: {
                            int val2 = ((Datum)value).intValue();
                            return new Byte((byte)val2);
                        }
                        case 22: {
                            int val3 = ((Datum)value).intValue();
                            return new Short((short)val3);
                        }
                        case 23: {
                            int val4 = ((Datum)value).intValue();
                            return new Integer(val4);
                        }
                        case 24: {
                            long val41 = ((Datum)value).longValue();
                            return new Long(val41);
                        }
                        case 25: {
                            float val5 = ((Float)value).floatValue();
                            return new Float(val5);
                        }
                        case 26: {
                            double val6 = (Double)value;
                            return new Double(val6);
                        }
                        case 27: {
                            return value;
                        }
                    }
                }
            }
        }
        catch (SQLException sq_ex) {
            throw new AQjmsMessageFormatException(sq_ex);
        }
        catch (Exception e) {
            AQjmsError.throwMsgFormatEx(117, e.getMessage(), e);
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return null;
    }

    public synchronized Enumeration getPropertyNames() throws JMSException {
        Vector<String> properties = new Vector<String>(this.msg_properties.size() + m_systemProperties.size());
        Enumeration my_enum = m_systemProperties.keys();
        while (my_enum.hasMoreElements()) {
            String propName = (String)my_enum.nextElement();
            try {
                if (this.compliant && this.getSystemProperty(propName) == null) continue;
                properties.addElement(propName);
            }
            catch (SQLException sqe) {
                AQjmsOracleDebug.traceEx(2, "AQjmsMessage.getPropertyNames", sqe);
                AQjmsError.throwEx(122, (Throwable)sqe);
            }
        }
        my_enum = this.msg_properties.keys();
        while (my_enum.hasMoreElements()) {
            properties.addElement((String)my_enum.nextElement());
        }
        return properties.elements();
    }

    public synchronized Enumeration getUserPropertyNames() throws JMSException {
        Vector<String> properties = new Vector<String>(this.msg_properties.size());
        Enumeration my_enum = this.msg_properties.keys();
        while (my_enum.hasMoreElements()) {
            String key = (String)my_enum.nextElement();
            if (AQjmsMessage.isSystemProperty(key)) continue;
            properties.addElement(key);
        }
        return properties.elements();
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (AQjmsMessage.isSystemProperty(name)) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(20, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, (Throwable)sql_ex);
        }
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (AQjmsMessage.isSystemProperty(name)) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(21, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, (Throwable)sql_ex);
        }
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (AQjmsMessage.isSystemProperty(name)) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(22, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, (Throwable)sql_ex);
        }
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (AQjmsMessage.isSystemProperty(name)) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsOracleDebug.println("setIntProperty: Property: " + name + " Value:  " + value);
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(23, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, (Throwable)sql_ex);
        }
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.setLongProperty2(name, value);
    }

    void setLongProperty2(String name, long value) throws JMSException {
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (AQjmsMessage.isSystemProperty(name)) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(24, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, (Throwable)sql_ex);
        }
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            if (AQjmsMessage.isSystemProperty(name)) {
                NUMBER newValue = new NUMBER(value);
                this.setSystemProperty(name, newValue);
            } else {
                AQjmsPropDatum propDatum = new AQjmsPropDatum(value);
                this.insertPropertyIntoTable(this.msg_properties, name, propDatum);
            }
        }
        catch (SQLException sqlEx) {
            AQjmsError.throwEx(119, (Throwable)sqlEx);
        }
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            if (AQjmsMessage.isSystemProperty(name)) {
                NUMBER newValue = new NUMBER(value);
                this.setSystemProperty(name, newValue);
            } else {
                AQjmsPropDatum propDatum = new AQjmsPropDatum(value);
                this.insertPropertyIntoTable(this.msg_properties, name, propDatum);
            }
        }
        catch (SQLException sqlEx) {
            AQjmsError.throwEx(119, (Throwable)sqlEx);
        }
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.setStringProperty2(name, value);
    }

    void setStringProperty2(String name, String value) throws JMSException {
        this.checkPropertyName(name);
        try {
            if (AQjmsMessage.isSystemProperty(name)) {
                this.setSystemProperty(name, value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(27, value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, (Throwable)sql_ex);
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        if (value == null) {
            AQjmsError.throwMsgFormatEx(119, null);
        }
        if (value instanceof Boolean) {
            this.setBooleanProperty(name, (Boolean)value);
        } else if (value instanceof Byte) {
            this.setByteProperty(name, (Byte)value);
        } else if (value instanceof Short) {
            this.setShortProperty(name, (Short)value);
        } else if (value instanceof Integer) {
            this.setIntProperty(name, (Integer)value);
        } else if (value instanceof Long) {
            this.setLongProperty(name, (Long)value);
        } else if (value instanceof Float) {
            this.setFloatProperty(name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDoubleProperty(name, (Double)value);
        } else if (value instanceof String) {
            this.setStringProperty(name, (String)value);
        } else {
            AQjmsError.throwMsgFormatEx(119, null);
        }
    }

    public void acknowledge() throws JMSException {
        Connection db_conn = null;
        if (this.session.getAcknowledgeMode() == 2) {
            if (this.session.usedJMSRegistration) {
                AQjmsOracleDebug.trace(5, "AQjmsMessage.acknowledge", "before calling session.ackJmsNtfsAndCommit");
                this.session.ackJmsNtfsAndCommit();
                return;
            }
            db_conn = this.session.getDBConnection();
            try {
                db_conn.commit();
            }
            catch (SQLException sql_ex) {
                throw new AQjmsException(sql_ex);
            }
        }
    }

    public void clearBody() throws JMSException {
    }

    public AQjmsAgent getSenderID() throws JMSException {
        return this.sender_id;
    }

    public void setSenderID(AQjmsAgent sender) throws JMSException {
        this.sender_id = sender;
    }

    public int getAttempts() throws JMSException {
        return this.attempts;
    }

    void setAttempts(int num_attempts) throws JMSException {
        this.attempts = num_attempts;
    }

    boolean isPropReadOnly() {
        return this.prop_read_only;
    }

    void setPropReadOnly(boolean value) {
        this.prop_read_only = value;
    }

    boolean isBodyReadOnly() {
        return this.access_mode == 0;
    }

    boolean isBodyWriteOnly() {
        return this.access_mode == 1;
    }

    boolean isBodyReadWrite() {
        return this.access_mode == 2;
    }

    void setAccessMode(int value) throws JMSException {
        if (value == 0 || value == 1 || value == 2) {
            this.access_mode = value;
        } else {
            AQjmsError.throwEx(152);
        }
    }

    static String ByteArraytoString(byte[] b) {
        StringBuffer buf = new StringBuffer();
        if (b == null) {
            buf.append("");
        } else {
            int n = b.length;
            for (int i = 0; i < n; ++i) {
                int v = b[i] & 0xFF;
                if (v < 16) {
                    buf.append("0" + Integer.toHexString(v));
                    continue;
                }
                buf.append(Integer.toHexString(v));
            }
        }
        return buf.toString();
    }

    static AQjmsPropertyList convertHashtableToPropertyList(Hashtable msg_props) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertHashtableToPropertyList", "entry");
        int num_props = 0;
        int i = 0;
        Enumeration value_enum = null;
        Enumeration name_enum = null;
        String curr_name = null;
        AQjmsPropDatum curr_value = null;
        Object d_value = null;
        num_props = msg_props.size();
        AQjmsOracleDebug.println("Num props " + num_props);
        AQjmsProperty[] properties = new AQjmsProperty[num_props];
        name_enum = msg_props.keys();
        value_enum = msg_props.elements();
        try {
            i = 0;
            while (name_enum.hasMoreElements()) {
                curr_name = (String)name_enum.nextElement();
                curr_value = (AQjmsPropDatum)value_enum.nextElement();
                d_value = curr_value.getValue();
                properties[i] = new AQjmsProperty();
                AQjmsOracleDebug.println("Property: " + i);
                int type = curr_value.getType();
                AQjmsOracleDebug.println("Name: " + curr_name + "  Type: " + type);
                if (type == 27) {
                    properties[i].setName(curr_name);
                    properties[i].setType(new Integer(100));
                    properties[i].setStrValue((String)d_value);
                    properties[i].setNumValue(null);
                    properties[i].setJavaType(new Integer(type));
                    AQjmsOracleDebug.println("Name: " + curr_name + "  Value: " + (String)d_value + "  Str Type");
                } else {
                    NUMBER num;
                    if (type == 25) {
                        num = new NUMBER(((Float)d_value).floatValue());
                        d_value = num;
                    } else if (type == 26) {
                        num = new NUMBER(((Double)d_value).doubleValue());
                        d_value = num;
                    }
                    if (d_value instanceof NUMBER) {
                        properties[i].setName(curr_name);
                        properties[i].setType(new Integer(200));
                        properties[i].setStrValue(null);
                        properties[i].setNumValue(((Datum)d_value).bigDecimalValue());
                        properties[i].setJavaType(new Integer(type));
                        AQjmsOracleDebug.println("Name: " + curr_name + "  Value: " + ((Datum)d_value).bigDecimalValue() + "  Num Type");
                    } else {
                        AQjmsOracleDebug.trace(1, "AQjmsMessage.convertHashtableToPropertyList", "Internal error - invalid datum value");
                        AQjmsError.throwEx(122);
                    }
                }
                ++i;
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.convertHashtableToPropertyList", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        AQjmsPropertyList prop_list = new AQjmsPropertyList(properties);
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertHashtableToPropertyList", "exit");
        return prop_list;
    }

    static Hashtable convertPropertyListToHashtable(AQjmsPropertyList prop_list) throws JMSException {
        Hashtable<String, AQjmsPropDatum> msg_props;
        int num_props = 0;
        int i = 0;
        Object value_enum = null;
        Object name_enum = null;
        String curr_name = null;
        AQjmsPropDatum curr_value = null;
        NUMBER d_value = null;
        String s_value = null;
        int java_type = 0;
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertPropertyListToHashtable", "entry");
        try {
            num_props = prop_list.length();
            msg_props = new Hashtable<String, AQjmsPropDatum>();
            AQjmsOracleDebug.trace(4, "AQjmsMessage.convertPropertyListToHashtable", "num_props: " + num_props);
            AQjmsProperty[] properties = new AQjmsProperty[num_props];
            for (i = 0; i < num_props; ++i) {
                properties[i] = prop_list.getElement(i);
                curr_name = properties[i].getName();
                Integer type = properties[i].getType();
                int n = java_type = properties[i].getJavaType() != null ? properties[i].getJavaType() : 0;
                if (type == 100) {
                    s_value = properties[i].getStrValue();
                    curr_value = new AQjmsPropDatum(java_type, s_value);
                } else if (type == 200) {
                    d_value = new NUMBER(properties[i].getNumValue());
                    if (java_type == 25) {
                        float f = d_value.floatValue();
                        curr_value = new AQjmsPropDatum(f);
                    } else if (java_type == 26) {
                        double d = d_value.doubleValue();
                        curr_value = new AQjmsPropDatum(d);
                    } else {
                        curr_value = new AQjmsPropDatum(java_type, (Datum)d_value);
                    }
                } else {
                    AQjmsOracleDebug.trace(1, "AQjmsMessage.converPropertyListToHashtable", "Internal error - invalid datum value");
                    AQjmsError.throwEx(122);
                }
                msg_props.put(curr_name, curr_value);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.convertPropertyListToHashtable", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertPropertyListToHashtable", "exit");
        return msg_props;
    }

    static boolean isSystemProperty(String name) {
        return name != null && (name.startsWith("JMSX") || name.startsWith("JMS_Oracle"));
    }

    static boolean isSettableSystemProperty(String name) {
        return m_settableSystemProperties.contains(name);
    }

    void setSystemProperty(String name, Object value) throws JMSException, SQLException {
        block44: {
            try {
                if (m_systemProperties.containsKey(name)) {
                    if (name.equals("JMSXUserID")) {
                        AQjmsError.throwEx(110, name);
                        break block44;
                    }
                    if (name.equals("JMSXAppID")) {
                        if (value instanceof String) {
                            this.header_ext.setAppid((String)value);
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (name.equals("JMSXDeliveryCount")) {
                        AQjmsError.throwEx(110, name);
                        break block44;
                    }
                    if (name.equals("JMSXGroupID")) {
                        if (value instanceof String) {
                            this.header_ext.setGroupid((String)value);
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (name.equals("JMSXGroupSeq")) {
                        if (value instanceof NUMBER) {
                            this.header_ext.setGroupseq(new Integer(((Datum)value).intValue()));
                        } else if (value instanceof String) {
                            try {
                                this.header_ext.setGroupseq(new Integer((String)value));
                            }
                            catch (NumberFormatException nfe) {
                                AQjmsError.throwEx("Failed to set the JMSXGroupSeq property with " + value + ". This property must be a number", (Throwable)nfe);
                            }
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (name.equals("JMSXProducerTXID")) {
                        AQjmsError.throwEx(110);
                        break block44;
                    }
                    if (name.equals("JMSXConsumerTXID")) {
                        AQjmsError.throwEx(110);
                        break block44;
                    }
                    if (name.equals("JMSXRcvTimestamp") || name.equals("JMSXRecvTimestamp")) {
                        AQjmsError.throwEx(110, name);
                        break block44;
                    }
                    if (name.equals("JMSXState")) {
                        AQjmsError.throwEx(110, name);
                        break block44;
                    }
                    if (name.equals("JMS_OracleExcpQ")) {
                        if (value instanceof String) {
                            this.excp_queue = (String)value;
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (name.equals("JMS_OracleDelay")) {
                        if (value instanceof NUMBER) {
                            this.msg_delay = ((Datum)value).intValue();
                        } else if (value instanceof String) {
                            try {
                                this.msg_delay = Integer.parseInt((String)value);
                            }
                            catch (NumberFormatException nfe) {
                                AQjmsError.throwEx("Failed to set the JMS_OracleDelay property with " + value + ". This property must be a number", (Throwable)nfe);
                            }
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (name.equals("JMS_OracleOriginalMessageID")) {
                        AQjmsError.throwEx(110, name);
                        break block44;
                    }
                    if (name.equals("JMS_OracleHeaderOnly")) {
                        AQjmsPropDatum prop_datum = new AQjmsPropDatum(27, "yes");
                        this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
                        break block44;
                    }
                    if (name.equals("JMS_OracleDeliveryMode")) {
                        AQjmsPropDatum prop_datum = new AQjmsPropDatum(27, (String)value);
                        this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
                        break block44;
                    }
                    if (name.equals("JMS_OracleConnectionID")) {
                        if (value instanceof String) {
                            AQjmsPropDatum prop_datum = new AQjmsPropDatum(27, (String)value);
                            this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (name.equals("JMS_OracleTimestamp")) {
                        Object new_value = value;
                        if (value instanceof String) {
                            try {
                                new_value = new NUMBER(Long.parseLong((String)value));
                            }
                            catch (NumberFormatException nfe) {
                                AQjmsError.throwEx("Failed to set the  JMS_OracleTimestamp property with " + value + ". This property must be a number", (Throwable)nfe);
                            }
                        }
                        if (new_value instanceof NUMBER) {
                            AQjmsPropDatum prop_datum = new AQjmsPropDatum(24, (Datum)((NUMBER)new_value));
                            this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    AQjmsError.throwEx(140);
                    break block44;
                }
                AQjmsError.throwEx(140);
            }
            catch (SQLException sql_ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsMessage.setSystemProperty-sqlex", sql_ex);
                throw sql_ex;
            }
        }
    }

    Object getSystemProperty(String name) throws SQLException {
        Object prop_value;
        block20: {
            prop_value = null;
            Object str_value = null;
            int num_value = 0;
            try {
                if (m_systemProperties.containsKey(name)) {
                    if (name.equals("JMSXUserID")) {
                        prop_value = this.header_ext.getUserid();
                        break block20;
                    }
                    if (name.equals("JMSXAppID")) {
                        prop_value = this.header_ext.getAppid();
                        break block20;
                    }
                    if (name.equals("JMSXDeliveryCount")) {
                        return new NUMBER(this.attempts + 1);
                    }
                    if (name.equals("JMSXGroupID")) {
                        prop_value = this.header_ext.getGroupid();
                        break block20;
                    }
                    if (name.equals("JMSXGroupSeq")) {
                        if (this.header_ext.getGroupseq() != null) {
                            num_value = this.header_ext.getGroupseq();
                            prop_value = new NUMBER(num_value);
                            break block20;
                        }
                        return null;
                    }
                    if (name.equals("JMSXProducerTXID")) {
                        return null;
                    }
                    if (name.equals("JMSXConsumerTXID")) {
                        return null;
                    }
                    if (name.equals("JMSXRcvTimestamp") || name.equals("JMSXRecvTimestamp")) {
                        prop_value = new NUMBER(this.recv_time);
                        break block20;
                    }
                    if (name.equals("JMSXState")) {
                        prop_value = new NUMBER(this.msg_state);
                        break block20;
                    }
                    if (name.equals("JMS_OracleExcpQ")) {
                        prop_value = this.excp_queue;
                        break block20;
                    }
                    if (name.equals("JMS_OracleDelay")) {
                        prop_value = new NUMBER(this.msg_delay);
                        break block20;
                    }
                    if (name.equals("JMS_OracleOriginalMessageID")) {
                        prop_value = this.orig_msg_id == null ? null : "ID:" + RepConversion.bArray2String((byte[])this.orig_msg_id);
                        break block20;
                    }
                    if (name.equals("JMS_OracleHeaderOnly")) {
                        Object prop_datum = this.msg_properties.get(name);
                        prop_value = prop_datum != null ? "yes" : null;
                        break block20;
                    }
                    if (name.equals("JMS_OracleConnectionID")) {
                        AQjmsPropDatum prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                        prop_value = prop_datum != null ? prop_datum.getValue() : null;
                        break block20;
                    }
                    if (name.equals("JMS_OracleDeliveryMode")) {
                        Object prop_datum = this.msg_properties.get(name);
                        prop_value = prop_datum != null ? ((AQjmsPropDatum)prop_datum).getStringValue() : null;
                        break block20;
                    }
                    if (name.equals("JMS_OracleTimestamp")) {
                        Object prop_datum = this.msg_properties.get(name);
                        prop_value = prop_datum != null ? ((AQjmsPropDatum)prop_datum).getDatumValue() : null;
                        break block20;
                    }
                    return null;
                }
                return null;
            }
            catch (SQLException sql_ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsMessage.getSystemProperty-sqlex", sql_ex);
                throw sql_ex;
            }
        }
        return prop_value;
    }

    void setReceiveTime(long receive_time) {
        this.recv_time = receive_time;
    }

    void setMessageState(int state) throws JMSException {
        if (state == 0 || state == 1 || state == 2 || state == 3) {
            this.msg_state = state;
        } else {
            AQjmsOracleDebug.trace(1, "AQjmsMessage.setMessageState", "Internal error - invalid message state, msg_state: " + state);
            AQjmsError.throwEx(122);
        }
    }

    void setOriginalMessageId(byte[] id) throws JMSException {
        this.orig_msg_id = id;
    }

    void setExceptionQueue(String excp_q) {
        this.excp_queue = excp_q;
    }

    String getExceptionQueue() {
        return this.excp_queue;
    }

    void setDelay(int delay) {
        this.msg_delay = delay;
    }

    int getDelay() {
        return this.msg_delay;
    }

    public void setSignature(AQjmsSignature signature) {
        this.m_signature = signature;
    }

    public AQjmsSignature getSignature() {
        return this.m_signature;
    }

    void setHeaderOnly() {
        this.m_hdrOnly = true;
    }

    boolean isHeaderOnly() {
        return this.m_hdrOnly;
    }

    int getMsgState() {
        return this.msg_state;
    }

    String getMsgStateAsString() {
        if (this.msg_state == 0) {
            return "READY";
        }
        if (this.msg_state == 1) {
            return "WAITING";
        }
        if (this.msg_state == 2) {
            return "PROCESSED";
        }
        return "EXPIRED";
    }

    void checkPropertyName(String name) throws JMSException {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Property name can not be null or empty string");
        }
    }

    void checkStringPropertyValue(String name, String value) throws JMSException {
        if (value != null) {
            if (name.equalsIgnoreCase("JMSXAppID") || name.equalsIgnoreCase("JMSXUserID") || name.equalsIgnoreCase("JMSXGroupID") || name.equalsIgnoreCase("JMSXType")) {
                if (value.length() > 100) {
                    AQjmsError.throwEx(165);
                }
            } else if (value.length() > 4000) {
                AQjmsError.throwEx(165);
            }
        }
    }

    void insertPropertyIntoTable(Hashtable table, String name, AQjmsPropDatum value) throws JMSException {
        table.put(name, value);
    }

    void validateUserProperties() throws JMSException {
        if (this.msg_properties != null) {
            int numberOfUserProperties = this.msg_properties.size();
            AQjmsOracleDebug.trace(4, "AQjmsMessage.validateUserProperties", "Total number of user properties " + numberOfUserProperties);
            if (numberOfUserProperties > 100) {
                AQjmsError.throwEx(132, "" + numberOfUserProperties);
            }
            Enumeration nameOfUserProperties = this.msg_properties.keys();
            while (nameOfUserProperties.hasMoreElements()) {
                AQjmsPropDatum value;
                int propertyType;
                String propertyName = (String)nameOfUserProperties.nextElement();
                if (propertyName.length() > 100) {
                    AQjmsError.throwEx(148);
                }
                if ((propertyType = (value = (AQjmsPropDatum)this.msg_properties.get(propertyName)).getType()) != 27) continue;
                String propertyValue = (String)value.getValue();
                this.checkStringPropertyValue(propertyName, propertyValue);
            }
        } else {
            AQjmsOracleDebug.trace(4, "AQjmsMessage.validateUserProperties", "There are no user defined properties for this message");
        }
    }

    private static void initSystemPropertyTypeTable() {
        m_systemProperties = new Hashtable();
        m_systemProperties.put("JMSXAppID", m_strClass);
        m_systemProperties.put("JMSXUserID", m_strClass);
        m_systemProperties.put("JMSXRcvTimestamp", m_longClass);
        m_systemProperties.put("JMSXState", m_intClass);
        m_systemProperties.put("JMSXDeliveryCount", m_intClass);
        m_systemProperties.put("JMSXGroupID", m_strClass);
        m_systemProperties.put("JMSXGroupSeq", m_intClass);
        m_systemProperties.put("JMS_OracleExcpQ", m_strClass);
        m_systemProperties.put("JMS_OracleDelay", m_longClass);
        m_systemProperties.put("JMS_OracleOriginalMessageID", m_strClass);
        m_systemProperties.put("JMS_OracleHeaderOnly", m_strClass);
        m_systemProperties.put("JMS_OracleDeliveryMode", m_strClass);
        m_systemProperties.put("JMS_OracleConnectionID", m_strClass);
        m_systemProperties.put("JMS_OracleTimestamp", m_longClass);
        m_settableSystemProperties = new HashSet();
        m_settableSystemProperties.add("JMSXGroupID");
        m_settableSystemProperties.add("JMSXGroupSeq");
    }

    public void printSystemProperties() {
        AQjmsOracleDebug.trace(5, "printSystemProperties", "SYSTEM PROPERTIES");
        try {
            if (this.propertyExists("JMSXAppID")) {
                AQjmsOracleDebug.trace(5, "  JMSXAppID: ", this.getStringProperty("JMSXAppID"));
            }
            if (this.propertyExists("JMSXUserID")) {
                AQjmsOracleDebug.trace(5, "  JMSXUserID: ", this.getStringProperty("JMSXUserID"));
            }
            if (this.propertyExists("JMSXRcvTimestamp")) {
                AQjmsOracleDebug.trace(5, "", "  JMSXRcvTimestamp: " + this.getLongProperty("JMSXRcvTimestamp"));
            }
            if (this.propertyExists("JMSXState")) {
                AQjmsOracleDebug.trace(5, "", "  JMSXState: " + this.getIntProperty("JMSXState"));
            }
            if (this.propertyExists("JMSXDeliveryCount")) {
                AQjmsOracleDebug.trace(5, "", "  JMSXDeliveryCount: " + this.getIntProperty("JMSXDeliveryCount"));
            }
            if (this.propertyExists("JMSXGroupID")) {
                AQjmsOracleDebug.trace(5, "  JMSXGroupID: ", this.getStringProperty("JMSXGroupID"));
            }
            if (this.propertyExists("JMSXGroupSeq")) {
                AQjmsOracleDebug.trace(5, "  JMSXGroupSeq: ", this.getStringProperty("JMSXGroupSeq"));
            }
            if (this.propertyExists("JMS_OracleExcpQ")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleExcpQ: ", this.getStringProperty("JMS_OracleExcpQ"));
            }
            if (this.propertyExists("JMS_OracleDelay")) {
                AQjmsOracleDebug.trace(5, "", "  JMS_OracleDelay: " + this.getLongProperty("JMS_OracleDelay"));
            }
            if (this.propertyExists("JMS_OracleOriginalMessageID")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleOriginalMessageID: ", this.getStringProperty("JMS_OracleOriginalMessageID"));
            }
            if (this.propertyExists("JMS_OracleDeliveryMode")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleDeliveryMode: ", this.getStringProperty("JMS_OracleDeliveryMode"));
            }
            if (this.propertyExists("JMS_OracleConnectionID")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleConnectionID: ", this.getStringProperty("JMS_OracleConnectionID"));
            }
            if (this.propertyExists("JMS_OracleTimestamp")) {
                AQjmsOracleDebug.trace(5, "", "  JMS_OracleTimestamp: " + this.getLongProperty("JMS_OracleTimestamp"));
            }
        }
        catch (JMSException je) {
            AQjmsOracleDebug.trace(5, "PrintSystemPropertied", "Caught JMSException " + je);
        }
    }

    private static String serializeDest(AQjmsDestination dest) throws JMSException {
        StringWriter buf = new StringWriter();
        try {
            buf.write("type=" + (dest.isQueue() ? 10 : 20) + "\n");
            buf.write("owner=" + (dest.isQueue() ? dest.getQueueOwner() : dest.getTopicOwner()) + "\n");
            buf.write("name=" + (dest.isQueue() ? dest.getQueueName() : dest.getTopicName()) + "\n");
            buf.write("table=" + dest.getQueueTableName() + "\n");
            buf.write("pload_type=" + dest.getPloadType() + "\n");
            buf.write("adt_type=" + dest.getAdtType() + "\n");
            if (dest.isSecure()) {
                buf.write("secure=true\n");
            } else {
                buf.write("secure=false\n");
            }
            AQjmsDestinationProperty prop = dest.getProperty();
            buf.write("property.queue_type=" + prop.getQueueType() + "\n");
            buf.write("property.max_retries=" + prop.getMaxRetries() + "\n");
            buf.write("property.retry_interval=" + prop.getRetryInterval() + "\n");
            buf.write("property.retention_time=" + prop.getRetentionTime() + "\n");
            buf.write("property.comment=" + prop.getComment() + "\n");
            buf.write("property.sharded=" + prop.isSharded() + "\n");
            buf.flush();
        }
        catch (Exception e) {
            AQjmsError.throwEx(147);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AQjmsDestination deserializeDest(String buf) throws JMSException {
        if (buf == null) {
            return null;
        }
        ByteArrayInputStream bi = new ByteArrayInputStream(buf.getBytes());
        AQjmsDestination ret = null;
        boolean sec_flag = false;
        try {
            String sec;
            Properties p = new Properties();
            p.load(bi);
            AQjmsDestinationProperty prop = new AQjmsDestinationProperty();
            prop.setQueueType(Integer.parseInt(p.getProperty("property.queue_type")));
            prop.setMaxRetries(Integer.parseInt(p.getProperty("property.max_retries")));
            prop.setRetryInterval((double)new Double(p.getProperty("property.retry_interval")));
            prop.setRetentionTime((double)new Double(p.getProperty("property.retention_time")));
            prop.setComment(p.getProperty("property.comment"));
            String v = p.getProperty("property.sharded");
            if (v != null && v.equals("true")) {
                prop.setSharded(true);
            }
            int type = Integer.parseInt(p.getProperty("type"));
            String owner = p.getProperty("owner");
            String name = p.getProperty("name");
            String table = p.getProperty("table");
            int pload_type = Integer.parseInt(p.getProperty("pload_type"));
            String adt_type = null;
            v = p.getProperty("adt_type");
            if (v != null && !v.equals("null")) {
                adt_type = v;
            }
            if ((sec = p.getProperty("secure")).equalsIgnoreCase("true")) {
                sec_flag = true;
            }
            ret = new AQjmsDestination(owner, name, type, pload_type, adt_type, prop, table, sec_flag);
        }
        catch (Exception e) {
            AQjmsError.throwEx(147);
        }
        finally {
            try {
                if (bi != null) {
                    bi.close();
                }
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    boolean isJMSBody() {
        return this.m_isjmsbody;
    }

    public static int toJMSPriority(int aqp) {
        return 9 - aqp;
    }

    OracleData getMessageCont(AQjmsSession sess, boolean useTemporaryLob, boolean isBulkEnqueue) throws JMSException {
        return null;
    }

    AQjmsGenMessage_C getGenMessageCont(AQjmsSession sess, boolean useTemporaryLob, boolean isBulkEnqueue) throws JMSException {
        return null;
    }

    void writeLob(AQjmsSession jms_sess, AQjmsDestination dest, byte[] msg_id, boolean is_anydata_dest) throws JMSException {
    }

    void messageSendCallback(boolean isBulkEnqueue) throws JMSException {
        this.m_writeLobLater = false;
        if (this.m_tempLob != null) {
            if (AQjmsConstants.CACHE_TEMPLOBS && !isBulkEnqueue) {
                if (this.m_tempLob instanceof OracleBlob) {
                    try {
                        ((OracleBlob)this.m_tempLob).truncate(0L);
                    }
                    catch (Exception e) {
                        AQjmsOracleDebug.traceEx(1, "AQjmsMessage.truncateTemporaryBlob", e);
                        this.freeTemporaryLob(this.m_tempLob);
                        throw new AQjmsTempLobTruncateException(true, e);
                    }
                    finally {
                        this.m_tempLob = null;
                    }
                } else {
                    try {
                        ((OracleClob)this.m_tempLob).truncate(0L);
                    }
                    catch (Exception e) {
                        AQjmsOracleDebug.traceEx(1, "AQjmsMessage.truncateTemporaryClob", e);
                        this.freeTemporaryLob(this.m_tempLob);
                        throw new AQjmsTempLobTruncateException(false, e);
                    }
                    finally {
                        this.m_tempLob = null;
                    }
                }
            } else {
                this.freeTemporaryLob(this.m_tempLob);
                this.m_tempLob = null;
            }
        }
    }

    private void freeTemporaryLob(Object lob) {
        try {
            if (this.m_tempLob instanceof OracleBlob) {
                ((OracleBlob)this.m_tempLob).free();
            } else {
                ((OracleClob)this.m_tempLob).free();
            }
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(1, "AQjmsMessage.freeTemporaryLob", e);
        }
    }

    boolean getWriteLobLater() {
        return this.m_writeLobLater;
    }

    void setWriteLobLater(boolean value) {
        this.m_writeLobLater = value;
    }

    String getJmsHeaders(int deliveryMode) throws JMSException {
        int count = 0;
        StringBuffer buf = new StringBuffer();
        ++count;
        buf.append(",15,JMSDeliveryMode,");
        buf.append(27);
        if (deliveryMode == 2) {
            buf.append(",10,PERSISTENT");
        } else {
            buf.append(",14,NON_PERSISTENT");
        }
        String jmsType = this.getJMSType();
        if (jmsType != null) {
            this.appendOneProp(buf, "JMSType", 27, jmsType);
            ++count;
        }
        try {
            Integer groupseq;
            String groupid;
            String appid;
            String userid;
            String addr;
            AQjmsAgent replyTo = this.header_ext.getReplyto();
            if (replyTo != null && (addr = replyTo.getAddress()) != null) {
                this.appendOneProp(buf, JMS_REPLY_TO, 27, addr);
                ++count;
            }
            if ((userid = this.header_ext.getUserid()) != null) {
                this.appendOneProp(buf, "JMSXUserID", 27, userid);
                ++count;
            }
            if ((appid = this.header_ext.getAppid()) != null) {
                this.appendOneProp(buf, "JMSXAppID", 27, appid);
                ++count;
            }
            if ((groupid = this.header_ext.getGroupid()) != null) {
                this.appendOneProp(buf, "JMSXGroupID", 27, groupid);
                ++count;
            }
            if ((groupseq = this.header_ext.getGroupseq()) != null) {
                this.appendOneProp(buf, "JMSXGroupSeq", 23, groupseq);
                ++count;
            }
        }
        catch (SQLException sqlEx) {
            throw new AQjmsException(sqlEx);
        }
        buf.insert(0, count);
        String r = new String(buf);
        AQjmsOracleDebug.trace(4, "AQjmsMessage.getJmsHeaders", r);
        return r;
    }

    void setJmsHeaders(String headerProperties) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsMessage.setJmsHeaders", "JMS headers string: " + headerProperties);
        if (headerProperties == null) {
            return;
        }
        if (headerProperties.trim().length() == 0) {
            return;
        }
        char[] data = headerProperties.toCharArray();
        int count = 0;
        int pos = this.getPosOfComma(data, 0);
        if (pos <= 0) {
            try {
                count = Integer.parseInt(headerProperties);
                if (count == 0) {
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.invalidHeaderString(headerProperties);
        }
        if ((count = Integer.parseInt(new String(data, 0, pos))) < 0) {
            this.invalidHeaderString(headerProperties);
        }
        ++pos;
        for (int i = 0; i < count; ++i) {
            pos = this.processOneProperty(data, pos, true, headerProperties);
        }
    }

    void setUserProperties(String userProperties) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsMessage.setJmsHeaders", "user properties string: " + userProperties);
        if (userProperties == null) {
            return;
        }
        if (userProperties.trim().length() == 0) {
            return;
        }
        char[] data = userProperties.toCharArray();
        int count = 0;
        int pos = this.getPosOfComma(data, 0);
        if (pos <= 0) {
            try {
                count = Integer.parseInt(userProperties);
                if (count == 0) {
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.invalidUserPropertyString(userProperties);
        }
        if ((count = Integer.parseInt(new String(data, 0, pos))) < 0) {
            this.invalidUserPropertyString(userProperties);
        }
        ++pos;
        for (int i = 0; i < count; ++i) {
            pos = this.processOneProperty(data, pos, false, userProperties);
        }
    }

    private int processOneProperty(char[] data, int start, boolean isJMSHeader, String props) throws JMSException {
        int posComma;
        int len;
        int pos = this.getPosOfComma(data, start);
        if (pos <= 0) {
            this.invalidHeaderOrPropertyString(isJMSHeader, props);
        }
        if ((len = Integer.parseInt(new String(data, start, pos - start))) <= 0 || ++pos + len >= data.length) {
            this.invalidHeaderOrPropertyString(isJMSHeader, props);
        }
        String name = new String(data, pos, len);
        if ((pos += len) >= data.length || data[pos] != ',') {
            this.invalidHeaderOrPropertyString(isJMSHeader, props);
        }
        if ((posComma = this.getPosOfComma(data, ++pos)) <= 0) {
            this.invalidHeaderOrPropertyString(isJMSHeader, props);
        }
        int type = Integer.parseInt(new String(data, pos, posComma - pos));
        pos = posComma + 1;
        if ((posComma = this.getPosOfComma(data, pos)) <= 0) {
            this.invalidHeaderOrPropertyString(isJMSHeader, props);
        }
        len = Integer.parseInt(new String(data, pos, posComma - pos));
        pos = posComma + 1;
        if (len < 0 || pos + len > data.length) {
            this.invalidHeaderOrPropertyString(isJMSHeader, props);
        }
        String value = new String(data, pos, len);
        if ((pos += len) < data.length && data[pos] == ',') {
            ++pos;
        }
        if (!isJMSHeader) {
            this.setOneUserProperty(name, value, type);
        } else {
            this.setOneHeaderProperty(name, value, type);
        }
        return pos;
    }

    final void invalidHeaderString(String s) throws JMSException {
        throw new JMSException("Invalid JMS headers string: " + s);
    }

    final void invalidUserPropertyString(String s) throws JMSException {
        throw new JMSException("Invalid user properties string: " + s);
    }

    final void invalidHeaderOrPropertyString(boolean isHeader, String s) throws JMSException {
        if (isHeader) {
            throw new JMSException("Invalid JMS headers string: " + s);
        }
        throw new JMSException("Invalid user properties string: " + s);
    }

    private void validateTypeCode(int expectedType, int type, String name) throws JMSException {
        if (type != expectedType) {
            throw new JMSException("Invalid headers or properties string: type code of header or property (" + name + ") is invalid, expected type code: " + expectedType, " + found type code: " + type);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setOneHeaderProperty(String name, String value, int type) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsMessage.setOneHeaderProperty", "name=" + name + ", type=" + type + ", value=" + value);
        if (name.equals("JMSDeliveryMode")) {
            this.validateTypeCode(27, type, "JMSDeliveryMode");
            if (value.equals("PERSISTENT")) {
                this.setJMSDeliveryMode(2);
                return;
            } else {
                if (!value.equals("NON_PERSISTENT")) throw new JMSException("Invalid JMS headers string, found invalid property value of JMSDeliveryMode: " + value);
                this.setJMSDeliveryMode(1);
            }
            return;
        } else if (name.equals("JMSType")) {
            this.validateTypeCode(27, type, "JMSType");
            this.setJMSType(value);
            return;
        } else if (name.equals(JMS_REPLY_TO)) {
            this.validateTypeCode(27, type, JMS_REPLY_TO);
            AQjmsAgent agent = null;
            try {
                agent = new AQjmsAgent(JMS_REPLY_TO, value);
                this.header_ext.setReplyto(agent);
                return;
            }
            catch (SQLException sqlEx) {
                throw new AQjmsException(sqlEx);
            }
        } else {
            if (!name.startsWith("JMSX")) throw new JMSException("Invalid JMS headers string, found invalid header name: " + name);
            if (!this.setOneSystemProperty(name, value, type)) return;
            return;
        }
    }

    private void setOneUserProperty(String name, String value, int type) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsMessage.setOneUserProperty", "name=" + name + ", type=" + type + ", value=" + value);
        if (name.startsWith("JMSX") && this.setOneSystemProperty(name, value, type)) {
            return;
        }
        switch (type) {
            case 27: {
                this.setStringProperty2(name, value);
                break;
            }
            case 20: {
                if (value.equals("1")) {
                    this.setBooleanProperty(name, true);
                    break;
                }
                if (value.equals("0")) {
                    this.setBooleanProperty(name, false);
                    break;
                }
                throw new JMSException("Invalid boolean value, name: " + name + ", value: " + value);
            }
            case 21: {
                byte b = Byte.parseByte(value);
                this.setByteProperty(name, b);
                break;
            }
            case 22: {
                short s = Short.parseShort(value);
                this.setShortProperty(name, s);
                break;
            }
            case 23: {
                int i = Integer.parseInt(value);
                this.setIntProperty(name, i);
                break;
            }
            case 24: {
                long l = Long.parseLong(value);
                this.setLongProperty(name, l);
                break;
            }
            case 25: {
                float f = Float.parseFloat(value);
                this.setFloatProperty(name, f);
                break;
            }
            case 26: {
                double d = Double.parseDouble(value);
                this.setDoubleProperty(name, d);
                break;
            }
            default: {
                throw new JMSException("Invalid type code, name: " + name + ", type: " + type);
            }
        }
    }

    private boolean setOneSystemProperty(String name, String value, int type) throws JMSException {
        try {
            if (name.equals("JMSXUserID")) {
                this.validateTypeCode(27, type, "JMSXUserID");
                this.header_ext.setUserid(value);
                return true;
            }
            if (name.equals("JMSXAppID")) {
                this.validateTypeCode(27, type, "JMSXAppID");
                this.header_ext.setAppid(value);
                return true;
            }
            if (name.equals("JMSXGroupID")) {
                this.validateTypeCode(27, type, "JMSXGroupID");
                this.header_ext.setGroupid(value);
                return true;
            }
            if (name.equals("JMSXGroupSeq")) {
                this.validateTypeCode(23, type, "JMSXGroupSeq");
                try {
                    this.header_ext.setGroupseq(new Integer(value));
                    return true;
                }
                catch (NumberFormatException nfe) {
                    AQjmsError.throwEx("Failed to set the JMSXGroupSeq property with value: " + value + ". This property must be a number", (Throwable)nfe);
                }
            }
        }
        catch (SQLException sqlEx) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.setOneSystemProperty", sqlEx);
            AQjmsError.throwEx(119, (Throwable)sqlEx);
        }
        return false;
    }

    private int getPosOfComma(char[] data, int start) {
        int pos;
        for (pos = start; pos < data.length && data[pos] != ','; ++pos) {
        }
        if (pos < data.length) {
            return pos;
        }
        return -1;
    }

    public String test_getUserProperties() throws JMSException {
        return this.getUserProperties();
    }

    String getUserProperties() throws JMSException {
        int numProps = this.msg_properties.size();
        StringBuffer buf = new StringBuffer(numProps * 20);
        Enumeration nameEnum = this.msg_properties.keys();
        int i = 0;
        while (nameEnum.hasMoreElements()) {
            String name = (String)nameEnum.nextElement();
            AQjmsPropDatum value = (AQjmsPropDatum)this.msg_properties.get(name);
            int type = value.getType();
            Object dValue = value.getValue();
            this.appendOneProp(buf, name, type, dValue);
            ++i;
        }
        buf.insert(0, numProps);
        String r = new String(buf);
        AQjmsOracleDebug.trace(4, "AQjmsMessage.getUserProperties()", r);
        return r;
    }

    private void appendOneProp(StringBuffer buf, String name, int type, Object dValue) throws JMSException {
        buf.append(',');
        buf.append(name.length());
        buf.append(',');
        buf.append(name);
        buf.append(',');
        buf.append(type);
        buf.append(',');
        String strValue = null;
        if (type == 27) {
            strValue = (String)dValue;
        } else if (type == 25) {
            strValue = ((Float)dValue).toString();
        } else if (type == 26) {
            strValue = ((Double)dValue).toString();
        } else if (dValue instanceof NUMBER) {
            BigDecimal num = null;
            try {
                num = ((Datum)dValue).bigDecimalValue();
            }
            catch (SQLException sqle) {
                AQjmsError.throwEx(sqle.getMessage(), (Throwable)sqle);
            }
            strValue = num.toString();
        } else if (type == 23) {
            strValue = dValue.toString();
        } else {
            throw new JMSException("error: getUserProperties() type unkown");
        }
        buf.append(strValue.length());
        buf.append(',');
        buf.append(strValue);
    }

    private int getSystemProperties(StringBuffer buf) throws JMSException, SQLException {
        int type;
        int count = 0;
        String name = "JMSXUserID";
        Object dValue = this.getSystemProperty(name);
        if (dValue != null) {
            ++count;
            type = 27;
            this.appendOneProp(buf, name, type, dValue);
        }
        if ((dValue = this.getSystemProperty(name = "JMSXAppID")) != null) {
            ++count;
            type = 27;
            this.appendOneProp(buf, name, type, dValue);
        }
        if ((dValue = this.getSystemProperty(name = "JMSXGroupID")) != null) {
            ++count;
            type = 27;
            this.appendOneProp(buf, name, type, dValue);
        }
        if ((dValue = this.getSystemProperty(name = "JMSXGroupSeq")) != null) {
            ++count;
            type = 23;
            this.appendOneProp(buf, name, type, dValue);
        }
        return count;
    }

    byte[] getBytesCont() throws JMSException {
        return null;
    }

    private void checkNullPropertyName(String propertyName) throws JMSException {
        if (propertyName == null) {
            AQjmsError.throwEx(139);
        }
    }

    InputStream getInputStream() {
        return this.m_inputStream;
    }

    public long getBodyLength() throws JMSException {
        return this.bodyLength;
    }

    void setBodyLength(long bodyLength) {
        this.bodyLength = bodyLength;
    }

    public boolean isLargeBody() {
        return this.largeBody;
    }

    void setLargeBody(boolean largeBody) {
        this.largeBody = largeBody;
    }

    byte[] getLobLocator() {
        return this.lobLocator;
    }

    void setLobLocator(byte[] lobLocator) {
        this.lobLocator = lobLocator;
    }

    void invalidReadWithStreaming(String methodName) throws JMSException {
        AQjmsError.throwEx(252, methodName);
    }

    void setInputStream(InputStream inputStream) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (inputStream == null) {
            AQjmsError.throwEx(249);
        }
        this.validateStreamingSupport();
        this.m_inputStream = inputStream;
    }

    void validateStreamingSupport() throws JMSException {
        if (!AQjmsConstants.useJmsStreaming()) {
            AQjmsError.throwEx(248);
        }
        if (this.getJMSDestination() != null && !((AQjmsDestination)this.getJMSDestination()).isSharded()) {
            AQjmsError.throwInvalidDestEx(245);
        }
        if (this.session == null) {
            AQjmsError.throwEx(194);
        }
        if (this.session.getAcknowledgeMode() == 1 || this.session.getAcknowledgeMode() == 3) {
            AQjmsError.throwEx(255);
        }
        if (!this.session.getDriver().equalsIgnoreCase("thin")) {
            AQjmsError.throwEx(246, this.session.getDriver());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized OutputStream getBody(OutputStream outputStream, int chunkSize, long timeout) throws JMSException {
        if (outputStream == null) {
            AQjmsError.throwEx(250);
        }
        if (this.message_id.getJMSMessageID() == null) {
            AQjmsError.throwEx(253, "getBody");
        }
        this.validateStreamingSupport();
        if (this.session.isSessionClosed()) {
            AQjmsError.throwIllegalStateEx(131, null);
        }
        if (!this.isLargeBody()) {
            AQjmsError.throwEx(254);
        }
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        if (timeout <= 0L) {
            timeout = -1L;
        }
        OracleConnection dbConn = null;
        try {
            dbConn = (OracleConnection)this.session.getDBConnection();
        }
        catch (Exception ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.getBody", ex);
            AQjmsError.throwEx(112, (Throwable)ex);
        }
        AQjmsOracleDebug.trace(5, "AQjmsMessage.getBody", "After getDbConnection");
        BLOB blobObject = null;
        InputStream inputStream = null;
        try {
            blobObject = dbConn.createBlob(this.getLobLocator());
            if (blobObject.isEmptyLob()) {
                throw new AQjmsException("LOB Locator is null in Encounter null in getBody", 122);
            }
            inputStream = blobObject.getBinaryStream();
            if (chunkSize <= 0) {
                chunkSize = 8192;
            }
            byte[] data = new byte[chunkSize];
            int length = 0;
            if (timeout == -1L) {
                while ((length = inputStream.read(data)) != -1) {
                    outputStream.write(data, 0, length);
                }
            } else {
                long maxTimeInMillis = System.currentTimeMillis() + timeout;
                while ((length = inputStream.read(data)) != -1) {
                    if (System.currentTimeMillis() < maxTimeInMillis) {
                        outputStream.write(data, 0, length);
                        continue;
                    }
                    throw new TimeoutException("The timeout value specified, " + timeout + " ms exceeded, getBody timed out.");
                }
            }
        }
        catch (SQLException sqlExp) {
            AQjmsError.throwEx(120, (Throwable)sqlExp);
        }
        catch (Exception exp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.getBody", exp);
            AQjmsError.throwEx(120, (Throwable)exp);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "AQjmsMessage.getBody", exception);
            }
            try {
                if (blobObject != null) {
                    blobObject.free();
                    blobObject.close();
                }
            }
            catch (SQLException exception) {}
        }
        return outputStream;
    }

    public <T> T getBody(Class<T> outputStream) throws JMSException {
        if (outputStream.isAssignableFrom(OutputStream.class)) {
            OutputStream outStream = (OutputStream)outputStream.cast(outputStream);
            return outputStream.cast(this.getBody(outStream, 0, 0L));
        }
        AQjmsError.throwEx(102);
        return null;
    }

    public long getJMSDeliveryTime() throws JMSException {
        AQjmsError.throwEx(102);
        return 0L;
    }

    public boolean isBodyAssignableTo(Class arg0) throws JMSException {
        AQjmsError.throwEx(102);
        return false;
    }

    public void setJMSDeliveryTime(long arg0) throws JMSException {
        AQjmsError.throwEx(102);
    }

    static {
        AQjmsMessage.initSystemPropertyTypeTable();
    }
}

