/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.jakarta.jms.AQjmsAgent;
import oracle.jakarta.jms.AQjmsConsumer;
import oracle.jakarta.jms.AQjmsConsumerExceptionListener;
import oracle.jakarta.jms.AQjmsDestination;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsException;
import oracle.jakarta.jms.AQjmsMessage;
import oracle.jakarta.jms.AQjmsObject;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsSession;
import oracle.jakarta.jms.AQjmsUtil;
import oracle.jdbc.aq.AQAgent;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.internal.JMSConsumerExceptionListener;
import oracle.jdbc.internal.JMSMessageProperties;
import oracle.jdbc.internal.JMSNotificationEvent;
import oracle.jdbc.internal.JMSNotificationListener;
import oracle.jdbc.internal.JMSNotificationRegistration;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;

class AQjmsNtfRegistration
extends AQjmsObject {
    private AQjmsSession session;
    private AQjmsConsumer consumer;
    private MessageListener msgListener;
    private JMSNotificationRegistration registration;
    private AQjmsNotificationListener aqjmsListener;
    private AQjmsConsumerExceptionListener consumerExcpListener;
    private byte[] lastMessageID;
    int mode = -1;

    AQjmsNtfRegistration(AQjmsConsumer c, AQjmsSession sess, MessageListener l) throws JMSException {
        super("AQjmsNtfRegistration", c);
        this.consumer = c;
        this.session = sess;
        this.msgListener = l;
        this.aqjmsListener = new AQjmsNotificationListener();
        this.mode = this.session.getAcknowledgeMode();
    }

    synchronized void registerJdbcNotification() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.registerJdbcNotification", "entry");
        AQjmsDestination dest = this.consumer.cons_dest;
        String destName = dest.getCompleteName();
        Object name = null;
        name = dest.isTopic() ? destName + ":" + this.consumer.cons_name : destName;
        String[] names = new String[]{name};
        HashMap<String, Properties> opts = new HashMap<String, Properties>();
        Properties opt = new Properties();
        opt.setProperty("NTF_AQ_PAYLOAD", "true");
        opt.setProperty("NTF_QOS_SECURE", "true");
        opt.setProperty("NTF_ASYNC_DEQ", "true");
        opt.setProperty("NTF_QOS_TX_ACK", "true");
        try {
            String maxConnStr = AQjmsUtil.getSystemProperty("oracle.jms.max_ntf_connections");
            if (maxConnStr != null) {
                Properties ntfProp = new Properties();
                ntfProp.setProperty("MAX_NTF_CONNECTIONS", maxConnStr);
                opts.put("NOTIFICATION", ntfProp);
            }
        }
        catch (Exception maxConnStr) {
            // empty catch block
        }
        opts.put((String)name, opt);
        Map<String, JMSNotificationRegistration> regs = null;
        try {
            AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.registerJdbcNotification", "before session.registerJMSNotification, name: " + names[0]);
            String selectorRule = null;
            if (!this.consumer.cons_dest.isTopic() && this.consumer.getAQjmsSelector() != null) {
                selectorRule = this.consumer.getAQjmsSelector().getRule();
            }
            AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.registerJdbcNotification", "selectorRule: " + selectorRule);
            regs = this.session.registerJMSNotification(names, opts, selectorRule);
            this.registration = regs.get(name);
            AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.registerJdbcNotification", "after session.registerJMSNotification, registration: " + String.valueOf(this.registration));
            this.registration.addListener((JMSNotificationListener)this.aqjmsListener);
            AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.registerJdbcNotification", "listener added for the registration: " + String.valueOf(this.registration));
            this.consumerExcpListener = new AQjmsConsumerExceptionListener(this, this.session);
            this.registration.setConsumerExceptionListener((JMSConsumerExceptionListener)this.consumerExcpListener);
            this.session.addConsumerExcpLsnr(this.consumerExcpListener);
            if (this.isStarted()) {
                this.session.startJMSNotification(this.registration);
                AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.registerJdbcNotification", "state of the registration " + String.valueOf(this.registration.getState()));
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.registerJdbcNotification", "connection is not yet started, starting the JMS Notification is deferred to the start of the Connection");
            }
        }
        catch (SQLException sqlEx) {
            AQjmsError.throwEx("Failed to register notification", (Throwable)sqlEx);
        }
    }

    void disableConsumerExceptionListener() {
        if (this.consumerExcpListener == null) {
            return;
        }
        this.consumerExcpListener.disable();
    }

    private void unregisterJdbcNotification() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.unregisterJdbcNotification", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.unregisterJdbcNotification", "registration: " + String.valueOf(this.registration));
        try {
            this.session.unregisterJMSNotification(this.registration);
            AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.unregisterJdbcNotification", "session.unregisterJMSNotification is done for registration: " + String.valueOf(this.registration));
            this.registration = null;
        }
        catch (SQLException sqlEx) {
            AQjmsError.throwEx("Failed to unregister notification", (Throwable)sqlEx);
        }
    }

    synchronized void setMessageListener(MessageListener l) throws JMSException {
        this.msgListener = l;
        if (this.msgListener == null) {
            this.close();
        }
    }

    synchronized MessageListener getMessageListener() {
        return this.msgListener;
    }

    byte[] getLastMessageId() {
        return this.lastMessageID;
    }

    void setLastMessageId(byte[] _messageID) {
        this.lastMessageID = _messageID;
    }

    JMSNotificationRegistration getJDBCRegistration() {
        return this.registration;
    }

    @Override
    protected synchronized void localClose() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.localClose", "entry");
        this.msgListener = null;
        this.unregisterJdbcNotification();
    }

    private void ackLastJMSNotification(JMSNotificationRegistration.Directive hint) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.ackLastJMSNotification", "entry registration=" + String.valueOf(this.registration) + " lastMessageID=" + (this.lastMessageID == null ? "null" : RepConversion.bArray2String((byte[])this.lastMessageID)));
        if (this.registration != null && this.lastMessageID != null) {
            try {
                this.session.ackJMSNotification(this.registration, this.lastMessageID, hint);
                AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.ackLastJMSNotification", "after called session.ackJMSNotification");
                this.lastMessageID = null;
            }
            catch (SQLException sqlEx) {
                AQjmsError.throwEx("failed to ack last notified message", (Throwable)sqlEx);
            }
        } else {
            AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.ackLastJMSNotification", "no registration or last message id is null, nothing needs to be done");
        }
    }

    @Override
    protected void startJMSNotification() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.startJMSNotification", "entry");
        try {
            OracleConnection conn = (OracleConnection)this.session.getDBConnection();
            conn.startJMSNotification(this.registration);
            AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.startJMSNotification", "state of the registration " + String.valueOf(this.registration.getState()));
        }
        catch (SQLException sqlException) {
            AQjmsError.throwEx("failed to start the JMS Notification", (Throwable)sqlException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.startJMSNotification", "exit");
    }

    @Override
    protected void stopJMSNotification() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.stopJMSNotification", "entry");
        try {
            OracleConnection conn = (OracleConnection)this.session.getDBConnection();
            conn.stopJMSNotification(this.registration);
        }
        catch (SQLException sqlException) {
            AQjmsError.throwEx("failed to stop the JMS Notification", (Throwable)sqlException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.stopJMSNotification", "exit");
    }

    protected boolean isRegistrationDisabled() throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.isRegistrationDisabled", "state of the registration " + String.valueOf(this.registration.getState()));
        return "DISABLED".equalsIgnoreCase(this.registration.getState().toString());
    }

    private class AQjmsNotificationListener
    implements JMSNotificationListener {
        private AQjmsNotificationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onJMSNotification(JMSNotificationEvent event) {
            AQjmsOracleDebug.trace(4, "AQjmsNotificationListener.onJMSNotification", "entry registration" + String.valueOf(AQjmsNtfRegistration.this.registration));
            if (AQjmsNtfRegistration.this.isClosed()) {
                return;
            }
            AQjmsNtfRegistration aQjmsNtfRegistration = AQjmsNtfRegistration.this;
            synchronized (aQjmsNtfRegistration) {
                if (AQjmsNtfRegistration.this.registration == null) {
                    AQjmsOracleDebug.trace(4, "AQjmsNotificationListener.onJMSNotification", "Received messaged after unregistration");
                    return;
                }
                byte[] msgId = null;
                AQjmsMessage message = null;
                AQjmsConsumerExceptionListener cel = null;
                try {
                    cel = (AQjmsConsumerExceptionListener)AQjmsNtfRegistration.this.registration.getConsumerExceptionListener();
                    if (cel != null && !cel.isActive()) {
                        return;
                    }
                    msgId = event.getMessageId();
                    byte[] payload = event.getPayload();
                    JMSMessageProperties jmsMsgProps = event.getJMSMessageProperties();
                    AQMessageProperties aqMsgProps = event.getMessageProperties();
                    String headerProperties = jmsMsgProps.getHeaderProperties();
                    String userProperties = jmsMsgProps.getUserProperties();
                    JMSMessageProperties.JMSMessageType msgType = jmsMsgProps.getJMSMessageType();
                    int type = msgType.getCode();
                    int priority = aqMsgProps.getPriority();
                    int expiration = aqMsgProps.getExpiration();
                    String corrId = aqMsgProps.getCorrelation();
                    AQjmsOracleDebug.trace(5, "AQjmsNotificationListener.onJMSNotification", "msg_id: " + RepConversion.bArray2String((byte[])msgId) + " type: " + type + " corrid: " + corrId + " priority: " + priority + " headerProperties: " + headerProperties + " userProperties: " + userProperties);
                    message = AQjmsConsumer.convertToAQjmsMessages(AQjmsNtfRegistration.this.session, type, payload, headerProperties, userProperties, msgId, priority, corrId, expiration);
                    Timestamp timestampEnqTime = aqMsgProps.getEnqueueTime();
                    long enqTime = timestampEnqTime.getTime();
                    message.setEnqueueTime(enqTime);
                    message.setMessageState(aqMsgProps.getState().getCode());
                    int msgDelay = aqMsgProps.getDelay();
                    message.setDelay(msgDelay);
                    int expTime = aqMsgProps.getExpiration();
                    message.setJMSExpiration(expTime);
                    int attempts = aqMsgProps.getDequeueAttemptsCount();
                    message.setAttempts(attempts);
                    if (attempts > 0) {
                        message.setJMSRedelivered(true);
                    } else {
                        message.setJMSRedelivered(false);
                    }
                    String exceptionQueue = aqMsgProps.getExceptionQueue();
                    message.setExceptionQueue(exceptionQueue);
                    AQAgent jdbcAQAgent = aqMsgProps.getSender();
                    if (jdbcAQAgent != null && jdbcAQAgent.getName() != null && !jdbcAQAgent.getName().equals("")) {
                        AQjmsAgent sender = new AQjmsAgent(jdbcAQAgent.getName(), jdbcAQAgent.getAddress(), jdbcAQAgent.getProtocol());
                        message.setSenderID(sender);
                    }
                    message.setOriginalMessageId(aqMsgProps.getPreviousQueueMessageId());
                    if (message.getJMSExpiration() <= 0L) {
                        message.setJMSExpiration(0L);
                    } else {
                        message.setJMSExpiration(message.getJMSExpiration() * 1000L + message.getJMSTimestamp());
                    }
                    long recvTime = System.currentTimeMillis();
                    message.setReceiveTime(recvTime);
                    message.setPropReadOnly(true);
                    message.setJMSDestination((Destination)AQjmsNtfRegistration.this.consumer.cons_dest);
                }
                catch (Exception exp) {
                    AQjmsOracleDebug.traceEx(3, "AQjmsNotificationListener.onJMSNotification: Got Exception when fetching message from JMSNotificationEvent " + String.valueOf(event), exp);
                    throw new RuntimeException(exp);
                }
                AQjmsException oe = null;
                try {
                    if (AQjmsNtfRegistration.this.isClosed() || AQjmsNtfRegistration.this.msgListener == null) {
                        AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "consumer is closed or listener is set to null");
                        return;
                    }
                    AQjmsNtfRegistration.this.lastMessageID = msgId;
                    try {
                        AQjmsNtfRegistration.this.session.lock("AQjmsNotificationListener.onJMSNotification", -1L);
                        AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "locked the session");
                    }
                    catch (IllegalStateException ise) {
                        AQjmsOracleDebug.traceEx(3, "AQjmsNotificationListener.onJMSNotification: Got IllegalStateException when try to lock session", ise);
                        AQjmsNtfRegistration.this.session.stopListener();
                        return;
                    }
                    AQjmsNtfRegistration.this.session.startListener();
                    AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "before calling onMessage method");
                    AQjmsNtfRegistration.this.msgListener.onMessage((Message)message);
                    AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "after calling onMessage method");
                }
                catch (Throwable th) {
                    oe = new AQjmsException("Error in onMessage Method", th);
                    AQjmsOracleDebug.traceEx(3, "AQjmsNotificationListener.onJMSNotification: error in onMessage of MessageListener class", (Throwable)((Object)oe));
                }
                finally {
                    AQjmsNtfRegistration.this.session.stopListener();
                }
                try {
                    AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "session.getAcknowledgeMode: " + AQjmsNtfRegistration.this.mode);
                    if (AQjmsNtfRegistration.this.mode == 1 || AQjmsNtfRegistration.this.mode == 3) {
                        if (oe == null) {
                            AQjmsNtfRegistration.this.ackLastJMSNotification(JMSNotificationRegistration.Directive.COMMIT);
                            AQjmsNtfRegistration.this.session.commitNoCheck();
                            AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "acknowledged the message just received");
                        } else {
                            AQjmsNtfRegistration.this.ackLastJMSNotification(JMSNotificationRegistration.Directive.ROLLBACK);
                            AQjmsNtfRegistration.this.session.forceRollback();
                            AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "recovered the message just received");
                        }
                    }
                }
                catch (JMSException jmsExp) {
                    boolean throwError = false;
                    try {
                        AQjmsOracleDebug.traceEx(3, "AQjmsNotificationListener.onJMSNotification: error in acknowledgement or recovery after onMessage", jmsExp);
                        int errcode = 0;
                        Exception linkedExcp = jmsExp.getLinkedException();
                        if (linkedExcp instanceof SQLException) {
                            SQLException sqlExp = (SQLException)linkedExcp;
                            errcode = sqlExp.getErrorCode();
                        }
                        if (cel != null && errcode == 24035) {
                            cel.raiseConsumerClosedException(AQjmsNtfRegistration.this.session, linkedExcp.getMessage());
                        } else if (cel != null && errcode == 24010) {
                            cel.raiseDestinationClosedException(AQjmsNtfRegistration.this.session, linkedExcp.getMessage());
                        } else {
                            throwError = true;
                        }
                    }
                    catch (Exception excp) {
                        throwError = true;
                    }
                    if (throwError) {
                        throw new RuntimeException(jmsExp);
                    }
                }
                catch (Exception exp) {
                    AQjmsOracleDebug.traceEx(3, "AQjmsNotificationListener.onJMSNotification: error in acknowledgement or recovery after onMessage", exp);
                    throw new RuntimeException(exp);
                }
                finally {
                    AQjmsNtfRegistration.this.session.unlock("AQjmsNotificationListener.onJMSNotification");
                    AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "unlocked the session");
                }
            }
        }
    }
}

