/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms.plsql;

import java.io.IOException;
import oracle.jakarta.jms.plsql.InvalidIdException;
import oracle.jakarta.jms.plsql.MsgEntity;
import oracle.jakarta.jms.plsql.MsgStoreOverflowException;

class MsgStore {
    static int defaultSize = 20;
    private int msgType;
    private int storeSize;
    private MsgEntity[] msgArray;

    MsgStore(int msgType) {
        this.msgType = msgType;
        this.storeSize = defaultSize;
        this.msgArray = new MsgEntity[this.storeSize];
        for (int i = 0; i < this.storeSize; ++i) {
            this.msgArray[i] = null;
        }
    }

    MsgEntity getMsgEntity(int id) throws InvalidIdException {
        if (id < 0 || id >= this.storeSize || this.msgArray[id] == null) {
            throw new InvalidIdException();
        }
        return this.msgArray[id];
    }

    int createMsgEntity() throws MsgStoreOverflowException, IOException, ClassNotFoundException {
        return this.createMsgEntity(null);
    }

    int createMsgEntity(byte[] data) throws MsgStoreOverflowException, IOException, ClassNotFoundException {
        for (int i = 0; i < this.storeSize; ++i) {
            if (this.msgArray[i] != null) continue;
            this.msgArray[i] = MsgEntity.createMsgEntity(this.msgType, data);
            return i;
        }
        throw new MsgStoreOverflowException();
    }

    int createMsgEntity(int id) throws InvalidIdException, MsgStoreOverflowException, IOException, ClassNotFoundException {
        return this.createMsgEntity(id, null);
    }

    int createMsgEntity(int id, byte[] data) throws InvalidIdException, MsgStoreOverflowException, IOException, ClassNotFoundException {
        if (id < 0 || id >= this.storeSize) {
            throw new InvalidIdException();
        }
        if (this.msgArray[id] != null) {
            this.msgArray[id].clean();
        }
        this.msgArray[id] = MsgEntity.createMsgEntity(this.msgType, data);
        return id;
    }

    void cleanMsgEntity(int id) throws InvalidIdException, IOException {
        if (id < 0 || id >= this.storeSize || this.msgArray[id] == null) {
            throw new InvalidIdException();
        }
        this.msgArray[id].clean();
        this.msgArray[id] = null;
    }

    void cleanAllMsgEntity() throws IOException {
        for (int i = 0; i < this.storeSize; ++i) {
            if (this.msgArray[i] == null) continue;
            this.msgArray[i].clean();
            this.msgArray[i] = null;
        }
    }

    static void setDefaultSize(int size) {
        defaultSize = size;
    }
}

