/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class GDKOracleMetaData {
    private static final String GDK_NAME = "Oracle Globalization Development Kit";
    public static final String s_gdkVersion = "23.0.0.0.0";
    public static final String s_gdkVersionFull = "23.9.0.25.07";
    public static final String s_gdkFirstYear = "2003";
    public static final String s_gdkCurrentYear = "2025";
    public static final String s_gdkCopyright = "Copyright (c) 2003, 2025, Oracle and/or its affiliates.  All right reserved.";
    public static final String s_gdkStatus = "Limited Production";
    private static final String GDK_VERSION = "Release 23.0.0.0.0 - Limited Production";
    private static final String GDK_VERSIONFULL = "Version 23.9.0.25.07";
    private static final String GDK_COPYRIGHT = "Copyright (c) 2003, 2025, Oracle and/or its affiliates.  All right reserved.";
    private static long OracleVersionID = 100000000000L;
    private static final String GDK_DATA_PATH = "/oracle/i18n/data/";
    static final String README_NAME = "oracle/i18n/readme.txt";
    private static String[] M_PLUGINS = new String[]{"oracle.i18n.util.CharConvRepackage"};

    private GDKOracleMetaData() {
    }

    public static long getOracleVersionID() {
        return OracleVersionID;
    }

    public static String getName() {
        return GDK_NAME;
    }

    public static String getVersion() {
        return GDK_VERSION;
    }

    public static String getVersionFull() {
        return GDK_VERSIONFULL;
    }

    public static String getCopyright() {
        return "Copyright (c) 2003, 2025, Oracle and/or its affiliates.  All right reserved.";
    }

    public static String getNameVersion() {
        return GDKOracleMetaData.getName() + ": " + GDKOracleMetaData.getVersion();
    }

    public static String getDataPath() {
        return GDK_DATA_PATH;
    }

    public static String getBanner(String string) {
        StringBuffer stringBuffer = new StringBuffer(string).append(": Release ").append(s_gdkVersion).append(" - ").append(s_gdkStatus).append(System.getProperty("line.separator")).append("Version ").append(s_gdkVersionFull).append(System.getProperty("line.separator")).append(System.getProperty("line.separator")).append("Copyright (c) 2003, 2025, Oracle and/or its affiliates.  All right reserved.").append(System.getProperty("line.separator")).append(System.getProperty("line.separator"));
        return stringBuffer.toString();
    }

    public static final void main(String[] stringArray) throws Exception {
        int n;
        Class<GDKOracleMetaData> clazz = GDKOracleMetaData.class;
        InputStream inputStream = clazz.getResourceAsStream("/oracle/i18n/readme.txt");
        if (inputStream != null) {
            GDKOracleMetaData.printVersion();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "iso-8859-1");
            char[] cArray = new char[8192];
            int n2 = -1;
            while ((n2 = inputStreamReader.read(cArray, 0, cArray.length)) != -1) {
                String string = new String(cArray, 0, n2);
                System.out.print(string);
            }
            inputStream.close();
            return;
        }
        if (stringArray.length == 0) {
            GDKOracleMetaData.printUsage();
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        if ("-version".equals(arrayList.get(0))) {
            GDKOracleMetaData.printVersion();
            return;
        }
        n = 0;
        for (int i = 0; i < M_PLUGINS.length; ++i) {
            Object object = GDKOracleMetaData.callStaticMethod(M_PLUGINS[i], "getCommand", null, null);
            if (object == null || !object.equals(arrayList.get(0))) continue;
            n = 1;
            arrayList.remove(0);
            GDKOracleMetaData.callStaticMethod(M_PLUGINS[i], "main", new Class[]{List.class}, new Object[]{arrayList});
        }
        if (n == 0) {
            GDKOracleMetaData.printUsage();
        }
    }

    private static final void printVersion() {
        System.out.printf("%s", GDKOracleMetaData.getBanner(GDK_NAME));
    }

    private static final void printUsage() {
        GDKOracleMetaData.printBaseUsage();
        System.out.println("  -version : Displays the GDK version");
        for (int i = 0; i < M_PLUGINS.length; ++i) {
            GDKOracleMetaData.callStaticMethod(M_PLUGINS[i], "printUsage", null, null);
        }
    }

    static final void printBaseUsage() {
        System.out.println("Usage: java -jar orai18n.jar <option>");
        System.out.println("<option> :=");
    }

    private static Object callStaticMethod(String string, String string2, Class[] classArray, Object[] objectArray) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.getMethod(string2, classArray).invoke((Object)classArray, objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

