/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.as.jmx.framework.mapping.CustomOpenTypeMapper;
import oracle.dfw.impl.incident.IncidentImpl;
import oracle.dfw.incident.ErrorMessage;
import oracle.dfw.incident.Incident;

public class IncidentImplCustomOpenTypeMapper
implements CustomOpenTypeMapper<IncidentImpl> {
    private static CompositeType s_compositeType;
    private static String[] s_itemNames;
    private static CompositeType s_incidentKeysType;
    private static String[] s_incidentKeysItemNames;
    private static CompositeType s_errorType;
    private static String[] s_errorItemNames;
    private static String[] s_emptyStringArray;

    public CompositeType toCompositeType() {
        if (s_compositeType == null) {
            try {
                ArrayType errorArgumentsType = new ArrayType(1, SimpleType.STRING);
                s_errorType = new CompositeType("oracle.dfw.incident.ErrorMessage", "oracle.dfw.incident.ErrorMessage", s_errorItemNames, s_errorItemNames, new OpenType[]{SimpleType.STRING, SimpleType.STRING, errorArgumentsType});
                s_incidentKeysType = new CompositeType("incidentKeys", "incidentKeys", s_incidentKeysItemNames, s_incidentKeysItemNames, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
                ArrayType incidentFilesType = new ArrayType(1, SimpleType.STRING);
                s_compositeType = new CompositeType("oracle.dfw.incident.Incident", "oracle.dfw.incident.Incident", s_itemNames, s_itemNames, new OpenType[]{SimpleType.STRING, SimpleType.STRING, s_errorType, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING, incidentFilesType, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.DATE, SimpleType.STRING, new ArrayType(1, s_incidentKeysType)});
            }
            catch (OpenDataException ode) {
                throw new RuntimeException(ode);
            }
        }
        return s_compositeType;
    }

    public CompositeData toCompositeData(IncidentImpl incident) {
        if (incident == null) {
            throw new IllegalArgumentException();
        }
        try {
            CompositeDataSupport errorData = null;
            if (incident.getErrorMessage() != null) {
                ErrorMessage errMsg = incident.getErrorMessage();
                String[] arguments = null;
                if (errMsg.getErrorArguments() != null && errMsg.getErrorArguments().size() > 0) {
                    arguments = errMsg.getErrorArguments().toArray(s_emptyStringArray);
                }
                errorData = new CompositeDataSupport(s_errorType, s_errorItemNames, new Object[]{errMsg.getErrorFacilityAndNumber(), errMsg.getErrorMessageText(), arguments});
            }
            String[] incidentFiles = null;
            if (incident.getIncidentFiles() != null && incident.getIncidentFiles().size() > 0) {
                incidentFiles = incident.getIncidentFiles().toArray(s_emptyStringArray);
            }
            String incidentSource = null;
            if (incident.getIncidentSource() != null) {
                incidentSource = incident.getIncidentSource().toString();
            }
            CompositeData[] incidentKeys = null;
            if (incident.getContextValues() != null && incident.getContextValues().size() > 0) {
                incidentKeys = new CompositeData[incident.getContextValues().size()];
                int i = 0;
                for (Map.Entry<String, String> e : incident.getContextValues().entrySet()) {
                    incidentKeys[i++] = new CompositeDataSupport(s_incidentKeysType, s_incidentKeysItemNames, new Object[]{e.getKey(), e.getValue()});
                }
            }
            return new CompositeDataSupport(this.toCompositeType(), s_itemNames, new Object[]{incident.getIncidentId(), incident.getDescription(), errorData, incident.getExecutionContextId(), incident.isFloodControlled(), incident.getIncidentDirectory(), incidentFiles, incidentSource, null, incident.getProblemKey(), incident.getADRBase(), incident.getProductType(), incident.getProductId(), incident.getInstanceId(), new Date(incident.getTimeOfIncident()), incident.getProblemId(), incidentKeys});
        }
        catch (OpenDataException ode) {
            throw new RuntimeException(ode);
        }
    }

    public IncidentImpl from(CompositeData cd) {
        String incidentSource;
        String[] incidentFiles;
        String description;
        boolean isFloodControlled;
        ErrorMessage errMsg = null;
        CompositeData errMsgCd = (CompositeData)cd.get(s_itemNames[2]);
        if (errMsgCd != null) {
            String msgId = (String)errMsgCd.get(s_errorItemNames[0]);
            String msgTxt = (String)errMsgCd.get(s_errorItemNames[1]);
            String[] msgArgs = (String[])errMsgCd.get(s_errorItemNames[2]);
            List<String> args = null;
            if (msgArgs != null && msgArgs.length > 0) {
                args = Arrays.asList(msgArgs);
            }
            errMsg = new ErrorMessage(msgId, msgTxt, args);
        }
        IncidentImpl incident = null;
        incident = new IncidentImpl((String)cd.get(s_itemNames[0]), (String)cd.get(s_itemNames[5]), (String)cd.get(s_itemNames[10]), (String)cd.get(s_itemNames[11]), (String)cd.get(s_itemNames[12]), (String)cd.get(s_itemNames[13]), (String)cd.get(s_itemNames[15]), (String)cd.get(s_itemNames[9]), (String)cd.get(s_itemNames[3]), ((Date)cd.get(s_itemNames[14])).getTime(), errMsg);
        CompositeData[] incidentKeys = (CompositeData[])cd.get(s_itemNames[16]);
        if (incidentKeys != null) {
            for (CompositeData incKeyValue : incidentKeys) {
                incident.setContextValue((String)incKeyValue.get(s_incidentKeysItemNames[0]), (String)incKeyValue.get(s_incidentKeysItemNames[1]));
            }
        }
        if (isFloodControlled = ((Boolean)cd.get(s_itemNames[4])).booleanValue()) {
            incident.setFloodContolled(null);
        }
        if ((description = (String)cd.get(s_itemNames[1])) != null && description.length() > 0) {
            incident.setDescription(description);
        }
        if ((incidentFiles = (String[])cd.get(s_itemNames[6])) != null && incidentFiles.length > 0) {
            incident.addIncidentFiles(incidentFiles);
        }
        if ((incidentSource = (String)cd.get(s_itemNames[7])) != null && incidentSource.length() > 0) {
            incident.setIncidentSource(Incident.IncidentSource.getIncidentSource(incidentSource));
        }
        return incident;
    }

    static {
        s_itemNames = new String[]{"incidentId", "description", "errorMessage", "executionContextId", "floodControlled", "incidentDirectory", "incidentFiles", "incidentSource", "problemImpacts", "problemKey", "ADRBase", "productType", "productId", "instanceId", "timeOfIncident", "problemId", "incidentKeys"};
        s_incidentKeysItemNames = new String[]{"name", "value"};
        s_errorItemNames = new String[]{"messageId", "messageText", "messageArguments"};
        s_emptyStringArray = new String[0];
    }
}

