/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.sampling;

import java.util.Date;
import java.util.List;

class SampleArchiveInfo {
    private long time_;
    private List<String> filenames_;
    private long fileSize_;
    private long index_;
    private String sampleName_;
    private String diagnosticDumpName_;
    static final String BEGIN_MARKER = "\n$$$=== ";
    static final String END_MARKER = " ===$$$\n";
    static final String BEGIN_OF = "BEGIN OF Diagnostic Dump - ";
    static final String END_OF = "END OF Diagnostic Dump - ";
    static final String ARCHIVE_PREFIX = " (Archive #";
    static final String ARCHIVE_SUFFIX = ")";
    static final String OUT_OF = "_of_";

    SampleArchiveInfo(long index, long time, List<String> filenames, long fileSize, String sampleName, String diagnosticDumpName) {
        this.index_ = index;
        this.time_ = time;
        this.filenames_ = filenames;
        this.fileSize_ = fileSize;
        this.sampleName_ = sampleName;
        this.diagnosticDumpName_ = diagnosticDumpName;
    }

    List<String> getFilenames() {
        return this.filenames_;
    }

    long getFileSize() {
        return this.fileSize_;
    }

    long getTime() {
        return this.time_;
    }

    long getIndex() {
        return this.index_;
    }

    String getSampleName() {
        return this.sampleName_;
    }

    String getDiagnosticDumpName() {
        return this.diagnosticDumpName_;
    }

    public String toHeaderString(int serial, int total) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(BEGIN_MARKER);
        sbuf.append(BEGIN_OF);
        sbuf.append(this.diagnosticDumpName_);
        sbuf.append(ARCHIVE_PREFIX);
        sbuf.append(this.index_);
        sbuf.append(" ");
        sbuf.append(serial);
        sbuf.append(OUT_OF);
        sbuf.append(total);
        sbuf.append(ARCHIVE_SUFFIX);
        sbuf.append(END_MARKER);
        Date date = new Date(this.time_);
        sbuf.append(date);
        sbuf.append("\n");
        sbuf.toString();
        return sbuf.toString();
    }

    public String toFooterString(int serial, int total) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(BEGIN_MARKER);
        sbuf.append(END_OF);
        sbuf.append(this.diagnosticDumpName_);
        sbuf.append(ARCHIVE_PREFIX);
        sbuf.append(this.index_);
        sbuf.append(" ");
        sbuf.append(serial);
        sbuf.append(OUT_OF);
        sbuf.append(total);
        sbuf.append(ARCHIVE_SUFFIX);
        sbuf.append(END_MARKER);
        sbuf.toString();
        return sbuf.toString();
    }
}

