/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.config.parameter;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.as.config.notification.DocumentChangeListener;
import oracle.as.config.notification.DocumentChangedEvent;
import oracle.dms.config.ConfigResourceBundle;
import oracle.dms.config.parameter.ClockType;
import oracle.dms.config.parameter.ClockUnits;
import oracle.dms.config.parameter.DMSParameterConfigMBean;
import oracle.dms.config.parameter.ParameterConfig;
import oracle.dms.config.parameter.SensorValue;
import oracle.dms.util.DMSProperties;

public class JMXDMSParameterConfig
implements DMSParameterConfigMBean,
DocumentChangeListener {
    private Logger m_logger;
    private static String LOGGER_NAME = "oracle.dms.config";
    private ParameterConfig m_ParameterConfig = new ParameterConfig();
    private boolean m_update;

    public JMXDMSParameterConfig(ParameterConfig parameterConfig) {
        this.m_ParameterConfig = parameterConfig;
        this.m_logger = Logger.getLogger(LOGGER_NAME, ConfigResourceBundle.class.getName());
    }

    public void update(ParameterConfig parameterConfig) {
        this.m_ParameterConfig = parameterConfig;
    }

    public boolean isConfigUpdated() {
        return this.m_update;
    }

    @Override
    public boolean isDMSContextEnabled() {
        return this.m_ParameterConfig.isDMSContextEnabled();
    }

    @Override
    public void setDMSContextEnabled(boolean enabled) {
        this.m_ParameterConfig.setDMSContextEnabled(enabled);
        this.m_update = true;
    }

    @Override
    public void setDMSClockType(ClockType clockType) {
        this.m_ParameterConfig.setDMSClockType(clockType);
        this.m_update = true;
    }

    @Override
    public ClockType getDMSClockType() {
        return this.m_ParameterConfig.getDMSClockType();
    }

    @Override
    public void setDMSClockUnits(ClockUnits clockUnits) {
        this.m_ParameterConfig.setDMSClockUnits(clockUnits);
        this.m_update = true;
    }

    @Override
    public ClockUnits getDMSClockUnits() {
        return this.m_ParameterConfig.getDMSClockUnits();
    }

    @Override
    public void setSensorActivationLevel(SensorValue activationLevel) {
        this.m_ParameterConfig.setSensorActivationLevel(activationLevel);
        this.m_update = true;
    }

    @Override
    public SensorValue getSensorActivationLevel() {
        return this.m_ParameterConfig.getSensorActivationLevel();
    }

    @Override
    public void setDMSPublisherClass(String pubClass) {
        this.m_ParameterConfig.setDMSPublisherClass(pubClass);
        this.m_update = true;
    }

    @Override
    public String getDMSPublisherClass() {
        return this.m_ParameterConfig.getDMSPublisherClass();
    }

    @Override
    public void setDMSHTTPPort(int port) {
        this.m_ParameterConfig.setDMSHTTPPort(port);
        this.m_update = true;
    }

    @Override
    public int getDMSHTTPPort() {
        return this.m_ParameterConfig.getDMSHTTPPort();
    }

    @Override
    public boolean isJVMMemoryStatsEnabled() {
        return this.m_ParameterConfig.isJVMMemoryStatsEnabled();
    }

    @Override
    public void setJVMMemoryStatsEnabled(boolean enabled) {
        this.m_ParameterConfig.setJVMMemoryStatsEnabled(enabled);
        this.m_update = true;
    }

    @Override
    public boolean isJVMThreadMonitorEnabled() {
        return this.m_ParameterConfig.isJVMThreadMonitorEnabled();
    }

    @Override
    public void setJVMThreadMonitorEnabled(boolean enabled) {
        this.m_ParameterConfig.setJVMThreadMonitorEnabled(enabled);
        this.m_update = true;
    }

    @Override
    public void setJVMThreadMonitorRefreshInterval(int seconds) {
        this.m_ParameterConfig.setJVMThreadMonitorRefreshIntervalSeconds(seconds);
        this.m_update = true;
    }

    @Override
    public int getJVMThreadMonitorRefreshInterval() {
        return this.m_ParameterConfig.getJVMThreadMonitorRefreshIntervalSeconds();
    }

    @Override
    public boolean isNonDecreasingTimeEnabled() {
        return this.m_ParameterConfig.isNonDecreasingTimeEnabled();
    }

    @Override
    public void setNonDecreasingTimeEnabled(boolean enabled) {
        this.m_ParameterConfig.setNonDecreasingTime(enabled);
        this.m_update = true;
    }

    @Override
    public Map<String, String> listAllDMSConfigParams(boolean configState) {
        Map<String, String> config = null;
        if (configState) {
            config = this.m_ParameterConfig.listAllDMSConfigParams();
        } else {
            Map<String, String> runtime = DMSProperties.listAllRuntimeDMSConfigParams();
            config = new HashMap<String, String>(runtime.size());
            for (Map.Entry<String, String> entry : runtime.entrySet()) {
                String v;
                String k = ParameterConfig.getConfigParam(entry.getKey());
                if (!ParameterConfig.okToShowParameter(k, v = ParameterConfig.getConfigValue(k, entry.getValue()))) continue;
                config.put(k, v);
            }
        }
        return config;
    }

    public boolean documentAdded(DocumentChangedEvent documentChangedEvent) {
        return true;
    }

    public boolean documentChanged(DocumentChangedEvent documentChangedEvent) {
        return false;
    }

    public boolean documentRemoved(DocumentChangedEvent documentChangedEvent) {
        return false;
    }
}

