/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import oracle.dms.http.Request;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.reporter.Constants;
import oracle.dms.util.DMSUtil;

public abstract class Reporter
implements Constants {
    protected static final String TEXT_HTML = "text/html; charset=UTF-8";
    protected static final String TEXT_PLAIN = "text/plain; charset=UTF-8";
    protected static final byte RESET = 1;
    protected static final byte SET = 2;
    protected static final byte GET = 3;
    protected static final byte INCLUDE_NO_DESCENDANTS = 0;
    protected static final byte INCLUDE_ALL_DESCENDANTS = 1;
    protected static final byte INCLUDE_CHILDREN = 2;
    protected Request m_request = null;
    protected byte m_op = (byte)3;
    protected String m_id = null;
    protected String m_name = null;
    protected static final Logger LOGGER = Logger.getLogger("oracle.dms.reporter");

    protected Reporter(Request request) {
        if (request == null) {
            throw new IllegalArgumentException(this.getClass().getName() + ": request=" + request);
        }
        this.m_request = request;
        this.m_id = DMSUtil.getProcessID();
        this.m_name = DMSConsole.getConsole().getName();
        this.m_op = this.m_request.isOperation("reset") ? (byte)1 : (this.m_request.isOperation("set") ? (byte)2 : (byte)3);
    }

    public abstract void printResponse(PrintWriter var1);

    public String getContentType() {
        return TEXT_PLAIN;
    }

    public abstract void clear();

    protected void printBadParams(Collection<String> badNames, Collection<String> badTables, PrintWriter out) {
        Iterator<String> iter;
        if (!(badNames != null && badNames.size() != 0 || badTables != null && badTables.size() != 0)) {
            return;
        }
        out.print("<bad_parameters>\n");
        if (badNames != null && badNames.size() > 0) {
            iter = badNames.iterator();
            while (iter.hasNext()) {
                out.print("<name>");
                out.print(DMSUtil.xssEscape(iter.next()));
                out.print("</name>\n");
            }
        }
        if (badTables != null && badTables.size() > 0) {
            iter = badTables.iterator();
            while (iter.hasNext()) {
                out.print("<nountype>");
                out.print(DMSUtil.xssEscape(iter.next()));
                out.print("</nountype>\n");
            }
        }
        out.print("</bad_parameters>\n");
    }
}

