/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XmlUtil {
    public static Element getChildByName(Element parent, String childName) {
        if (parent == null || childName == null || childName.length() == 0) {
            return null;
        }
        if (!parent.hasChildNodes()) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element) || !childName.equals(((Element)child).getTagName())) continue;
            return (Element)child;
        }
        return null;
    }

    public static String getText(Element element) {
        if (element == null) {
            return null;
        }
        if (!element.hasChildNodes()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        XmlUtil._getText(element, buffer);
        return buffer.toString();
    }

    private static void _getText(Node node, StringBuilder buffer) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = children.item(i);
            short type = child.getNodeType();
            if (type == 3) {
                buffer.append(child.getNodeValue());
                continue;
            }
            if (type == 4) {
                buffer.append(child.getNodeValue());
                continue;
            }
            if (type != 5) continue;
            XmlUtil._getText(child, buffer);
        }
    }

    public static String getChildTextByName(Element parent, String childName) {
        Element childElement = XmlUtil.getChildByName(parent, childName);
        return XmlUtil.getText(childElement);
    }

    public static int getAttributeInt(Element element, String attributeName) throws NumberFormatException {
        if (element == null || attributeName == null || attributeName.trim().length() == 0) {
            throw new NumberFormatException("empty element or attributeName");
        }
        String attribute = element.getAttribute(attributeName);
        return Integer.parseInt(attribute.trim());
    }

    public static boolean getAttributeBoolean(Element element, String attributeName) throws IllegalArgumentException {
        if (element == null || attributeName == null || attributeName.trim().length() == 0) {
            throw new IllegalArgumentException("empty element or attributeName");
        }
        String attribute = element.getAttribute(attributeName);
        return Boolean.parseBoolean(attribute);
    }

    public static String getAttributeString(Element element, String attributeName) throws IllegalArgumentException {
        if (element == null || attributeName == null || attributeName.trim().length() == 0) {
            throw new IllegalArgumentException("empty element or attributeName");
        }
        String attribute = element.getAttribute(attributeName);
        return attribute;
    }
}

