/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.function.Consumer;
import java.util.logging.Logger;

final class Chain<T> {
    private final Link<T>[] vacant;
    private final int[] ivacant;
    private Link<T> head = null;
    private Link<T> tail = null;
    private int size = 0;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    Chain(Link<T>[] linkArray, int[] nArray) {
        this.vacant = linkArray;
        this.ivacant = nArray;
    }

    static <T> void addHead(T t2, Chain<T> ... chainArray) {
        Link<T> link;
        if (0 == chainArray.length) {
            link = null;
        } else {
            Link<T>[] linkArray = chainArray[0].vacant;
            int[] nArray = chainArray[0].ivacant;
            nArray[0] = Math.max(0, nArray[0] - 1);
            link = linkArray[nArray[0]];
            linkArray[nArray[0]] = null;
        }
        if (null == link) {
            new Link<T>(t2, chainArray);
        } else {
            link.link(t2, chainArray);
        }
    }

    T removeHead() {
        return this.remove(this.head);
    }

    T removeTail() {
        return this.remove(this.tail);
    }

    private T remove(Link<T> link) {
        if (null == link) {
            return null;
        }
        this.ivacant[0] = Math.min(this.ivacant[0] + 1, this.vacant.length - 1);
        this.vacant[this.ivacant[0]] = link;
        return link.unlink();
    }

    int size() {
        return this.size;
    }

    void forEach(Consumer<? super T> consumer) {
        Integer n2 = null;
        Link<T> link = this.head;
        while (null != link) {
            consumer.accept(link.value);
            if (null == n2) {
                for (int i2 = 0; i2 < link.chains.length; ++i2) {
                    if (this != link.chains[i2]) continue;
                    n2 = i2;
                    break;
                }
            }
            link = link.next[n2];
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("[ ");
        boolean[] blArray = new boolean[]{false};
        this.forEach(object -> {
            stringBuilder.append(blArray[0] ? ", " : "").append(object.toString());
            blArray[0] = true;
        });
        return stringBuilder.append(" ]").toString();
    }

    static {
        try {
            $$$methodRef$$$8 = Chain.class.getDeclaredConstructor(Link[].class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = Chain.class.getDeclaredMethod("lambda$toString$0", StringBuilder.class, boolean[].class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = Chain.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = Chain.class.getDeclaredMethod("forEach", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = Chain.class.getDeclaredMethod("size", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = Chain.class.getDeclaredMethod("remove", Link.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = Chain.class.getDeclaredMethod("removeTail", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = Chain.class.getDeclaredMethod("removeHead", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = Chain.class.getDeclaredMethod("addHead", Object.class, Chain[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    static final class Link<T> {
        private T value;
        private Chain<T>[] chains;
        private final Link<T>[] prev;
        private final Link<T>[] next;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private Link(T t2, Chain<T> ... chainArray) {
            this.prev = new Link[chainArray.length];
            this.next = new Link[chainArray.length];
            this.link(t2, chainArray);
        }

        private void link(T t2, Chain<T> ... chainArray) {
            this.value = t2;
            this.chains = chainArray;
            for (int i2 = 0; i2 < chainArray.length; ++i2) {
                Chain<T> chain = chainArray[i2];
                ++chain.size;
                this.next[i2] = chain.head;
                this.prev[i2] = null;
                if (null != chain.head) {
                    chain.head.prev[i2] = this;
                }
                chain.head = this;
                if (null != chain.tail) continue;
                chain.tail = this;
            }
        }

        private T unlink() {
            for (int i2 = 0; i2 < this.chains.length; ++i2) {
                Chain<T> chain = this.chains[i2];
                --chain.size;
                if (null == this.prev[i2]) {
                    chain.head = this.next[i2];
                } else {
                    this.prev[i2].next[i2] = this.next[i2];
                }
                if (null == this.next[i2]) {
                    chain.tail = this.prev[i2];
                    continue;
                }
                this.next[i2].prev[i2] = this.prev[i2];
            }
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }

        static {
            try {
                $$$methodRef$$$3 = Link.class.getDeclaredConstructor(Object.class, Chain[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Link.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Link.class.getDeclaredMethod("unlink", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Link.class.getDeclaredMethod("link", Object.class, Chain[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

