/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.ResourceBundle;
import oracle.security.pki.OracleKeyStoreSpi;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OracleSSOKeyStoreSpi;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.exception.OracleSecretAlreadyExistsException;
import oracle.security.pki.exception.OracleSecretNotFoundException;
import oracle.security.pki.internal.OracleSecretStoreHelper;

public class OracleSecretStore {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    private OracleKeyStoreSpi b = null;

    protected OracleSecretStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAlias(String string) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            return this.b.secretStoreContainsAlias(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getSecret(String string) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            return this.b.secretStoreGetSecret(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecret(String string, char[] cArray) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            this.b.secretStoreSetSecret(string, cArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSecret(String string) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            this.b.secretStoreDeleteSecret(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            this.b.secretStoreCreateCredential(cArray, cArray2, cArray3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            this.b.secretStoreModifyCredential(cArray, cArray2, cArray3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCredential(char[] cArray) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            this.b.secretStoreDeleteCredential(cArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listCredential() throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            this.b.secretStoreListCredential();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUserCredential(String string, String string2, String string3, char[] cArray) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStoreHelper.validateMapName(string);
        OracleSecretStoreHelper.validateKey(string2);
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            String string4 = OracleSecretStoreHelper.createAliasforUserCredential(string, string2);
            char[] cArray2 = this.getSecret(string4);
            if (cArray2 != null) {
                Arrays.fill(cArray2, '0');
                throw new OracleSecretAlreadyExistsException(MessageFormat.format(a.getString("PKI-03006"), string, string2));
            }
            char[] cArray3 = OracleSecretStoreHelper.createSecretForUserCredential(string3, cArray);
            this.b.secretStoreSetSecret(string4, cArray3);
        }
    }

    public void createUserCredential(String string, String string2, char[] cArray) throws OracleSecretStoreException {
        this.createUserCredential(string, string2, null, cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyUserCredential(String string, String string2, String string3, char[] cArray) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStoreHelper.validateMapName(string);
        OracleSecretStoreHelper.validateKey(string2);
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            String string4 = OracleSecretStoreHelper.createAliasforUserCredential(string, string2);
            char[] cArray2 = OracleSecretStoreHelper.createSecretForUserCredential(string3, cArray);
            char[] cArray3 = this.getSecret(string4);
            if (cArray3 != null) {
                Arrays.fill(cArray3, '0');
                OraclePKIDebug.a("Credential already exists for map any key, modifying credential");
                this.b.secretStoreDeleteSecret(string4);
                this.b.secretStoreSetSecret(string4, cArray2);
            } else {
                OraclePKIDebug.a("Credential does not exist for map any key, creating credential");
                this.b.secretStoreSetSecret(string4, cArray2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUserCredential(String string, String string2) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStoreHelper.validateMapName(string);
        OracleSecretStoreHelper.validateKey(string2);
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            String string3 = OracleSecretStoreHelper.createAliasforUserCredential(string, string2);
            char[] cArray = this.getSecret(string3);
            if (cArray == null) {
                throw new OracleSecretNotFoundException(MessageFormat.format(a.getString("PKI-03007"), string, string2));
            }
            Arrays.fill(cArray, '0');
            this.b.secretStoreDeleteSecret(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUsernameCredential(String string, String string2) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStoreHelper.validateMapName(string);
        OracleSecretStoreHelper.validateKey(string2);
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            String string3 = OracleSecretStoreHelper.createAliasforUserCredential(string, string2);
            char[] cArray = this.getSecret(string3);
            if (cArray == null) {
                throw new OracleSecretNotFoundException(MessageFormat.format(a.getString("PKI-03007"), string, string2));
            }
            return OracleSecretStoreHelper.getUsernameFromUserCredential(cArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getPasswordCredential(String string, String string2) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStoreHelper.validateMapName(string);
        OracleSecretStoreHelper.validateKey(string2);
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            String string3 = OracleSecretStoreHelper.createAliasforUserCredential(string, string2);
            char[] cArray = this.getSecret(string3);
            if (cArray == null) {
                throw new OracleSecretNotFoundException(MessageFormat.format(a.getString("PKI-03007"), string, string2));
            }
            return OracleSecretStoreHelper.getPasswordFromUserCredential(cArray);
        }
    }

    public Enumeration internalAliases() throws OracleSecretStoreException {
        return this.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration internalAliasesU() throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            return this.b.c();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration a() throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            return this.b.b();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int b() throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            return this.b.a();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream inputStream, char[] cArray) throws IOException, OracleSecretStoreException {
        OraclePKIDebug.a("OracleSecretStore: loading wallet from stream");
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            this.b = cArray == null ? new OracleSSOKeyStoreSpi() : new OracleKeyStoreSpi();
            try {
                this.b.engineLoad(inputStream, cArray);
            }
            catch (CertificateException certificateException) {
                throw new OracleSecretStoreException(a.getString("PKI-03004"));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new OracleSecretStoreException(a.getString("PKI-03004"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] setStoreInWallet(InputStream inputStream, char[] cArray) throws IOException, OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            return this.b.a(inputStream, cArray);
        }
    }
}

