/**
 * Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.analytics.model;

/**
 * The types of work request operations.
 *
 **/
@javax.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20190331")
@lombok.extern.slf4j.Slf4j
public enum WorkRequestOperationType {
    CreateAnalyticsInstance("CREATE_ANALYTICS_INSTANCE"),
    DeleteAnalyticsInstance("DELETE_ANALYTICS_INSTANCE"),
    StartAnalyticsInstance("START_ANALYTICS_INSTANCE"),
    StopAnalyticsInstance("STOP_ANALYTICS_INSTANCE"),
    ScaleAnalyticsInstance("SCALE_ANALYTICS_INSTANCE"),
    ChangeAnalyticsInstanceCompartment("CHANGE_ANALYTICS_INSTANCE_COMPARTMENT"),
    ChangeAnalyticsInstanceNetworkEndpoint("CHANGE_ANALYTICS_INSTANCE_NETWORK_ENDPOINT"),
    CreateVanityUrl("CREATE_VANITY_URL"),
    UpdateVanityUrl("UPDATE_VANITY_URL"),
    DeleteVanityUrl("DELETE_VANITY_URL"),
    CreatePrivateAccessChannel("CREATE_PRIVATE_ACCESS_CHANNEL"),
    UpdatePrivateAccessChannel("UPDATE_PRIVATE_ACCESS_CHANNEL"),
    DeletePrivateAccessChannel("DELETE_PRIVATE_ACCESS_CHANNEL"),

    /**
     * This value is used if a service returns a value for this enum that is not recognized by this
     * version of the SDK.
     */
    UnknownEnumValue(null);

    private final String value;
    private static java.util.Map<String, WorkRequestOperationType> map;

    static {
        map = new java.util.HashMap<>();
        for (WorkRequestOperationType v : WorkRequestOperationType.values()) {
            if (v != UnknownEnumValue) {
                map.put(v.getValue(), v);
            }
        }
    }

    WorkRequestOperationType(String value) {
        this.value = value;
    }

    @com.fasterxml.jackson.annotation.JsonValue
    public String getValue() {
        return value;
    }

    @com.fasterxml.jackson.annotation.JsonCreator
    public static WorkRequestOperationType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn(
                "Received unknown value '{}' for enum 'WorkRequestOperationType', returning UnknownEnumValue",
                key);
        return UnknownEnumValue;
    }
}
