/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetAnalyticsInstanceRequest
extends BmcRequest<Void> {
    private String analyticsInstanceId;
    private String opcRequestId;

    @ConstructorProperties(value={"analyticsInstanceId", "opcRequestId"})
    GetAnalyticsInstanceRequest(String analyticsInstanceId, String opcRequestId) {
        this.analyticsInstanceId = analyticsInstanceId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAnalyticsInstanceId() {
        return this.analyticsInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAnalyticsInstanceRequest, Void> {
        private String analyticsInstanceId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAnalyticsInstanceRequest o) {
            this.analyticsInstanceId(o.getAnalyticsInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAnalyticsInstanceRequest build() {
            GetAnalyticsInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder analyticsInstanceId(String analyticsInstanceId) {
            this.analyticsInstanceId = analyticsInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetAnalyticsInstanceRequest buildWithoutInvocationCallback() {
            return new GetAnalyticsInstanceRequest(this.analyticsInstanceId, this.opcRequestId);
        }

        public String toString() {
            return "GetAnalyticsInstanceRequest.Builder(analyticsInstanceId=" + this.analyticsInstanceId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

