/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apigateway.ApiGatewayAsync;
import com.oracle.bmc.apigateway.internal.http.ChangeApiCompartmentConverter;
import com.oracle.bmc.apigateway.internal.http.ChangeCertificateCompartmentConverter;
import com.oracle.bmc.apigateway.internal.http.CreateApiConverter;
import com.oracle.bmc.apigateway.internal.http.CreateCertificateConverter;
import com.oracle.bmc.apigateway.internal.http.DeleteApiConverter;
import com.oracle.bmc.apigateway.internal.http.DeleteCertificateConverter;
import com.oracle.bmc.apigateway.internal.http.GetApiContentConverter;
import com.oracle.bmc.apigateway.internal.http.GetApiConverter;
import com.oracle.bmc.apigateway.internal.http.GetApiDeploymentSpecificationConverter;
import com.oracle.bmc.apigateway.internal.http.GetApiValidationsConverter;
import com.oracle.bmc.apigateway.internal.http.GetCertificateConverter;
import com.oracle.bmc.apigateway.internal.http.ListApisConverter;
import com.oracle.bmc.apigateway.internal.http.ListCertificatesConverter;
import com.oracle.bmc.apigateway.internal.http.UpdateApiConverter;
import com.oracle.bmc.apigateway.internal.http.UpdateCertificateConverter;
import com.oracle.bmc.apigateway.requests.ChangeApiCompartmentRequest;
import com.oracle.bmc.apigateway.requests.ChangeCertificateCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateApiRequest;
import com.oracle.bmc.apigateway.requests.CreateCertificateRequest;
import com.oracle.bmc.apigateway.requests.DeleteApiRequest;
import com.oracle.bmc.apigateway.requests.DeleteCertificateRequest;
import com.oracle.bmc.apigateway.requests.GetApiContentRequest;
import com.oracle.bmc.apigateway.requests.GetApiDeploymentSpecificationRequest;
import com.oracle.bmc.apigateway.requests.GetApiRequest;
import com.oracle.bmc.apigateway.requests.GetApiValidationsRequest;
import com.oracle.bmc.apigateway.requests.GetCertificateRequest;
import com.oracle.bmc.apigateway.requests.ListApisRequest;
import com.oracle.bmc.apigateway.requests.ListCertificatesRequest;
import com.oracle.bmc.apigateway.requests.UpdateApiRequest;
import com.oracle.bmc.apigateway.requests.UpdateCertificateRequest;
import com.oracle.bmc.apigateway.responses.ChangeApiCompartmentResponse;
import com.oracle.bmc.apigateway.responses.ChangeCertificateCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateApiResponse;
import com.oracle.bmc.apigateway.responses.CreateCertificateResponse;
import com.oracle.bmc.apigateway.responses.DeleteApiResponse;
import com.oracle.bmc.apigateway.responses.DeleteCertificateResponse;
import com.oracle.bmc.apigateway.responses.GetApiContentResponse;
import com.oracle.bmc.apigateway.responses.GetApiDeploymentSpecificationResponse;
import com.oracle.bmc.apigateway.responses.GetApiResponse;
import com.oracle.bmc.apigateway.responses.GetApiValidationsResponse;
import com.oracle.bmc.apigateway.responses.GetCertificateResponse;
import com.oracle.bmc.apigateway.responses.ListApisResponse;
import com.oracle.bmc.apigateway.responses.ListCertificatesResponse;
import com.oracle.bmc.apigateway.responses.UpdateApiResponse;
import com.oracle.bmc.apigateway.responses.UpdateCertificateResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiGatewayAsyncClient
implements ApiGatewayAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ApiGatewayAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APIGATEWAY").serviceEndpointPrefix("").serviceEndpointTemplate("https://apigateway.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public ApiGatewayAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ApiGatewayAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ApiGatewayAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ApiGatewayAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ApiGatewayAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ApiGatewayAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ApiGatewayAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public ApiGatewayAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeApiCompartmentResponse> changeApiCompartment(ChangeApiCompartmentRequest request, AsyncHandler<ChangeApiCompartmentRequest, ChangeApiCompartmentResponse> handler) {
        LOG.trace("Called async changeApiCompartment");
        ChangeApiCompartmentRequest interceptedRequest = ChangeApiCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeApiCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeApiCompartmentResponse> transformer = ChangeApiCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeApiCompartmentRequest, ChangeApiCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeApiCompartmentRequest, ChangeApiCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeCertificateCompartmentResponse> changeCertificateCompartment(ChangeCertificateCompartmentRequest request, AsyncHandler<ChangeCertificateCompartmentRequest, ChangeCertificateCompartmentResponse> handler) {
        LOG.trace("Called async changeCertificateCompartment");
        ChangeCertificateCompartmentRequest interceptedRequest = ChangeCertificateCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeCertificateCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeCertificateCompartmentResponse> transformer = ChangeCertificateCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeCertificateCompartmentRequest, ChangeCertificateCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeCertificateCompartmentRequest, ChangeCertificateCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateApiResponse> createApi(CreateApiRequest request, AsyncHandler<CreateApiRequest, CreateApiResponse> handler) {
        LOG.trace("Called async createApi");
        CreateApiRequest interceptedRequest = CreateApiConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateApiConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateApiResponse> transformer = CreateApiConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateApiRequest, CreateApiResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateApiRequest, CreateApiResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateCertificateResponse> createCertificate(CreateCertificateRequest request, AsyncHandler<CreateCertificateRequest, CreateCertificateResponse> handler) {
        LOG.trace("Called async createCertificate");
        CreateCertificateRequest interceptedRequest = CreateCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateCertificateResponse> transformer = CreateCertificateConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateCertificateRequest, CreateCertificateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateCertificateRequest, CreateCertificateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteApiResponse> deleteApi(DeleteApiRequest request, AsyncHandler<DeleteApiRequest, DeleteApiResponse> handler) {
        LOG.trace("Called async deleteApi");
        DeleteApiRequest interceptedRequest = DeleteApiConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteApiConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteApiResponse> transformer = DeleteApiConverter.fromResponse();
        AsyncHandler<DeleteApiRequest, DeleteApiResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteApiRequest, DeleteApiResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest request, AsyncHandler<DeleteCertificateRequest, DeleteCertificateResponse> handler) {
        LOG.trace("Called async deleteCertificate");
        DeleteCertificateRequest interceptedRequest = DeleteCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteCertificateResponse> transformer = DeleteCertificateConverter.fromResponse();
        AsyncHandler<DeleteCertificateRequest, DeleteCertificateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteCertificateRequest, DeleteCertificateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetApiResponse> getApi(GetApiRequest request, AsyncHandler<GetApiRequest, GetApiResponse> handler) {
        LOG.trace("Called async getApi");
        GetApiRequest interceptedRequest = GetApiConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApiConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetApiResponse> transformer = GetApiConverter.fromResponse();
        AsyncHandler<GetApiRequest, GetApiResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetApiRequest, GetApiResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetApiContentResponse> getApiContent(GetApiContentRequest request, AsyncHandler<GetApiContentRequest, GetApiContentResponse> handler) {
        LOG.trace("Called async getApiContent");
        GetApiContentRequest interceptedRequest = GetApiContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApiContentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetApiContentResponse> transformer = GetApiContentConverter.fromResponse();
        AsyncHandler<GetApiContentRequest, GetApiContentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetApiContentRequest, GetApiContentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetApiDeploymentSpecificationResponse> getApiDeploymentSpecification(GetApiDeploymentSpecificationRequest request, AsyncHandler<GetApiDeploymentSpecificationRequest, GetApiDeploymentSpecificationResponse> handler) {
        LOG.trace("Called async getApiDeploymentSpecification");
        GetApiDeploymentSpecificationRequest interceptedRequest = GetApiDeploymentSpecificationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApiDeploymentSpecificationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetApiDeploymentSpecificationResponse> transformer = GetApiDeploymentSpecificationConverter.fromResponse();
        AsyncHandler<GetApiDeploymentSpecificationRequest, GetApiDeploymentSpecificationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetApiDeploymentSpecificationRequest, GetApiDeploymentSpecificationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetApiValidationsResponse> getApiValidations(GetApiValidationsRequest request, AsyncHandler<GetApiValidationsRequest, GetApiValidationsResponse> handler) {
        LOG.trace("Called async getApiValidations");
        GetApiValidationsRequest interceptedRequest = GetApiValidationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApiValidationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetApiValidationsResponse> transformer = GetApiValidationsConverter.fromResponse();
        AsyncHandler<GetApiValidationsRequest, GetApiValidationsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetApiValidationsRequest, GetApiValidationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetCertificateResponse> getCertificate(GetCertificateRequest request, AsyncHandler<GetCertificateRequest, GetCertificateResponse> handler) {
        LOG.trace("Called async getCertificate");
        GetCertificateRequest interceptedRequest = GetCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCertificateResponse> transformer = GetCertificateConverter.fromResponse();
        AsyncHandler<GetCertificateRequest, GetCertificateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetCertificateRequest, GetCertificateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListApisResponse> listApis(ListApisRequest request, AsyncHandler<ListApisRequest, ListApisResponse> handler) {
        LOG.trace("Called async listApis");
        ListApisRequest interceptedRequest = ListApisConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListApisConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListApisResponse> transformer = ListApisConverter.fromResponse();
        AsyncHandler<ListApisRequest, ListApisResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListApisRequest, ListApisResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCertificatesResponse> listCertificates(ListCertificatesRequest request, AsyncHandler<ListCertificatesRequest, ListCertificatesResponse> handler) {
        LOG.trace("Called async listCertificates");
        ListCertificatesRequest interceptedRequest = ListCertificatesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCertificatesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCertificatesResponse> transformer = ListCertificatesConverter.fromResponse();
        AsyncHandler<ListCertificatesRequest, ListCertificatesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCertificatesRequest, ListCertificatesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateApiResponse> updateApi(UpdateApiRequest request, AsyncHandler<UpdateApiRequest, UpdateApiResponse> handler) {
        LOG.trace("Called async updateApi");
        UpdateApiRequest interceptedRequest = UpdateApiConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateApiConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateApiResponse> transformer = UpdateApiConverter.fromResponse();
        AsyncHandler<UpdateApiRequest, UpdateApiResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateApiRequest, UpdateApiResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateCertificateResponse> updateCertificate(UpdateCertificateRequest request, AsyncHandler<UpdateCertificateRequest, UpdateCertificateResponse> handler) {
        LOG.trace("Called async updateCertificate");
        UpdateCertificateRequest interceptedRequest = UpdateCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateCertificateResponse> transformer = UpdateCertificateConverter.fromResponse();
        AsyncHandler<UpdateCertificateRequest, UpdateCertificateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateCertificateRequest, UpdateCertificateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApiGatewayAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ApiGatewayAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ApiGatewayAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

