/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.apigateway.ApiGateway;
import com.oracle.bmc.apigateway.model.ApiSummary;
import com.oracle.bmc.apigateway.model.CertificateSummary;
import com.oracle.bmc.apigateway.requests.ListApisRequest;
import com.oracle.bmc.apigateway.requests.ListCertificatesRequest;
import com.oracle.bmc.apigateway.responses.ListApisResponse;
import com.oracle.bmc.apigateway.responses.ListCertificatesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class ApiGatewayPaginators {
    private final ApiGateway client;

    public Iterable<ListApisResponse> listApisResponseIterator(final ListApisRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListApisRequest.Builder>(){

            public ListApisRequest.Builder get() {
                return ListApisRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApisResponse, String>(){

            public String apply(ListApisResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApisRequest.Builder>, ListApisRequest>(){

            public ListApisRequest apply(RequestBuilderAndToken<ListApisRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListApisRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApisRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListApisRequest, ListApisResponse>(){

            public ListApisResponse apply(ListApisRequest request) {
                return ApiGatewayPaginators.this.client.listApis(request);
            }
        });
    }

    public Iterable<ApiSummary> listApisRecordIterator(final ListApisRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListApisRequest.Builder>(){

            public ListApisRequest.Builder get() {
                return ListApisRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApisResponse, String>(){

            public String apply(ListApisResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApisRequest.Builder>, ListApisRequest>(){

            public ListApisRequest apply(RequestBuilderAndToken<ListApisRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListApisRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApisRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListApisRequest, ListApisResponse>(){

            public ListApisResponse apply(ListApisRequest request) {
                return ApiGatewayPaginators.this.client.listApis(request);
            }
        }, (Function)new Function<ListApisResponse, List<ApiSummary>>(){

            public List<ApiSummary> apply(ListApisResponse response) {
                return response.getApiCollection().getItems();
            }
        });
    }

    public Iterable<ListCertificatesResponse> listCertificatesResponseIterator(final ListCertificatesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCertificatesRequest.Builder>(){

            public ListCertificatesRequest.Builder get() {
                return ListCertificatesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCertificatesResponse, String>(){

            public String apply(ListCertificatesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCertificatesRequest.Builder>, ListCertificatesRequest>(){

            public ListCertificatesRequest apply(RequestBuilderAndToken<ListCertificatesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListCertificatesRequest, ListCertificatesResponse>(){

            public ListCertificatesResponse apply(ListCertificatesRequest request) {
                return ApiGatewayPaginators.this.client.listCertificates(request);
            }
        });
    }

    public Iterable<CertificateSummary> listCertificatesRecordIterator(final ListCertificatesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCertificatesRequest.Builder>(){

            public ListCertificatesRequest.Builder get() {
                return ListCertificatesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCertificatesResponse, String>(){

            public String apply(ListCertificatesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCertificatesRequest.Builder>, ListCertificatesRequest>(){

            public ListCertificatesRequest apply(RequestBuilderAndToken<ListCertificatesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListCertificatesRequest, ListCertificatesResponse>(){

            public ListCertificatesResponse apply(ListCertificatesRequest request) {
                return ApiGatewayPaginators.this.client.listCertificates(request);
            }
        }, (Function)new Function<ListCertificatesResponse, List<CertificateSummary>>(){

            public List<CertificateSummary> apply(ListCertificatesResponse response) {
                return response.getCertificateCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public ApiGatewayPaginators(ApiGateway client) {
        this.client = client;
    }
}

