/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.apigateway.requests.UpdateDeploymentRequest;
import com.oracle.bmc.apigateway.responses.UpdateDeploymentResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDeploymentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateDeploymentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateDeploymentRequest interceptRequest(UpdateDeploymentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateDeploymentRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateDeploymentDetails(), (String)"updateDeploymentDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190501").path("deployments").path(HttpUtils.encodePathSegment((String)request.getDeploymentId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, UpdateDeploymentResponse> fromResponse() {
        Function<Response, UpdateDeploymentResponse> transformer = new Function<Response, UpdateDeploymentResponse>(){

            public UpdateDeploymentResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.apigateway.responses.UpdateDeploymentResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UpdateDeploymentResponse.Builder builder = UpdateDeploymentResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                Optional opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id");
                if (opcWorkRequestIdHeader.isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                UpdateDeploymentResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

