/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetApiDeploymentSpecificationRequest
extends BmcRequest<Void> {
    private String apiId;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"apiId", "opcRequestId", "ifMatch"})
    GetApiDeploymentSpecificationRequest(String apiId, String opcRequestId, String ifMatch) {
        this.apiId = apiId;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getApiId() {
        return this.apiId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<GetApiDeploymentSpecificationRequest, Void> {
        private String apiId;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetApiDeploymentSpecificationRequest o) {
            this.apiId(o.getApiId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetApiDeploymentSpecificationRequest build() {
            GetApiDeploymentSpecificationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public GetApiDeploymentSpecificationRequest buildWithoutInvocationCallback() {
            return new GetApiDeploymentSpecificationRequest(this.apiId, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "GetApiDeploymentSpecificationRequest.Builder(apiId=" + this.apiId + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

