/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmcontrolplane.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.apmcontrolplane.model.DataKeySummary;
import com.oracle.bmc.apmcontrolplane.requests.ListDataKeysRequest;
import com.oracle.bmc.apmcontrolplane.responses.ListDataKeysResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListDataKeysConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListDataKeysConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListDataKeysRequest interceptRequest(ListDataKeysRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListDataKeysRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200630").path("apmDomains").path(HttpUtils.encodePathSegment((String)request.getApmDomainId())).path("dataKeys");
        if (request.getDataKeyType() != null) {
            target = target.queryParam("dataKeyType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDataKeyType().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListDataKeysResponse> fromResponse() {
        Function<Response, ListDataKeysResponse> transformer = new Function<Response, ListDataKeysResponse>(){

            public ListDataKeysResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.apmcontrolplane.responses.ListDataKeysResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<DataKeySummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListDataKeysResponse.Builder builder = ListDataKeysResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.items((List)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListDataKeysResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

