/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apmtraces.model.QueryDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.ws.rs.client.Invocation;

public class QueryRequest
extends BmcRequest<QueryDetails> {
    private String apmDomainId;
    private Date timeSpanStartedGreaterThanOrEqualTo;
    private Date timeSpanStartedLessThan;
    private QueryDetails queryDetails;
    private String opcRequestId;
    private Integer limit;
    private String page;

    @InternalSdk
    public QueryDetails getBody$() {
        return this.queryDetails;
    }

    @ConstructorProperties(value={"apmDomainId", "timeSpanStartedGreaterThanOrEqualTo", "timeSpanStartedLessThan", "queryDetails", "opcRequestId", "limit", "page"})
    QueryRequest(String apmDomainId, Date timeSpanStartedGreaterThanOrEqualTo, Date timeSpanStartedLessThan, QueryDetails queryDetails, String opcRequestId, Integer limit, String page) {
        this.apmDomainId = apmDomainId;
        this.timeSpanStartedGreaterThanOrEqualTo = timeSpanStartedGreaterThanOrEqualTo;
        this.timeSpanStartedLessThan = timeSpanStartedLessThan;
        this.queryDetails = queryDetails;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public Date getTimeSpanStartedGreaterThanOrEqualTo() {
        return this.timeSpanStartedGreaterThanOrEqualTo;
    }

    public Date getTimeSpanStartedLessThan() {
        return this.timeSpanStartedLessThan;
    }

    public QueryDetails getQueryDetails() {
        return this.queryDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<QueryRequest, QueryDetails> {
        private String apmDomainId;
        private Date timeSpanStartedGreaterThanOrEqualTo;
        private Date timeSpanStartedLessThan;
        private QueryDetails queryDetails;
        private String opcRequestId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(QueryRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.timeSpanStartedGreaterThanOrEqualTo(o.getTimeSpanStartedGreaterThanOrEqualTo());
            this.timeSpanStartedLessThan(o.getTimeSpanStartedLessThan());
            this.queryDetails(o.getQueryDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public QueryRequest build() {
            QueryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(QueryDetails body) {
            this.queryDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder timeSpanStartedGreaterThanOrEqualTo(Date timeSpanStartedGreaterThanOrEqualTo) {
            this.timeSpanStartedGreaterThanOrEqualTo = timeSpanStartedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeSpanStartedLessThan(Date timeSpanStartedLessThan) {
            this.timeSpanStartedLessThan = timeSpanStartedLessThan;
            return this;
        }

        public Builder queryDetails(QueryDetails queryDetails) {
            this.queryDetails = queryDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public QueryRequest buildWithoutInvocationCallback() {
            return new QueryRequest(this.apmDomainId, this.timeSpanStartedGreaterThanOrEqualTo, this.timeSpanStartedLessThan, this.queryDetails, this.opcRequestId, this.limit, this.page);
        }

        public String toString() {
            return "QueryRequest.Builder(apmDomainId=" + this.apmDomainId + ", timeSpanStartedGreaterThanOrEqualTo=" + this.timeSpanStartedGreaterThanOrEqualTo + ", timeSpanStartedLessThan=" + this.timeSpanStartedLessThan + ", queryDetails=" + this.queryDetails + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

