/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.applicationmigration;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.applicationmigration.ApplicationMigration;
import com.oracle.bmc.applicationmigration.ApplicationMigrationPaginators;
import com.oracle.bmc.applicationmigration.ApplicationMigrationWaiters;
import com.oracle.bmc.applicationmigration.internal.http.CancelWorkRequestConverter;
import com.oracle.bmc.applicationmigration.internal.http.ChangeMigrationCompartmentConverter;
import com.oracle.bmc.applicationmigration.internal.http.ChangeSourceCompartmentConverter;
import com.oracle.bmc.applicationmigration.internal.http.CreateMigrationConverter;
import com.oracle.bmc.applicationmigration.internal.http.CreateSourceConverter;
import com.oracle.bmc.applicationmigration.internal.http.DeleteMigrationConverter;
import com.oracle.bmc.applicationmigration.internal.http.DeleteSourceConverter;
import com.oracle.bmc.applicationmigration.internal.http.GetMigrationConverter;
import com.oracle.bmc.applicationmigration.internal.http.GetSourceConverter;
import com.oracle.bmc.applicationmigration.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.applicationmigration.internal.http.ListMigrationsConverter;
import com.oracle.bmc.applicationmigration.internal.http.ListSourceApplicationsConverter;
import com.oracle.bmc.applicationmigration.internal.http.ListSourcesConverter;
import com.oracle.bmc.applicationmigration.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.applicationmigration.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.applicationmigration.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.applicationmigration.internal.http.MigrateApplicationConverter;
import com.oracle.bmc.applicationmigration.internal.http.UpdateMigrationConverter;
import com.oracle.bmc.applicationmigration.internal.http.UpdateSourceConverter;
import com.oracle.bmc.applicationmigration.requests.CancelWorkRequestRequest;
import com.oracle.bmc.applicationmigration.requests.ChangeMigrationCompartmentRequest;
import com.oracle.bmc.applicationmigration.requests.ChangeSourceCompartmentRequest;
import com.oracle.bmc.applicationmigration.requests.CreateMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.CreateSourceRequest;
import com.oracle.bmc.applicationmigration.requests.DeleteMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.DeleteSourceRequest;
import com.oracle.bmc.applicationmigration.requests.GetMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.GetSourceRequest;
import com.oracle.bmc.applicationmigration.requests.GetWorkRequestRequest;
import com.oracle.bmc.applicationmigration.requests.ListMigrationsRequest;
import com.oracle.bmc.applicationmigration.requests.ListSourceApplicationsRequest;
import com.oracle.bmc.applicationmigration.requests.ListSourcesRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.applicationmigration.requests.MigrateApplicationRequest;
import com.oracle.bmc.applicationmigration.requests.UpdateMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.UpdateSourceRequest;
import com.oracle.bmc.applicationmigration.responses.CancelWorkRequestResponse;
import com.oracle.bmc.applicationmigration.responses.ChangeMigrationCompartmentResponse;
import com.oracle.bmc.applicationmigration.responses.ChangeSourceCompartmentResponse;
import com.oracle.bmc.applicationmigration.responses.CreateMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.CreateSourceResponse;
import com.oracle.bmc.applicationmigration.responses.DeleteMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.DeleteSourceResponse;
import com.oracle.bmc.applicationmigration.responses.GetMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.GetSourceResponse;
import com.oracle.bmc.applicationmigration.responses.GetWorkRequestResponse;
import com.oracle.bmc.applicationmigration.responses.ListMigrationsResponse;
import com.oracle.bmc.applicationmigration.responses.ListSourceApplicationsResponse;
import com.oracle.bmc.applicationmigration.responses.ListSourcesResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.applicationmigration.responses.MigrateApplicationResponse;
import com.oracle.bmc.applicationmigration.responses.UpdateMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.UpdateSourceResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationMigrationClient
implements ApplicationMigration {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationMigrationClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APPLICATIONMIGRATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://applicationmigration.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final ApplicationMigrationWaiters waiters;
    private final ApplicationMigrationPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public ApplicationMigrationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ApplicationMigrationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ApplicationMigrationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ApplicationMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ApplicationMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ApplicationMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ApplicationMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public ApplicationMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected ApplicationMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ApplicationMigration-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ApplicationMigrationWaiters(executorService, this);
        this.paginators = new ApplicationMigrationPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        LOG.trace("Called cancelWorkRequest");
        CancelWorkRequestRequest interceptedRequest = CancelWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelWorkRequestResponse> transformer = CancelWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CancelWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CancelWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (CancelWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeMigrationCompartmentResponse changeMigrationCompartment(ChangeMigrationCompartmentRequest request) {
        LOG.trace("Called changeMigrationCompartment");
        ChangeMigrationCompartmentRequest interceptedRequest = ChangeMigrationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeMigrationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeMigrationCompartmentResponse> transformer = ChangeMigrationCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeMigrationCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeMigrationCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeMigrationCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeMigrationCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeSourceCompartmentResponse changeSourceCompartment(ChangeSourceCompartmentRequest request) {
        LOG.trace("Called changeSourceCompartment");
        ChangeSourceCompartmentRequest interceptedRequest = ChangeSourceCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeSourceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeSourceCompartmentResponse> transformer = ChangeSourceCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeSourceCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeSourceCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeSourceCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeSourceCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateMigrationResponse createMigration(CreateMigrationRequest request) {
        LOG.trace("Called createMigration");
        CreateMigrationRequest interceptedRequest = CreateMigrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateMigrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateMigrationResponse> transformer = CreateMigrationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateMigrationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateMigrationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateMigrationDetails(), (BmcRequest)retriedRequest);
                return (CreateMigrationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateSourceResponse createSource(CreateSourceRequest request) {
        LOG.trace("Called createSource");
        CreateSourceRequest interceptedRequest = CreateSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSourceResponse> transformer = CreateSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateSourceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateSourceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateSourceDetails(), (BmcRequest)retriedRequest);
                return (CreateSourceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteMigrationResponse deleteMigration(DeleteMigrationRequest request) {
        LOG.trace("Called deleteMigration");
        DeleteMigrationRequest interceptedRequest = DeleteMigrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteMigrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteMigrationResponse> transformer = DeleteMigrationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteMigrationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteMigrationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteMigrationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteSourceResponse deleteSource(DeleteSourceRequest request) {
        LOG.trace("Called deleteSource");
        DeleteSourceRequest interceptedRequest = DeleteSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSourceResponse> transformer = DeleteSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteSourceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteSourceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteSourceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetMigrationResponse getMigration(GetMigrationRequest request) {
        LOG.trace("Called getMigration");
        GetMigrationRequest interceptedRequest = GetMigrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetMigrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetMigrationResponse> transformer = GetMigrationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetMigrationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetMigrationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetMigrationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetSourceResponse getSource(GetSourceRequest request) {
        LOG.trace("Called getSource");
        GetSourceRequest interceptedRequest = GetSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSourceResponse> transformer = GetSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetSourceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetSourceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetSourceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListMigrationsResponse listMigrations(ListMigrationsRequest request) {
        LOG.trace("Called listMigrations");
        ListMigrationsRequest interceptedRequest = ListMigrationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMigrationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMigrationsResponse> transformer = ListMigrationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListMigrationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListMigrationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListMigrationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSourceApplicationsResponse listSourceApplications(ListSourceApplicationsRequest request) {
        LOG.trace("Called listSourceApplications");
        ListSourceApplicationsRequest interceptedRequest = ListSourceApplicationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourceApplicationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSourceApplicationsResponse> transformer = ListSourceApplicationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSourceApplicationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSourceApplicationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSourceApplicationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSourcesResponse listSources(ListSourcesRequest request) {
        LOG.trace("Called listSources");
        ListSourcesRequest interceptedRequest = ListSourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourcesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSourcesResponse> transformer = ListSourcesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSourcesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSourcesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSourcesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public MigrateApplicationResponse migrateApplication(MigrateApplicationRequest request) {
        LOG.trace("Called migrateApplication");
        MigrateApplicationRequest interceptedRequest = MigrateApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = MigrateApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, MigrateApplicationResponse> transformer = MigrateApplicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (MigrateApplicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (MigrateApplicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (MigrateApplicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateMigrationResponse updateMigration(UpdateMigrationRequest request) {
        LOG.trace("Called updateMigration");
        UpdateMigrationRequest interceptedRequest = UpdateMigrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateMigrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateMigrationResponse> transformer = UpdateMigrationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateMigrationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateMigrationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateMigrationDetails(), (BmcRequest)retriedRequest);
                return (UpdateMigrationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateSourceResponse updateSource(UpdateSourceRequest request) {
        LOG.trace("Called updateSource");
        UpdateSourceRequest interceptedRequest = UpdateSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSourceResponse> transformer = UpdateSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateSourceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateSourceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateSourceDetails(), (BmcRequest)retriedRequest);
                return (UpdateSourceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ApplicationMigrationWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ApplicationMigrationPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApplicationMigrationClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ApplicationMigrationClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ApplicationMigrationClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

