/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.applicationmigration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.applicationmigration.model.UpdateMigrationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateMigrationRequest
extends BmcRequest<UpdateMigrationDetails> {
    private String migrationId;
    private UpdateMigrationDetails updateMigrationDetails;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    @InternalSdk
    public UpdateMigrationDetails getBody$() {
        return this.updateMigrationDetails;
    }

    @ConstructorProperties(value={"migrationId", "updateMigrationDetails", "opcRequestId", "opcRetryToken", "ifMatch"})
    UpdateMigrationRequest(String migrationId, UpdateMigrationDetails updateMigrationDetails, String opcRequestId, String opcRetryToken, String ifMatch) {
        this.migrationId = migrationId;
        this.updateMigrationDetails = updateMigrationDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getMigrationId() {
        return this.migrationId;
    }

    public UpdateMigrationDetails getUpdateMigrationDetails() {
        return this.updateMigrationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateMigrationRequest, UpdateMigrationDetails> {
        private String migrationId;
        private UpdateMigrationDetails updateMigrationDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateMigrationRequest o) {
            this.migrationId(o.getMigrationId());
            this.updateMigrationDetails(o.getUpdateMigrationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateMigrationRequest build() {
            UpdateMigrationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateMigrationDetails body) {
            this.updateMigrationDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder migrationId(String migrationId) {
            this.migrationId = migrationId;
            return this;
        }

        public Builder updateMigrationDetails(UpdateMigrationDetails updateMigrationDetails) {
            this.updateMigrationDetails = updateMigrationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateMigrationRequest buildWithoutInvocationCallback() {
            return new UpdateMigrationRequest(this.migrationId, this.updateMigrationDetails, this.opcRequestId, this.opcRetryToken, this.ifMatch);
        }

        public String toString() {
            return "UpdateMigrationRequest.Builder(migrationId=" + this.migrationId + ", updateMigrationDetails=" + this.updateMigrationDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

