/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.artifacts.Artifacts;
import com.oracle.bmc.artifacts.model.ContainerImageSummary;
import com.oracle.bmc.artifacts.model.ContainerRepositorySummary;
import com.oracle.bmc.artifacts.requests.ListContainerImagesRequest;
import com.oracle.bmc.artifacts.requests.ListContainerRepositoriesRequest;
import com.oracle.bmc.artifacts.responses.ListContainerImagesResponse;
import com.oracle.bmc.artifacts.responses.ListContainerRepositoriesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class ArtifactsPaginators {
    private final Artifacts client;

    public Iterable<ListContainerImagesResponse> listContainerImagesResponseIterator(final ListContainerImagesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListContainerImagesRequest.Builder>(){

            public ListContainerImagesRequest.Builder get() {
                return ListContainerImagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerImagesResponse, String>(){

            public String apply(ListContainerImagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerImagesRequest.Builder>, ListContainerImagesRequest>(){

            public ListContainerImagesRequest apply(RequestBuilderAndToken<ListContainerImagesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListContainerImagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerImagesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListContainerImagesRequest, ListContainerImagesResponse>(){

            public ListContainerImagesResponse apply(ListContainerImagesRequest request) {
                return ArtifactsPaginators.this.client.listContainerImages(request);
            }
        });
    }

    public Iterable<ContainerImageSummary> listContainerImagesRecordIterator(final ListContainerImagesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListContainerImagesRequest.Builder>(){

            public ListContainerImagesRequest.Builder get() {
                return ListContainerImagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerImagesResponse, String>(){

            public String apply(ListContainerImagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerImagesRequest.Builder>, ListContainerImagesRequest>(){

            public ListContainerImagesRequest apply(RequestBuilderAndToken<ListContainerImagesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListContainerImagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerImagesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListContainerImagesRequest, ListContainerImagesResponse>(){

            public ListContainerImagesResponse apply(ListContainerImagesRequest request) {
                return ArtifactsPaginators.this.client.listContainerImages(request);
            }
        }, (Function)new Function<ListContainerImagesResponse, List<ContainerImageSummary>>(){

            public List<ContainerImageSummary> apply(ListContainerImagesResponse response) {
                return response.getContainerImageCollection().getItems();
            }
        });
    }

    public Iterable<ListContainerRepositoriesResponse> listContainerRepositoriesResponseIterator(final ListContainerRepositoriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListContainerRepositoriesRequest.Builder>(){

            public ListContainerRepositoriesRequest.Builder get() {
                return ListContainerRepositoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerRepositoriesResponse, String>(){

            public String apply(ListContainerRepositoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerRepositoriesRequest.Builder>, ListContainerRepositoriesRequest>(){

            public ListContainerRepositoriesRequest apply(RequestBuilderAndToken<ListContainerRepositoriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListContainerRepositoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerRepositoriesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListContainerRepositoriesRequest, ListContainerRepositoriesResponse>(){

            public ListContainerRepositoriesResponse apply(ListContainerRepositoriesRequest request) {
                return ArtifactsPaginators.this.client.listContainerRepositories(request);
            }
        });
    }

    public Iterable<ContainerRepositorySummary> listContainerRepositoriesRecordIterator(final ListContainerRepositoriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListContainerRepositoriesRequest.Builder>(){

            public ListContainerRepositoriesRequest.Builder get() {
                return ListContainerRepositoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerRepositoriesResponse, String>(){

            public String apply(ListContainerRepositoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerRepositoriesRequest.Builder>, ListContainerRepositoriesRequest>(){

            public ListContainerRepositoriesRequest apply(RequestBuilderAndToken<ListContainerRepositoriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListContainerRepositoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerRepositoriesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListContainerRepositoriesRequest, ListContainerRepositoriesResponse>(){

            public ListContainerRepositoriesResponse apply(ListContainerRepositoriesRequest request) {
                return ArtifactsPaginators.this.client.listContainerRepositories(request);
            }
        }, (Function)new Function<ListContainerRepositoriesResponse, List<ContainerRepositorySummary>>(){

            public List<ContainerRepositorySummary> apply(ListContainerRepositoriesResponse response) {
                return response.getContainerRepositoryCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public ArtifactsPaginators(Artifacts client) {
        this.client = client;
    }
}

