/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListContainerImagesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Boolean compartmentIdInSubtree;
    private String displayName;
    private String imageId;
    private Boolean isVersioned;
    private String repositoryId;
    private String repositoryName;
    private String version;
    private String lifecycleState;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private SortBy sortBy;
    private SortOrder sortOrder;

    @ConstructorProperties(value={"compartmentId", "compartmentIdInSubtree", "displayName", "imageId", "isVersioned", "repositoryId", "repositoryName", "version", "lifecycleState", "limit", "page", "opcRequestId", "sortBy", "sortOrder"})
    ListContainerImagesRequest(String compartmentId, Boolean compartmentIdInSubtree, String displayName, String imageId, Boolean isVersioned, String repositoryId, String repositoryName, String version, String lifecycleState, Integer limit, String page, String opcRequestId, SortBy sortBy, SortOrder sortOrder) {
        this.compartmentId = compartmentId;
        this.compartmentIdInSubtree = compartmentIdInSubtree;
        this.displayName = displayName;
        this.imageId = imageId;
        this.isVersioned = isVersioned;
        this.repositoryId = repositoryId;
        this.repositoryName = repositoryName;
        this.version = version;
        this.lifecycleState = lifecycleState;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getImageId() {
        return this.imageId;
    }

    public Boolean getIsVersioned() {
        return this.isVersioned;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static class Builder
    implements BmcRequest.Builder<ListContainerImagesRequest, Void> {
        private String compartmentId;
        private Boolean compartmentIdInSubtree;
        private String displayName;
        private String imageId;
        private Boolean isVersioned;
        private String repositoryId;
        private String repositoryName;
        private String version;
        private String lifecycleState;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListContainerImagesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.displayName(o.getDisplayName());
            this.imageId(o.getImageId());
            this.isVersioned(o.getIsVersioned());
            this.repositoryId(o.getRepositoryId());
            this.repositoryName(o.getRepositoryName());
            this.version(o.getVersion());
            this.lifecycleState(o.getLifecycleState());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListContainerImagesRequest build() {
            ListContainerImagesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder isVersioned(Boolean isVersioned) {
            this.isVersioned = isVersioned;
            return this;
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder lifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListContainerImagesRequest buildWithoutInvocationCallback() {
            return new ListContainerImagesRequest(this.compartmentId, this.compartmentIdInSubtree, this.displayName, this.imageId, this.isVersioned, this.repositoryId, this.repositoryName, this.version, this.lifecycleState, this.limit, this.page, this.opcRequestId, this.sortBy, this.sortOrder);
        }

        public String toString() {
            return "ListContainerImagesRequest.Builder(compartmentId=" + this.compartmentId + ", compartmentIdInSubtree=" + this.compartmentIdInSubtree + ", displayName=" + this.displayName + ", imageId=" + this.imageId + ", isVersioned=" + this.isVersioned + ", repositoryId=" + this.repositoryId + ", repositoryName=" + this.repositoryName + ", version=" + this.version + ", lifecycleState=" + this.lifecycleState + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

