/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.autoscaling.model.AutoScalingPolicy;
import com.oracle.bmc.autoscaling.requests.UpdateAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.responses.UpdateAutoScalingPolicyResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateAutoScalingPolicyConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateAutoScalingPolicyConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateAutoScalingPolicyRequest interceptRequest(UpdateAutoScalingPolicyRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateAutoScalingPolicyRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAutoScalingPolicyId(), (String)"autoScalingPolicyId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateAutoScalingPolicyDetails(), (String)"updateAutoScalingPolicyDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181001").path("autoScalingConfigurations").path(HttpUtils.encodePathSegment((String)request.getAutoScalingConfigurationId())).path("policies").path(HttpUtils.encodePathSegment((String)request.getAutoScalingPolicyId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, UpdateAutoScalingPolicyResponse> fromResponse() {
        Function<Response, UpdateAutoScalingPolicyResponse> transformer = new Function<Response, UpdateAutoScalingPolicyResponse>(){

            public UpdateAutoScalingPolicyResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.autoscaling.responses.UpdateAutoScalingPolicyResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(AutoScalingPolicy.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UpdateAutoScalingPolicyResponse.Builder builder = UpdateAutoScalingPolicyResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.autoScalingPolicy((AutoScalingPolicy)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                UpdateAutoScalingPolicyResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

