/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.AutoScalePolicyRule;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutoScalePolicy {
    @JsonProperty(value="policyType")
    private final PolicyType policyType;
    @JsonProperty(value="rules")
    private final List<AutoScalePolicyRule> rules;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().policyType(this.policyType).rules(this.rules);
    }

    public PolicyType getPolicyType() {
        return this.policyType;
    }

    public List<AutoScalePolicyRule> getRules() {
        return this.rules;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoScalePolicy)) {
            return false;
        }
        AutoScalePolicy other = (AutoScalePolicy)o;
        PolicyType this$policyType = this.getPolicyType();
        PolicyType other$policyType = other.getPolicyType();
        if (this$policyType == null ? other$policyType != null : !((Object)((Object)this$policyType)).equals((Object)other$policyType)) {
            return false;
        }
        List<AutoScalePolicyRule> this$rules = this.getRules();
        List<AutoScalePolicyRule> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PolicyType $policyType = this.getPolicyType();
        result = result * 59 + ($policyType == null ? 43 : ((Object)((Object)$policyType)).hashCode());
        List<AutoScalePolicyRule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "AutoScalePolicy(policyType=" + (Object)((Object)this.getPolicyType()) + ", rules=" + this.getRules() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"policyType", "rules"})
    @Deprecated
    public AutoScalePolicy(PolicyType policyType, List<AutoScalePolicyRule> rules) {
        this.policyType = policyType;
        this.rules = rules;
    }

    public static enum PolicyType {
        ThresholdBased("THRESHOLD_BASED"),
        ScheduleBased("SCHEDULE_BASED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PolicyType> map;

        private PolicyType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PolicyType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PolicyType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PolicyType.class);
            map = new HashMap<String, PolicyType>();
            for (PolicyType v : PolicyType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="policyType")
        private PolicyType policyType;
        @JsonProperty(value="rules")
        private List<AutoScalePolicyRule> rules;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder policyType(PolicyType policyType) {
            this.policyType = policyType;
            this.__explicitlySet__.add("policyType");
            return this;
        }

        public Builder rules(List<AutoScalePolicyRule> rules) {
            this.rules = rules;
            this.__explicitlySet__.add("rules");
            return this;
        }

        public AutoScalePolicy build() {
            AutoScalePolicy __instance__ = new AutoScalePolicy(this.policyType, this.rules);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(AutoScalePolicy o) {
            Builder copiedBuilder = this.policyType(o.getPolicyType()).rules(o.getRules());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "AutoScalePolicy.Builder(policyType=" + (Object)((Object)this.policyType) + ", rules=" + this.rules + ")";
        }
    }
}

