/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetAutoScalingConfigurationRequest
extends BmcRequest<Void> {
    private String bdsInstanceId;
    private String autoScalingConfigurationId;
    private String opcRequestId;

    @ConstructorProperties(value={"bdsInstanceId", "autoScalingConfigurationId", "opcRequestId"})
    GetAutoScalingConfigurationRequest(String bdsInstanceId, String autoScalingConfigurationId, String opcRequestId) {
        this.bdsInstanceId = bdsInstanceId;
        this.autoScalingConfigurationId = autoScalingConfigurationId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBdsInstanceId() {
        return this.bdsInstanceId;
    }

    public String getAutoScalingConfigurationId() {
        return this.autoScalingConfigurationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAutoScalingConfigurationRequest, Void> {
        private String bdsInstanceId;
        private String autoScalingConfigurationId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAutoScalingConfigurationRequest o) {
            this.bdsInstanceId(o.getBdsInstanceId());
            this.autoScalingConfigurationId(o.getAutoScalingConfigurationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAutoScalingConfigurationRequest build() {
            GetAutoScalingConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder bdsInstanceId(String bdsInstanceId) {
            this.bdsInstanceId = bdsInstanceId;
            return this;
        }

        public Builder autoScalingConfigurationId(String autoScalingConfigurationId) {
            this.autoScalingConfigurationId = autoScalingConfigurationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetAutoScalingConfigurationRequest buildWithoutInvocationCallback() {
            return new GetAutoScalingConfigurationRequest(this.bdsInstanceId, this.autoScalingConfigurationId, this.opcRequestId);
        }

        public String toString() {
            return "GetAutoScalingConfigurationRequest.Builder(bdsInstanceId=" + this.bdsInstanceId + ", autoScalingConfigurationId=" + this.autoScalingConfigurationId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

