/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.budget.Budget;
import com.oracle.bmc.budget.model.AlertRuleSummary;
import com.oracle.bmc.budget.model.BudgetSummary;
import com.oracle.bmc.budget.requests.ListAlertRulesRequest;
import com.oracle.bmc.budget.requests.ListBudgetsRequest;
import com.oracle.bmc.budget.responses.ListAlertRulesResponse;
import com.oracle.bmc.budget.responses.ListBudgetsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class BudgetPaginators {
    private final Budget client;

    public Iterable<ListAlertRulesResponse> listAlertRulesResponseIterator(final ListAlertRulesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAlertRulesRequest.Builder>(){

            public ListAlertRulesRequest.Builder get() {
                return ListAlertRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAlertRulesResponse, String>(){

            public String apply(ListAlertRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAlertRulesRequest.Builder>, ListAlertRulesRequest>(){

            public ListAlertRulesRequest apply(RequestBuilderAndToken<ListAlertRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAlertRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAlertRulesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAlertRulesRequest, ListAlertRulesResponse>(){

            public ListAlertRulesResponse apply(ListAlertRulesRequest request) {
                return BudgetPaginators.this.client.listAlertRules(request);
            }
        });
    }

    public Iterable<AlertRuleSummary> listAlertRulesRecordIterator(final ListAlertRulesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAlertRulesRequest.Builder>(){

            public ListAlertRulesRequest.Builder get() {
                return ListAlertRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAlertRulesResponse, String>(){

            public String apply(ListAlertRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAlertRulesRequest.Builder>, ListAlertRulesRequest>(){

            public ListAlertRulesRequest apply(RequestBuilderAndToken<ListAlertRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAlertRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAlertRulesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAlertRulesRequest, ListAlertRulesResponse>(){

            public ListAlertRulesResponse apply(ListAlertRulesRequest request) {
                return BudgetPaginators.this.client.listAlertRules(request);
            }
        }, (Function)new Function<ListAlertRulesResponse, List<AlertRuleSummary>>(){

            public List<AlertRuleSummary> apply(ListAlertRulesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListBudgetsResponse> listBudgetsResponseIterator(final ListBudgetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBudgetsRequest.Builder>(){

            public ListBudgetsRequest.Builder get() {
                return ListBudgetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBudgetsResponse, String>(){

            public String apply(ListBudgetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBudgetsRequest.Builder>, ListBudgetsRequest>(){

            public ListBudgetsRequest apply(RequestBuilderAndToken<ListBudgetsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListBudgetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBudgetsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListBudgetsRequest, ListBudgetsResponse>(){

            public ListBudgetsResponse apply(ListBudgetsRequest request) {
                return BudgetPaginators.this.client.listBudgets(request);
            }
        });
    }

    public Iterable<BudgetSummary> listBudgetsRecordIterator(final ListBudgetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBudgetsRequest.Builder>(){

            public ListBudgetsRequest.Builder get() {
                return ListBudgetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBudgetsResponse, String>(){

            public String apply(ListBudgetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBudgetsRequest.Builder>, ListBudgetsRequest>(){

            public ListBudgetsRequest apply(RequestBuilderAndToken<ListBudgetsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListBudgetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBudgetsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListBudgetsRequest, ListBudgetsResponse>(){

            public ListBudgetsResponse apply(ListBudgetsRequest request) {
                return BudgetPaginators.this.client.listBudgets(request);
            }
        }, (Function)new Function<ListBudgetsResponse, List<BudgetSummary>>(){

            public List<BudgetSummary> apply(ListBudgetsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public BudgetPaginators(Budget client) {
        this.client = client;
    }
}

