/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteAlertRuleRequest
extends BmcRequest<Void> {
    private String budgetId;
    private String alertRuleId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"budgetId", "alertRuleId", "ifMatch", "opcRequestId"})
    DeleteAlertRuleRequest(String budgetId, String alertRuleId, String ifMatch, String opcRequestId) {
        this.budgetId = budgetId;
        this.alertRuleId = alertRuleId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBudgetId() {
        return this.budgetId;
    }

    public String getAlertRuleId() {
        return this.alertRuleId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteAlertRuleRequest, Void> {
        private String budgetId;
        private String alertRuleId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteAlertRuleRequest o) {
            this.budgetId(o.getBudgetId());
            this.alertRuleId(o.getAlertRuleId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteAlertRuleRequest build() {
            DeleteAlertRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public Builder alertRuleId(String alertRuleId) {
            this.alertRuleId = alertRuleId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteAlertRuleRequest buildWithoutInvocationCallback() {
            return new DeleteAlertRuleRequest(this.budgetId, this.alertRuleId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteAlertRuleRequest.Builder(budgetId=" + this.budgetId + ", alertRuleId=" + this.alertRuleId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

