/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteBudgetRequest
extends BmcRequest<Void> {
    private String budgetId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"budgetId", "ifMatch", "opcRequestId"})
    DeleteBudgetRequest(String budgetId, String ifMatch, String opcRequestId) {
        this.budgetId = budgetId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBudgetId() {
        return this.budgetId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteBudgetRequest, Void> {
        private String budgetId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteBudgetRequest o) {
            this.budgetId(o.getBudgetId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteBudgetRequest build() {
            DeleteBudgetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteBudgetRequest buildWithoutInvocationCallback() {
            return new DeleteBudgetRequest(this.budgetId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteBudgetRequest.Builder(budgetId=" + this.budgetId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

