/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetAlertRuleRequest
extends BmcRequest<Void> {
    private String budgetId;
    private String alertRuleId;
    private String opcRequestId;

    @ConstructorProperties(value={"budgetId", "alertRuleId", "opcRequestId"})
    GetAlertRuleRequest(String budgetId, String alertRuleId, String opcRequestId) {
        this.budgetId = budgetId;
        this.alertRuleId = alertRuleId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBudgetId() {
        return this.budgetId;
    }

    public String getAlertRuleId() {
        return this.alertRuleId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAlertRuleRequest, Void> {
        private String budgetId;
        private String alertRuleId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAlertRuleRequest o) {
            this.budgetId(o.getBudgetId());
            this.alertRuleId(o.getAlertRuleId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAlertRuleRequest build() {
            GetAlertRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public Builder alertRuleId(String alertRuleId) {
            this.alertRuleId = alertRuleId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetAlertRuleRequest buildWithoutInvocationCallback() {
            return new GetAlertRuleRequest(this.budgetId, this.alertRuleId, this.opcRequestId);
        }

        public String toString() {
            return "GetAlertRuleRequest.Builder(budgetId=" + this.budgetId + ", alertRuleId=" + this.alertRuleId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

