/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.cims.model.Status;
import com.oracle.bmc.cims.requests.GetStatusRequest;
import com.oracle.bmc.cims.responses.GetStatusResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetStatusConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetStatusConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetStatusRequest interceptRequest(GetStatusRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetStatusRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getSource(), (String)"source must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getOcid(), (String)"ocid is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181231").path("v2").path("incidents").path("status").path(HttpUtils.encodePathSegment((String)request.getSource()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        ib.header("ocid", (Object)request.getOcid());
        if (request.getHomeregion() != null) {
            ib.header("homeregion", (Object)request.getHomeregion());
        }
        return ib;
    }

    public static Function<Response, GetStatusResponse> fromResponse() {
        Function<Response, GetStatusResponse> transformer = new Function<Response, GetStatusResponse>(){

            public GetStatusResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.cims.responses.GetStatusResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Status.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetStatusResponse.Builder builder = GetStatusResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.status((Status)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetStatusResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

