/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.requests;

import com.oracle.bmc.cims.model.LifecycleState;
import com.oracle.bmc.cims.model.SortBy;
import com.oracle.bmc.cims.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListIncidentsRequest
extends BmcRequest<Void> {
    private String csi;
    private String compartmentId;
    private String ocid;
    private Integer limit;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private LifecycleState lifecycleState;
    private String page;
    private String opcRequestId;
    private String homeregion;
    private String problemType;

    @ConstructorProperties(value={"csi", "compartmentId", "ocid", "limit", "sortBy", "sortOrder", "lifecycleState", "page", "opcRequestId", "homeregion", "problemType"})
    ListIncidentsRequest(String csi, String compartmentId, String ocid, Integer limit, SortBy sortBy, SortOrder sortOrder, LifecycleState lifecycleState, String page, String opcRequestId, String homeregion, String problemType) {
        this.csi = csi;
        this.compartmentId = compartmentId;
        this.ocid = ocid;
        this.limit = limit;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.lifecycleState = lifecycleState;
        this.page = page;
        this.opcRequestId = opcRequestId;
        this.homeregion = homeregion;
        this.problemType = problemType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCsi() {
        return this.csi;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOcid() {
        return this.ocid;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getHomeregion() {
        return this.homeregion;
    }

    public String getProblemType() {
        return this.problemType;
    }

    public static class Builder
    implements BmcRequest.Builder<ListIncidentsRequest, Void> {
        private String csi;
        private String compartmentId;
        private String ocid;
        private Integer limit;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private LifecycleState lifecycleState;
        private String page;
        private String opcRequestId;
        private String homeregion;
        private String problemType;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListIncidentsRequest o) {
            this.csi(o.getCsi());
            this.compartmentId(o.getCompartmentId());
            this.ocid(o.getOcid());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.homeregion(o.getHomeregion());
            this.problemType(o.getProblemType());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListIncidentsRequest build() {
            ListIncidentsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder csi(String csi) {
            this.csi = csi;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder homeregion(String homeregion) {
            this.homeregion = homeregion;
            return this;
        }

        public Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        public ListIncidentsRequest buildWithoutInvocationCallback() {
            return new ListIncidentsRequest(this.csi, this.compartmentId, this.ocid, this.limit, this.sortBy, this.sortOrder, this.lifecycleState, this.page, this.opcRequestId, this.homeregion, this.problemType);
        }

        public String toString() {
            return "ListIncidentsRequest.Builder(csi=" + this.csi + ", compartmentId=" + this.compartmentId + ", ocid=" + this.ocid + ", limit=" + this.limit + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ", homeregion=" + this.homeregion + ", problemType=" + this.problemType + ")";
        }
    }
}

