/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ValidateUserRequest
extends BmcRequest<Void> {
    private String csi;
    private String ocid;
    private String opcRequestId;
    private String problemType;
    private String homeregion;

    @ConstructorProperties(value={"csi", "ocid", "opcRequestId", "problemType", "homeregion"})
    ValidateUserRequest(String csi, String ocid, String opcRequestId, String problemType, String homeregion) {
        this.csi = csi;
        this.ocid = ocid;
        this.opcRequestId = opcRequestId;
        this.problemType = problemType;
        this.homeregion = homeregion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCsi() {
        return this.csi;
    }

    public String getOcid() {
        return this.ocid;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getProblemType() {
        return this.problemType;
    }

    public String getHomeregion() {
        return this.homeregion;
    }

    public static class Builder
    implements BmcRequest.Builder<ValidateUserRequest, Void> {
        private String csi;
        private String ocid;
        private String opcRequestId;
        private String problemType;
        private String homeregion;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ValidateUserRequest o) {
            this.csi(o.getCsi());
            this.ocid(o.getOcid());
            this.opcRequestId(o.getOpcRequestId());
            this.problemType(o.getProblemType());
            this.homeregion(o.getHomeregion());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ValidateUserRequest build() {
            ValidateUserRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder csi(String csi) {
            this.csi = csi;
            return this;
        }

        public Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        public Builder homeregion(String homeregion) {
            this.homeregion = homeregion;
            return this;
        }

        public ValidateUserRequest buildWithoutInvocationCallback() {
            return new ValidateUserRequest(this.csi, this.ocid, this.opcRequestId, this.problemType, this.homeregion);
        }

        public String toString() {
            return "ValidateUserRequest.Builder(csi=" + this.csi + ", ocid=" + this.ocid + ", opcRequestId=" + this.opcRequestId + ", problemType=" + this.problemType + ", homeregion=" + this.homeregion + ")";
        }
    }
}

