/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.cloudguard.CloudGuard;
import com.oracle.bmc.cloudguard.CloudGuardPaginators;
import com.oracle.bmc.cloudguard.CloudGuardWaiters;
import com.oracle.bmc.cloudguard.internal.http.ChangeDetectorRecipeCompartmentConverter;
import com.oracle.bmc.cloudguard.internal.http.ChangeManagedListCompartmentConverter;
import com.oracle.bmc.cloudguard.internal.http.ChangeResponderRecipeCompartmentConverter;
import com.oracle.bmc.cloudguard.internal.http.CreateDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.CreateManagedListConverter;
import com.oracle.bmc.cloudguard.internal.http.CreateResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.CreateTargetConverter;
import com.oracle.bmc.cloudguard.internal.http.CreateTargetDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.CreateTargetResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.DeleteDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.DeleteManagedListConverter;
import com.oracle.bmc.cloudguard.internal.http.DeleteResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.DeleteTargetConverter;
import com.oracle.bmc.cloudguard.internal.http.DeleteTargetDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.DeleteTargetResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.ExecuteResponderExecutionConverter;
import com.oracle.bmc.cloudguard.internal.http.GetConditionMetadataTypeConverter;
import com.oracle.bmc.cloudguard.internal.http.GetConfigurationConverter;
import com.oracle.bmc.cloudguard.internal.http.GetDetectorConverter;
import com.oracle.bmc.cloudguard.internal.http.GetDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.GetDetectorRecipeDetectorRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.GetDetectorRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.GetManagedListConverter;
import com.oracle.bmc.cloudguard.internal.http.GetProblemConverter;
import com.oracle.bmc.cloudguard.internal.http.GetResponderExecutionConverter;
import com.oracle.bmc.cloudguard.internal.http.GetResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.GetResponderRecipeResponderRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.GetResponderRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.GetTargetConverter;
import com.oracle.bmc.cloudguard.internal.http.GetTargetDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.GetTargetDetectorRecipeDetectorRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.GetTargetResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.GetTargetResponderRecipeResponderRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.ListConditionMetadataTypesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListDetectorRecipeDetectorRulesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListDetectorRecipesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListDetectorRulesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListDetectorsConverter;
import com.oracle.bmc.cloudguard.internal.http.ListImpactedResourcesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListManagedListTypesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListManagedListsConverter;
import com.oracle.bmc.cloudguard.internal.http.ListProblemHistoriesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListProblemsConverter;
import com.oracle.bmc.cloudguard.internal.http.ListRecommendationsConverter;
import com.oracle.bmc.cloudguard.internal.http.ListResourceTypesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListResponderActivitiesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListResponderExecutionsConverter;
import com.oracle.bmc.cloudguard.internal.http.ListResponderRecipeResponderRulesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListResponderRecipesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListResponderRulesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListTargetDetectorRecipeDetectorRulesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListTargetDetectorRecipesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListTargetResponderRecipeResponderRulesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListTargetResponderRecipesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListTargetsConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestRiskScoresConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSecurityScoreSummarizedTrendConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSecurityScoresConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedActivityProblemsConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedProblemsConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedResponderExecutionsConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedRiskScoresConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedSecurityScoresConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedTrendProblemsConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedTrendResponderExecutionsConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedTrendSecurityScoresConverter;
import com.oracle.bmc.cloudguard.internal.http.SkipBulkResponderExecutionConverter;
import com.oracle.bmc.cloudguard.internal.http.SkipResponderExecutionConverter;
import com.oracle.bmc.cloudguard.internal.http.TriggerResponderConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateBulkProblemStatusConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateConfigurationConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateDetectorRecipeDetectorRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateManagedListConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateProblemStatusConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateResponderRecipeResponderRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateTargetConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateTargetDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateTargetDetectorRecipeDetectorRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateTargetResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateTargetResponderRecipeResponderRuleConverter;
import com.oracle.bmc.cloudguard.requests.ChangeDetectorRecipeCompartmentRequest;
import com.oracle.bmc.cloudguard.requests.ChangeManagedListCompartmentRequest;
import com.oracle.bmc.cloudguard.requests.ChangeResponderRecipeCompartmentRequest;
import com.oracle.bmc.cloudguard.requests.CreateDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.CreateManagedListRequest;
import com.oracle.bmc.cloudguard.requests.CreateResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.CreateTargetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.CreateTargetRequest;
import com.oracle.bmc.cloudguard.requests.CreateTargetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.DeleteDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.DeleteManagedListRequest;
import com.oracle.bmc.cloudguard.requests.DeleteResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.DeleteTargetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.DeleteTargetRequest;
import com.oracle.bmc.cloudguard.requests.DeleteTargetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.ExecuteResponderExecutionRequest;
import com.oracle.bmc.cloudguard.requests.GetConditionMetadataTypeRequest;
import com.oracle.bmc.cloudguard.requests.GetConfigurationRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetManagedListRequest;
import com.oracle.bmc.cloudguard.requests.GetProblemRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderExecutionRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.ListConditionMetadataTypesRequest;
import com.oracle.bmc.cloudguard.requests.ListDetectorRecipeDetectorRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListDetectorRecipesRequest;
import com.oracle.bmc.cloudguard.requests.ListDetectorRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListDetectorsRequest;
import com.oracle.bmc.cloudguard.requests.ListImpactedResourcesRequest;
import com.oracle.bmc.cloudguard.requests.ListManagedListTypesRequest;
import com.oracle.bmc.cloudguard.requests.ListManagedListsRequest;
import com.oracle.bmc.cloudguard.requests.ListProblemHistoriesRequest;
import com.oracle.bmc.cloudguard.requests.ListProblemsRequest;
import com.oracle.bmc.cloudguard.requests.ListRecommendationsRequest;
import com.oracle.bmc.cloudguard.requests.ListResourceTypesRequest;
import com.oracle.bmc.cloudguard.requests.ListResponderActivitiesRequest;
import com.oracle.bmc.cloudguard.requests.ListResponderExecutionsRequest;
import com.oracle.bmc.cloudguard.requests.ListResponderRecipeResponderRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListResponderRecipesRequest;
import com.oracle.bmc.cloudguard.requests.ListResponderRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListTargetDetectorRecipeDetectorRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListTargetDetectorRecipesRequest;
import com.oracle.bmc.cloudguard.requests.ListTargetResponderRecipeResponderRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListTargetResponderRecipesRequest;
import com.oracle.bmc.cloudguard.requests.ListTargetsRequest;
import com.oracle.bmc.cloudguard.requests.RequestRiskScoresRequest;
import com.oracle.bmc.cloudguard.requests.RequestSecurityScoreSummarizedTrendRequest;
import com.oracle.bmc.cloudguard.requests.RequestSecurityScoresRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedActivityProblemsRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedProblemsRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedResponderExecutionsRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedRiskScoresRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedSecurityScoresRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedTrendProblemsRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedTrendResponderExecutionsRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedTrendSecurityScoresRequest;
import com.oracle.bmc.cloudguard.requests.SkipBulkResponderExecutionRequest;
import com.oracle.bmc.cloudguard.requests.SkipResponderExecutionRequest;
import com.oracle.bmc.cloudguard.requests.TriggerResponderRequest;
import com.oracle.bmc.cloudguard.requests.UpdateBulkProblemStatusRequest;
import com.oracle.bmc.cloudguard.requests.UpdateConfigurationRequest;
import com.oracle.bmc.cloudguard.requests.UpdateDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.UpdateDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.UpdateManagedListRequest;
import com.oracle.bmc.cloudguard.requests.UpdateProblemStatusRequest;
import com.oracle.bmc.cloudguard.requests.UpdateResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.UpdateResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.UpdateTargetDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.UpdateTargetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.UpdateTargetRequest;
import com.oracle.bmc.cloudguard.requests.UpdateTargetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.UpdateTargetResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.responses.ChangeDetectorRecipeCompartmentResponse;
import com.oracle.bmc.cloudguard.responses.ChangeManagedListCompartmentResponse;
import com.oracle.bmc.cloudguard.responses.ChangeResponderRecipeCompartmentResponse;
import com.oracle.bmc.cloudguard.responses.CreateDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.CreateManagedListResponse;
import com.oracle.bmc.cloudguard.responses.CreateResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.CreateTargetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.CreateTargetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.CreateTargetResponse;
import com.oracle.bmc.cloudguard.responses.DeleteDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.DeleteManagedListResponse;
import com.oracle.bmc.cloudguard.responses.DeleteResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.DeleteTargetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.DeleteTargetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.DeleteTargetResponse;
import com.oracle.bmc.cloudguard.responses.ExecuteResponderExecutionResponse;
import com.oracle.bmc.cloudguard.responses.GetConditionMetadataTypeResponse;
import com.oracle.bmc.cloudguard.responses.GetConfigurationResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetManagedListResponse;
import com.oracle.bmc.cloudguard.responses.GetProblemResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderExecutionResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetResponse;
import com.oracle.bmc.cloudguard.responses.ListConditionMetadataTypesResponse;
import com.oracle.bmc.cloudguard.responses.ListDetectorRecipeDetectorRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListDetectorRecipesResponse;
import com.oracle.bmc.cloudguard.responses.ListDetectorRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListDetectorsResponse;
import com.oracle.bmc.cloudguard.responses.ListImpactedResourcesResponse;
import com.oracle.bmc.cloudguard.responses.ListManagedListTypesResponse;
import com.oracle.bmc.cloudguard.responses.ListManagedListsResponse;
import com.oracle.bmc.cloudguard.responses.ListProblemHistoriesResponse;
import com.oracle.bmc.cloudguard.responses.ListProblemsResponse;
import com.oracle.bmc.cloudguard.responses.ListRecommendationsResponse;
import com.oracle.bmc.cloudguard.responses.ListResourceTypesResponse;
import com.oracle.bmc.cloudguard.responses.ListResponderActivitiesResponse;
import com.oracle.bmc.cloudguard.responses.ListResponderExecutionsResponse;
import com.oracle.bmc.cloudguard.responses.ListResponderRecipeResponderRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListResponderRecipesResponse;
import com.oracle.bmc.cloudguard.responses.ListResponderRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListTargetDetectorRecipeDetectorRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListTargetDetectorRecipesResponse;
import com.oracle.bmc.cloudguard.responses.ListTargetResponderRecipeResponderRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListTargetResponderRecipesResponse;
import com.oracle.bmc.cloudguard.responses.ListTargetsResponse;
import com.oracle.bmc.cloudguard.responses.RequestRiskScoresResponse;
import com.oracle.bmc.cloudguard.responses.RequestSecurityScoreSummarizedTrendResponse;
import com.oracle.bmc.cloudguard.responses.RequestSecurityScoresResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedActivityProblemsResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedProblemsResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedResponderExecutionsResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedRiskScoresResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedSecurityScoresResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedTrendProblemsResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedTrendResponderExecutionsResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedTrendSecurityScoresResponse;
import com.oracle.bmc.cloudguard.responses.SkipBulkResponderExecutionResponse;
import com.oracle.bmc.cloudguard.responses.SkipResponderExecutionResponse;
import com.oracle.bmc.cloudguard.responses.TriggerResponderResponse;
import com.oracle.bmc.cloudguard.responses.UpdateBulkProblemStatusResponse;
import com.oracle.bmc.cloudguard.responses.UpdateConfigurationResponse;
import com.oracle.bmc.cloudguard.responses.UpdateDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.UpdateDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.UpdateManagedListResponse;
import com.oracle.bmc.cloudguard.responses.UpdateProblemStatusResponse;
import com.oracle.bmc.cloudguard.responses.UpdateResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.UpdateResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.UpdateTargetDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.UpdateTargetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.UpdateTargetResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.UpdateTargetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.UpdateTargetResponse;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudGuardClient
implements CloudGuard {
    private static final Logger LOG = LoggerFactory.getLogger(CloudGuardClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CLOUDGUARD").serviceEndpointPrefix("").serviceEndpointTemplate("https://cloudguard-cp-api.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final CloudGuardWaiters waiters;
    private final CloudGuardPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public CloudGuardClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public CloudGuardClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public CloudGuardClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public CloudGuardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public CloudGuardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public CloudGuardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public CloudGuardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public CloudGuardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected CloudGuardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("CloudGuard-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new CloudGuardWaiters(executorService, this);
        this.paginators = new CloudGuardPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeDetectorRecipeCompartmentResponse changeDetectorRecipeCompartment(ChangeDetectorRecipeCompartmentRequest request) {
        LOG.trace("Called changeDetectorRecipeCompartment");
        ChangeDetectorRecipeCompartmentRequest interceptedRequest = ChangeDetectorRecipeCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeDetectorRecipeCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeDetectorRecipeCompartmentResponse> transformer = ChangeDetectorRecipeCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeDetectorRecipeCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeDetectorRecipeCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeDetectorRecipeCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeDetectorRecipeCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeManagedListCompartmentResponse changeManagedListCompartment(ChangeManagedListCompartmentRequest request) {
        LOG.trace("Called changeManagedListCompartment");
        ChangeManagedListCompartmentRequest interceptedRequest = ChangeManagedListCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeManagedListCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeManagedListCompartmentResponse> transformer = ChangeManagedListCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeManagedListCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeManagedListCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeManagedListCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeManagedListCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeResponderRecipeCompartmentResponse changeResponderRecipeCompartment(ChangeResponderRecipeCompartmentRequest request) {
        LOG.trace("Called changeResponderRecipeCompartment");
        ChangeResponderRecipeCompartmentRequest interceptedRequest = ChangeResponderRecipeCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeResponderRecipeCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeResponderRecipeCompartmentResponse> transformer = ChangeResponderRecipeCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeResponderRecipeCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeResponderRecipeCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeResponderRecipeCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeResponderRecipeCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDetectorRecipeResponse createDetectorRecipe(CreateDetectorRecipeRequest request) {
        LOG.trace("Called createDetectorRecipe");
        CreateDetectorRecipeRequest interceptedRequest = CreateDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDetectorRecipeResponse> transformer = CreateDetectorRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateDetectorRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDetectorRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDetectorRecipeDetails(), (BmcRequest)retriedRequest);
                return (CreateDetectorRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateManagedListResponse createManagedList(CreateManagedListRequest request) {
        LOG.trace("Called createManagedList");
        CreateManagedListRequest interceptedRequest = CreateManagedListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateManagedListConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateManagedListResponse> transformer = CreateManagedListConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateManagedListResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateManagedListResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateManagedListDetails(), (BmcRequest)retriedRequest);
                return (CreateManagedListResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateResponderRecipeResponse createResponderRecipe(CreateResponderRecipeRequest request) {
        LOG.trace("Called createResponderRecipe");
        CreateResponderRecipeRequest interceptedRequest = CreateResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateResponderRecipeResponse> transformer = CreateResponderRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateResponderRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateResponderRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateResponderRecipeDetails(), (BmcRequest)retriedRequest);
                return (CreateResponderRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTargetResponse createTarget(CreateTargetRequest request) {
        LOG.trace("Called createTarget");
        CreateTargetRequest interceptedRequest = CreateTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTargetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTargetResponse> transformer = CreateTargetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateTargetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTargetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateTargetDetails(), (BmcRequest)retriedRequest);
                return (CreateTargetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTargetDetectorRecipeResponse createTargetDetectorRecipe(CreateTargetDetectorRecipeRequest request) {
        LOG.trace("Called createTargetDetectorRecipe");
        CreateTargetDetectorRecipeRequest interceptedRequest = CreateTargetDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTargetDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTargetDetectorRecipeResponse> transformer = CreateTargetDetectorRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateTargetDetectorRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTargetDetectorRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAttachTargetDetectorRecipeDetails(), (BmcRequest)retriedRequest);
                return (CreateTargetDetectorRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTargetResponderRecipeResponse createTargetResponderRecipe(CreateTargetResponderRecipeRequest request) {
        LOG.trace("Called createTargetResponderRecipe");
        CreateTargetResponderRecipeRequest interceptedRequest = CreateTargetResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTargetResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTargetResponderRecipeResponse> transformer = CreateTargetResponderRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateTargetResponderRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTargetResponderRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAttachTargetResponderRecipeDetails(), (BmcRequest)retriedRequest);
                return (CreateTargetResponderRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDetectorRecipeResponse deleteDetectorRecipe(DeleteDetectorRecipeRequest request) {
        LOG.trace("Called deleteDetectorRecipe");
        DeleteDetectorRecipeRequest interceptedRequest = DeleteDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDetectorRecipeResponse> transformer = DeleteDetectorRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteDetectorRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDetectorRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDetectorRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteManagedListResponse deleteManagedList(DeleteManagedListRequest request) {
        LOG.trace("Called deleteManagedList");
        DeleteManagedListRequest interceptedRequest = DeleteManagedListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteManagedListConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteManagedListResponse> transformer = DeleteManagedListConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteManagedListResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteManagedListResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteManagedListResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteResponderRecipeResponse deleteResponderRecipe(DeleteResponderRecipeRequest request) {
        LOG.trace("Called deleteResponderRecipe");
        DeleteResponderRecipeRequest interceptedRequest = DeleteResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteResponderRecipeResponse> transformer = DeleteResponderRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteResponderRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteResponderRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteResponderRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTargetResponse deleteTarget(DeleteTargetRequest request) {
        LOG.trace("Called deleteTarget");
        DeleteTargetRequest interceptedRequest = DeleteTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTargetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTargetResponse> transformer = DeleteTargetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTargetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTargetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTargetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTargetDetectorRecipeResponse deleteTargetDetectorRecipe(DeleteTargetDetectorRecipeRequest request) {
        LOG.trace("Called deleteTargetDetectorRecipe");
        DeleteTargetDetectorRecipeRequest interceptedRequest = DeleteTargetDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTargetDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTargetDetectorRecipeResponse> transformer = DeleteTargetDetectorRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTargetDetectorRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTargetDetectorRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTargetDetectorRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTargetResponderRecipeResponse deleteTargetResponderRecipe(DeleteTargetResponderRecipeRequest request) {
        LOG.trace("Called deleteTargetResponderRecipe");
        DeleteTargetResponderRecipeRequest interceptedRequest = DeleteTargetResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTargetResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTargetResponderRecipeResponse> transformer = DeleteTargetResponderRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTargetResponderRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTargetResponderRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTargetResponderRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ExecuteResponderExecutionResponse executeResponderExecution(ExecuteResponderExecutionRequest request) {
        LOG.trace("Called executeResponderExecution");
        ExecuteResponderExecutionRequest interceptedRequest = ExecuteResponderExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExecuteResponderExecutionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ExecuteResponderExecutionResponse> transformer = ExecuteResponderExecutionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ExecuteResponderExecutionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ExecuteResponderExecutionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getExecuteResponderExecutionDetails(), (BmcRequest)retriedRequest);
                return (ExecuteResponderExecutionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetConditionMetadataTypeResponse getConditionMetadataType(GetConditionMetadataTypeRequest request) {
        LOG.trace("Called getConditionMetadataType");
        GetConditionMetadataTypeRequest interceptedRequest = GetConditionMetadataTypeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConditionMetadataTypeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConditionMetadataTypeResponse> transformer = GetConditionMetadataTypeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetConditionMetadataTypeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetConditionMetadataTypeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetConditionMetadataTypeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetConfigurationResponse getConfiguration(GetConfigurationRequest request) {
        LOG.trace("Called getConfiguration");
        GetConfigurationRequest interceptedRequest = GetConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConfigurationResponse> transformer = GetConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetConfigurationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetConfigurationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDetectorResponse getDetector(GetDetectorRequest request) {
        LOG.trace("Called getDetector");
        GetDetectorRequest interceptedRequest = GetDetectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDetectorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDetectorResponse> transformer = GetDetectorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDetectorResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDetectorResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDetectorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDetectorRecipeResponse getDetectorRecipe(GetDetectorRecipeRequest request) {
        LOG.trace("Called getDetectorRecipe");
        GetDetectorRecipeRequest interceptedRequest = GetDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDetectorRecipeResponse> transformer = GetDetectorRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDetectorRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDetectorRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDetectorRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDetectorRecipeDetectorRuleResponse getDetectorRecipeDetectorRule(GetDetectorRecipeDetectorRuleRequest request) {
        LOG.trace("Called getDetectorRecipeDetectorRule");
        GetDetectorRecipeDetectorRuleRequest interceptedRequest = GetDetectorRecipeDetectorRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDetectorRecipeDetectorRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDetectorRecipeDetectorRuleResponse> transformer = GetDetectorRecipeDetectorRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDetectorRecipeDetectorRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDetectorRecipeDetectorRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDetectorRecipeDetectorRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDetectorRuleResponse getDetectorRule(GetDetectorRuleRequest request) {
        LOG.trace("Called getDetectorRule");
        GetDetectorRuleRequest interceptedRequest = GetDetectorRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDetectorRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDetectorRuleResponse> transformer = GetDetectorRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDetectorRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDetectorRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDetectorRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetManagedListResponse getManagedList(GetManagedListRequest request) {
        LOG.trace("Called getManagedList");
        GetManagedListRequest interceptedRequest = GetManagedListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagedListConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetManagedListResponse> transformer = GetManagedListConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetManagedListResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetManagedListResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetManagedListResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetProblemResponse getProblem(GetProblemRequest request) {
        LOG.trace("Called getProblem");
        GetProblemRequest interceptedRequest = GetProblemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProblemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetProblemResponse> transformer = GetProblemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetProblemResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetProblemResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetProblemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetResponderExecutionResponse getResponderExecution(GetResponderExecutionRequest request) {
        LOG.trace("Called getResponderExecution");
        GetResponderExecutionRequest interceptedRequest = GetResponderExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetResponderExecutionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetResponderExecutionResponse> transformer = GetResponderExecutionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetResponderExecutionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetResponderExecutionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetResponderExecutionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetResponderRecipeResponse getResponderRecipe(GetResponderRecipeRequest request) {
        LOG.trace("Called getResponderRecipe");
        GetResponderRecipeRequest interceptedRequest = GetResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetResponderRecipeResponse> transformer = GetResponderRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetResponderRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetResponderRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetResponderRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetResponderRecipeResponderRuleResponse getResponderRecipeResponderRule(GetResponderRecipeResponderRuleRequest request) {
        LOG.trace("Called getResponderRecipeResponderRule");
        GetResponderRecipeResponderRuleRequest interceptedRequest = GetResponderRecipeResponderRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetResponderRecipeResponderRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetResponderRecipeResponderRuleResponse> transformer = GetResponderRecipeResponderRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetResponderRecipeResponderRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetResponderRecipeResponderRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetResponderRecipeResponderRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetResponderRuleResponse getResponderRule(GetResponderRuleRequest request) {
        LOG.trace("Called getResponderRule");
        GetResponderRuleRequest interceptedRequest = GetResponderRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetResponderRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetResponderRuleResponse> transformer = GetResponderRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetResponderRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetResponderRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetResponderRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTargetResponse getTarget(GetTargetRequest request) {
        LOG.trace("Called getTarget");
        GetTargetRequest interceptedRequest = GetTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTargetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTargetResponse> transformer = GetTargetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTargetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTargetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTargetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTargetDetectorRecipeResponse getTargetDetectorRecipe(GetTargetDetectorRecipeRequest request) {
        LOG.trace("Called getTargetDetectorRecipe");
        GetTargetDetectorRecipeRequest interceptedRequest = GetTargetDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTargetDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTargetDetectorRecipeResponse> transformer = GetTargetDetectorRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTargetDetectorRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTargetDetectorRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTargetDetectorRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTargetDetectorRecipeDetectorRuleResponse getTargetDetectorRecipeDetectorRule(GetTargetDetectorRecipeDetectorRuleRequest request) {
        LOG.trace("Called getTargetDetectorRecipeDetectorRule");
        GetTargetDetectorRecipeDetectorRuleRequest interceptedRequest = GetTargetDetectorRecipeDetectorRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTargetDetectorRecipeDetectorRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTargetDetectorRecipeDetectorRuleResponse> transformer = GetTargetDetectorRecipeDetectorRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTargetDetectorRecipeDetectorRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTargetDetectorRecipeDetectorRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTargetDetectorRecipeDetectorRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTargetResponderRecipeResponse getTargetResponderRecipe(GetTargetResponderRecipeRequest request) {
        LOG.trace("Called getTargetResponderRecipe");
        GetTargetResponderRecipeRequest interceptedRequest = GetTargetResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTargetResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTargetResponderRecipeResponse> transformer = GetTargetResponderRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTargetResponderRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTargetResponderRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTargetResponderRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTargetResponderRecipeResponderRuleResponse getTargetResponderRecipeResponderRule(GetTargetResponderRecipeResponderRuleRequest request) {
        LOG.trace("Called getTargetResponderRecipeResponderRule");
        GetTargetResponderRecipeResponderRuleRequest interceptedRequest = GetTargetResponderRecipeResponderRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTargetResponderRecipeResponderRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTargetResponderRecipeResponderRuleResponse> transformer = GetTargetResponderRecipeResponderRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTargetResponderRecipeResponderRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTargetResponderRecipeResponderRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTargetResponderRecipeResponderRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListConditionMetadataTypesResponse listConditionMetadataTypes(ListConditionMetadataTypesRequest request) {
        LOG.trace("Called listConditionMetadataTypes");
        ListConditionMetadataTypesRequest interceptedRequest = ListConditionMetadataTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConditionMetadataTypesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListConditionMetadataTypesResponse> transformer = ListConditionMetadataTypesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListConditionMetadataTypesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListConditionMetadataTypesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListConditionMetadataTypesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDetectorRecipeDetectorRulesResponse listDetectorRecipeDetectorRules(ListDetectorRecipeDetectorRulesRequest request) {
        LOG.trace("Called listDetectorRecipeDetectorRules");
        ListDetectorRecipeDetectorRulesRequest interceptedRequest = ListDetectorRecipeDetectorRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDetectorRecipeDetectorRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDetectorRecipeDetectorRulesResponse> transformer = ListDetectorRecipeDetectorRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDetectorRecipeDetectorRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDetectorRecipeDetectorRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDetectorRecipeDetectorRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDetectorRecipesResponse listDetectorRecipes(ListDetectorRecipesRequest request) {
        LOG.trace("Called listDetectorRecipes");
        ListDetectorRecipesRequest interceptedRequest = ListDetectorRecipesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDetectorRecipesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDetectorRecipesResponse> transformer = ListDetectorRecipesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDetectorRecipesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDetectorRecipesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDetectorRecipesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDetectorRulesResponse listDetectorRules(ListDetectorRulesRequest request) {
        LOG.trace("Called listDetectorRules");
        ListDetectorRulesRequest interceptedRequest = ListDetectorRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDetectorRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDetectorRulesResponse> transformer = ListDetectorRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDetectorRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDetectorRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDetectorRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDetectorsResponse listDetectors(ListDetectorsRequest request) {
        LOG.trace("Called listDetectors");
        ListDetectorsRequest interceptedRequest = ListDetectorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDetectorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDetectorsResponse> transformer = ListDetectorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDetectorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDetectorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDetectorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListImpactedResourcesResponse listImpactedResources(ListImpactedResourcesRequest request) {
        LOG.trace("Called listImpactedResources");
        ListImpactedResourcesRequest interceptedRequest = ListImpactedResourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListImpactedResourcesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListImpactedResourcesResponse> transformer = ListImpactedResourcesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListImpactedResourcesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListImpactedResourcesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListImpactedResourcesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListManagedListTypesResponse listManagedListTypes(ListManagedListTypesRequest request) {
        LOG.trace("Called listManagedListTypes");
        ListManagedListTypesRequest interceptedRequest = ListManagedListTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedListTypesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagedListTypesResponse> transformer = ListManagedListTypesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListManagedListTypesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListManagedListTypesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListManagedListTypesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListManagedListsResponse listManagedLists(ListManagedListsRequest request) {
        LOG.trace("Called listManagedLists");
        ListManagedListsRequest interceptedRequest = ListManagedListsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedListsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagedListsResponse> transformer = ListManagedListsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListManagedListsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListManagedListsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListManagedListsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListProblemHistoriesResponse listProblemHistories(ListProblemHistoriesRequest request) {
        LOG.trace("Called listProblemHistories");
        ListProblemHistoriesRequest interceptedRequest = ListProblemHistoriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProblemHistoriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListProblemHistoriesResponse> transformer = ListProblemHistoriesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListProblemHistoriesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListProblemHistoriesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListProblemHistoriesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListProblemsResponse listProblems(ListProblemsRequest request) {
        LOG.trace("Called listProblems");
        ListProblemsRequest interceptedRequest = ListProblemsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProblemsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListProblemsResponse> transformer = ListProblemsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListProblemsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListProblemsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListProblemsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRecommendationsResponse listRecommendations(ListRecommendationsRequest request) {
        LOG.trace("Called listRecommendations");
        ListRecommendationsRequest interceptedRequest = ListRecommendationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRecommendationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRecommendationsResponse> transformer = ListRecommendationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListRecommendationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRecommendationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRecommendationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListResourceTypesResponse listResourceTypes(ListResourceTypesRequest request) {
        LOG.trace("Called listResourceTypes");
        ListResourceTypesRequest interceptedRequest = ListResourceTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResourceTypesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListResourceTypesResponse> transformer = ListResourceTypesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListResourceTypesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListResourceTypesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListResourceTypesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListResponderActivitiesResponse listResponderActivities(ListResponderActivitiesRequest request) {
        LOG.trace("Called listResponderActivities");
        ListResponderActivitiesRequest interceptedRequest = ListResponderActivitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResponderActivitiesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListResponderActivitiesResponse> transformer = ListResponderActivitiesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListResponderActivitiesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListResponderActivitiesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListResponderActivitiesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListResponderExecutionsResponse listResponderExecutions(ListResponderExecutionsRequest request) {
        LOG.trace("Called listResponderExecutions");
        ListResponderExecutionsRequest interceptedRequest = ListResponderExecutionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResponderExecutionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListResponderExecutionsResponse> transformer = ListResponderExecutionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListResponderExecutionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListResponderExecutionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListResponderExecutionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListResponderRecipeResponderRulesResponse listResponderRecipeResponderRules(ListResponderRecipeResponderRulesRequest request) {
        LOG.trace("Called listResponderRecipeResponderRules");
        ListResponderRecipeResponderRulesRequest interceptedRequest = ListResponderRecipeResponderRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResponderRecipeResponderRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListResponderRecipeResponderRulesResponse> transformer = ListResponderRecipeResponderRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListResponderRecipeResponderRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListResponderRecipeResponderRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListResponderRecipeResponderRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListResponderRecipesResponse listResponderRecipes(ListResponderRecipesRequest request) {
        LOG.trace("Called listResponderRecipes");
        ListResponderRecipesRequest interceptedRequest = ListResponderRecipesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResponderRecipesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListResponderRecipesResponse> transformer = ListResponderRecipesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListResponderRecipesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListResponderRecipesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListResponderRecipesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListResponderRulesResponse listResponderRules(ListResponderRulesRequest request) {
        LOG.trace("Called listResponderRules");
        ListResponderRulesRequest interceptedRequest = ListResponderRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResponderRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListResponderRulesResponse> transformer = ListResponderRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListResponderRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListResponderRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListResponderRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTargetDetectorRecipeDetectorRulesResponse listTargetDetectorRecipeDetectorRules(ListTargetDetectorRecipeDetectorRulesRequest request) {
        LOG.trace("Called listTargetDetectorRecipeDetectorRules");
        ListTargetDetectorRecipeDetectorRulesRequest interceptedRequest = ListTargetDetectorRecipeDetectorRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTargetDetectorRecipeDetectorRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTargetDetectorRecipeDetectorRulesResponse> transformer = ListTargetDetectorRecipeDetectorRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTargetDetectorRecipeDetectorRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTargetDetectorRecipeDetectorRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTargetDetectorRecipeDetectorRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTargetDetectorRecipesResponse listTargetDetectorRecipes(ListTargetDetectorRecipesRequest request) {
        LOG.trace("Called listTargetDetectorRecipes");
        ListTargetDetectorRecipesRequest interceptedRequest = ListTargetDetectorRecipesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTargetDetectorRecipesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTargetDetectorRecipesResponse> transformer = ListTargetDetectorRecipesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTargetDetectorRecipesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTargetDetectorRecipesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTargetDetectorRecipesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTargetResponderRecipeResponderRulesResponse listTargetResponderRecipeResponderRules(ListTargetResponderRecipeResponderRulesRequest request) {
        LOG.trace("Called listTargetResponderRecipeResponderRules");
        ListTargetResponderRecipeResponderRulesRequest interceptedRequest = ListTargetResponderRecipeResponderRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTargetResponderRecipeResponderRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTargetResponderRecipeResponderRulesResponse> transformer = ListTargetResponderRecipeResponderRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTargetResponderRecipeResponderRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTargetResponderRecipeResponderRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTargetResponderRecipeResponderRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTargetResponderRecipesResponse listTargetResponderRecipes(ListTargetResponderRecipesRequest request) {
        LOG.trace("Called listTargetResponderRecipes");
        ListTargetResponderRecipesRequest interceptedRequest = ListTargetResponderRecipesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTargetResponderRecipesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTargetResponderRecipesResponse> transformer = ListTargetResponderRecipesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTargetResponderRecipesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTargetResponderRecipesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTargetResponderRecipesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTargetsResponse listTargets(ListTargetsRequest request) {
        LOG.trace("Called listTargets");
        ListTargetsRequest interceptedRequest = ListTargetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTargetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTargetsResponse> transformer = ListTargetsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTargetsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTargetsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTargetsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RequestRiskScoresResponse requestRiskScores(RequestRiskScoresRequest request) {
        LOG.trace("Called requestRiskScores");
        RequestRiskScoresRequest interceptedRequest = RequestRiskScoresConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestRiskScoresConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RequestRiskScoresResponse> transformer = RequestRiskScoresConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RequestRiskScoresResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RequestRiskScoresResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RequestRiskScoresResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RequestSecurityScoreSummarizedTrendResponse requestSecurityScoreSummarizedTrend(RequestSecurityScoreSummarizedTrendRequest request) {
        LOG.trace("Called requestSecurityScoreSummarizedTrend");
        RequestSecurityScoreSummarizedTrendRequest interceptedRequest = RequestSecurityScoreSummarizedTrendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSecurityScoreSummarizedTrendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RequestSecurityScoreSummarizedTrendResponse> transformer = RequestSecurityScoreSummarizedTrendConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RequestSecurityScoreSummarizedTrendResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RequestSecurityScoreSummarizedTrendResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RequestSecurityScoreSummarizedTrendResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RequestSecurityScoresResponse requestSecurityScores(RequestSecurityScoresRequest request) {
        LOG.trace("Called requestSecurityScores");
        RequestSecurityScoresRequest interceptedRequest = RequestSecurityScoresConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSecurityScoresConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RequestSecurityScoresResponse> transformer = RequestSecurityScoresConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RequestSecurityScoresResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RequestSecurityScoresResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RequestSecurityScoresResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RequestSummarizedActivityProblemsResponse requestSummarizedActivityProblems(RequestSummarizedActivityProblemsRequest request) {
        LOG.trace("Called requestSummarizedActivityProblems");
        RequestSummarizedActivityProblemsRequest interceptedRequest = RequestSummarizedActivityProblemsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedActivityProblemsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RequestSummarizedActivityProblemsResponse> transformer = RequestSummarizedActivityProblemsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RequestSummarizedActivityProblemsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RequestSummarizedActivityProblemsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RequestSummarizedActivityProblemsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RequestSummarizedProblemsResponse requestSummarizedProblems(RequestSummarizedProblemsRequest request) {
        LOG.trace("Called requestSummarizedProblems");
        RequestSummarizedProblemsRequest interceptedRequest = RequestSummarizedProblemsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedProblemsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RequestSummarizedProblemsResponse> transformer = RequestSummarizedProblemsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RequestSummarizedProblemsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RequestSummarizedProblemsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RequestSummarizedProblemsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RequestSummarizedResponderExecutionsResponse requestSummarizedResponderExecutions(RequestSummarizedResponderExecutionsRequest request) {
        LOG.trace("Called requestSummarizedResponderExecutions");
        RequestSummarizedResponderExecutionsRequest interceptedRequest = RequestSummarizedResponderExecutionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedResponderExecutionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RequestSummarizedResponderExecutionsResponse> transformer = RequestSummarizedResponderExecutionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RequestSummarizedResponderExecutionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RequestSummarizedResponderExecutionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RequestSummarizedResponderExecutionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RequestSummarizedRiskScoresResponse requestSummarizedRiskScores(RequestSummarizedRiskScoresRequest request) {
        LOG.trace("Called requestSummarizedRiskScores");
        RequestSummarizedRiskScoresRequest interceptedRequest = RequestSummarizedRiskScoresConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedRiskScoresConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RequestSummarizedRiskScoresResponse> transformer = RequestSummarizedRiskScoresConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RequestSummarizedRiskScoresResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RequestSummarizedRiskScoresResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RequestSummarizedRiskScoresResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RequestSummarizedSecurityScoresResponse requestSummarizedSecurityScores(RequestSummarizedSecurityScoresRequest request) {
        LOG.trace("Called requestSummarizedSecurityScores");
        RequestSummarizedSecurityScoresRequest interceptedRequest = RequestSummarizedSecurityScoresConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedSecurityScoresConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RequestSummarizedSecurityScoresResponse> transformer = RequestSummarizedSecurityScoresConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RequestSummarizedSecurityScoresResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RequestSummarizedSecurityScoresResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RequestSummarizedSecurityScoresResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RequestSummarizedTrendProblemsResponse requestSummarizedTrendProblems(RequestSummarizedTrendProblemsRequest request) {
        LOG.trace("Called requestSummarizedTrendProblems");
        RequestSummarizedTrendProblemsRequest interceptedRequest = RequestSummarizedTrendProblemsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedTrendProblemsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RequestSummarizedTrendProblemsResponse> transformer = RequestSummarizedTrendProblemsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RequestSummarizedTrendProblemsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RequestSummarizedTrendProblemsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RequestSummarizedTrendProblemsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RequestSummarizedTrendResponderExecutionsResponse requestSummarizedTrendResponderExecutions(RequestSummarizedTrendResponderExecutionsRequest request) {
        LOG.trace("Called requestSummarizedTrendResponderExecutions");
        RequestSummarizedTrendResponderExecutionsRequest interceptedRequest = RequestSummarizedTrendResponderExecutionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedTrendResponderExecutionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RequestSummarizedTrendResponderExecutionsResponse> transformer = RequestSummarizedTrendResponderExecutionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RequestSummarizedTrendResponderExecutionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RequestSummarizedTrendResponderExecutionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RequestSummarizedTrendResponderExecutionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RequestSummarizedTrendSecurityScoresResponse requestSummarizedTrendSecurityScores(RequestSummarizedTrendSecurityScoresRequest request) {
        LOG.trace("Called requestSummarizedTrendSecurityScores");
        RequestSummarizedTrendSecurityScoresRequest interceptedRequest = RequestSummarizedTrendSecurityScoresConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedTrendSecurityScoresConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RequestSummarizedTrendSecurityScoresResponse> transformer = RequestSummarizedTrendSecurityScoresConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RequestSummarizedTrendSecurityScoresResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RequestSummarizedTrendSecurityScoresResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RequestSummarizedTrendSecurityScoresResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SkipBulkResponderExecutionResponse skipBulkResponderExecution(SkipBulkResponderExecutionRequest request) {
        LOG.trace("Called skipBulkResponderExecution");
        SkipBulkResponderExecutionRequest interceptedRequest = SkipBulkResponderExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SkipBulkResponderExecutionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SkipBulkResponderExecutionResponse> transformer = SkipBulkResponderExecutionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (SkipBulkResponderExecutionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SkipBulkResponderExecutionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getSkipBulkResponderExecutionDetails(), (BmcRequest)retriedRequest);
                return (SkipBulkResponderExecutionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SkipResponderExecutionResponse skipResponderExecution(SkipResponderExecutionRequest request) {
        LOG.trace("Called skipResponderExecution");
        SkipResponderExecutionRequest interceptedRequest = SkipResponderExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SkipResponderExecutionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SkipResponderExecutionResponse> transformer = SkipResponderExecutionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (SkipResponderExecutionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SkipResponderExecutionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (SkipResponderExecutionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public TriggerResponderResponse triggerResponder(TriggerResponderRequest request) {
        LOG.trace("Called triggerResponder");
        TriggerResponderRequest interceptedRequest = TriggerResponderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = TriggerResponderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, TriggerResponderResponse> transformer = TriggerResponderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (TriggerResponderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (TriggerResponderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getTriggerResponderDetails(), (BmcRequest)retriedRequest);
                return (TriggerResponderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateBulkProblemStatusResponse updateBulkProblemStatus(UpdateBulkProblemStatusRequest request) {
        LOG.trace("Called updateBulkProblemStatus");
        UpdateBulkProblemStatusRequest interceptedRequest = UpdateBulkProblemStatusConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBulkProblemStatusConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBulkProblemStatusResponse> transformer = UpdateBulkProblemStatusConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateBulkProblemStatusResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateBulkProblemStatusResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getUpdateBulkProblemStatusDetails(), (BmcRequest)retriedRequest);
                return (UpdateBulkProblemStatusResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateConfigurationResponse updateConfiguration(UpdateConfigurationRequest request) {
        LOG.trace("Called updateConfiguration");
        UpdateConfigurationRequest interceptedRequest = UpdateConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateConfigurationResponse> transformer = UpdateConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateConfigurationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateConfigurationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateConfigurationDetails(), (BmcRequest)retriedRequest);
                return (UpdateConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDetectorRecipeResponse updateDetectorRecipe(UpdateDetectorRecipeRequest request) {
        LOG.trace("Called updateDetectorRecipe");
        UpdateDetectorRecipeRequest interceptedRequest = UpdateDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDetectorRecipeResponse> transformer = UpdateDetectorRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateDetectorRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDetectorRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDetectorRecipeDetails(), (BmcRequest)retriedRequest);
                return (UpdateDetectorRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDetectorRecipeDetectorRuleResponse updateDetectorRecipeDetectorRule(UpdateDetectorRecipeDetectorRuleRequest request) {
        LOG.trace("Called updateDetectorRecipeDetectorRule");
        UpdateDetectorRecipeDetectorRuleRequest interceptedRequest = UpdateDetectorRecipeDetectorRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDetectorRecipeDetectorRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDetectorRecipeDetectorRuleResponse> transformer = UpdateDetectorRecipeDetectorRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateDetectorRecipeDetectorRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDetectorRecipeDetectorRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDetectorRecipeDetectorRuleDetails(), (BmcRequest)retriedRequest);
                return (UpdateDetectorRecipeDetectorRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateManagedListResponse updateManagedList(UpdateManagedListRequest request) {
        LOG.trace("Called updateManagedList");
        UpdateManagedListRequest interceptedRequest = UpdateManagedListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagedListConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateManagedListResponse> transformer = UpdateManagedListConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateManagedListResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateManagedListResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateManagedListDetails(), (BmcRequest)retriedRequest);
                return (UpdateManagedListResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateProblemStatusResponse updateProblemStatus(UpdateProblemStatusRequest request) {
        LOG.trace("Called updateProblemStatus");
        UpdateProblemStatusRequest interceptedRequest = UpdateProblemStatusConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProblemStatusConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateProblemStatusResponse> transformer = UpdateProblemStatusConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateProblemStatusResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateProblemStatusResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getUpdateProblemStatusDetails(), (BmcRequest)retriedRequest);
                return (UpdateProblemStatusResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateResponderRecipeResponse updateResponderRecipe(UpdateResponderRecipeRequest request) {
        LOG.trace("Called updateResponderRecipe");
        UpdateResponderRecipeRequest interceptedRequest = UpdateResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateResponderRecipeResponse> transformer = UpdateResponderRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateResponderRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateResponderRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateResponderRecipeDetails(), (BmcRequest)retriedRequest);
                return (UpdateResponderRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateResponderRecipeResponderRuleResponse updateResponderRecipeResponderRule(UpdateResponderRecipeResponderRuleRequest request) {
        LOG.trace("Called updateResponderRecipeResponderRule");
        UpdateResponderRecipeResponderRuleRequest interceptedRequest = UpdateResponderRecipeResponderRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateResponderRecipeResponderRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateResponderRecipeResponderRuleResponse> transformer = UpdateResponderRecipeResponderRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateResponderRecipeResponderRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateResponderRecipeResponderRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateResponderRecipeResponderRuleDetails(), (BmcRequest)retriedRequest);
                return (UpdateResponderRecipeResponderRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTargetResponse updateTarget(UpdateTargetRequest request) {
        LOG.trace("Called updateTarget");
        UpdateTargetRequest interceptedRequest = UpdateTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTargetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTargetResponse> transformer = UpdateTargetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTargetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTargetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTargetDetails(), (BmcRequest)retriedRequest);
                return (UpdateTargetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTargetDetectorRecipeResponse updateTargetDetectorRecipe(UpdateTargetDetectorRecipeRequest request) {
        LOG.trace("Called updateTargetDetectorRecipe");
        UpdateTargetDetectorRecipeRequest interceptedRequest = UpdateTargetDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTargetDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTargetDetectorRecipeResponse> transformer = UpdateTargetDetectorRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTargetDetectorRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTargetDetectorRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTargetDetectorRecipeDetails(), (BmcRequest)retriedRequest);
                return (UpdateTargetDetectorRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTargetDetectorRecipeDetectorRuleResponse updateTargetDetectorRecipeDetectorRule(UpdateTargetDetectorRecipeDetectorRuleRequest request) {
        LOG.trace("Called updateTargetDetectorRecipeDetectorRule");
        UpdateTargetDetectorRecipeDetectorRuleRequest interceptedRequest = UpdateTargetDetectorRecipeDetectorRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTargetDetectorRecipeDetectorRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTargetDetectorRecipeDetectorRuleResponse> transformer = UpdateTargetDetectorRecipeDetectorRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTargetDetectorRecipeDetectorRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTargetDetectorRecipeDetectorRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTargetDetectorRecipeDetectorRuleDetails(), (BmcRequest)retriedRequest);
                return (UpdateTargetDetectorRecipeDetectorRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTargetResponderRecipeResponse updateTargetResponderRecipe(UpdateTargetResponderRecipeRequest request) {
        LOG.trace("Called updateTargetResponderRecipe");
        UpdateTargetResponderRecipeRequest interceptedRequest = UpdateTargetResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTargetResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTargetResponderRecipeResponse> transformer = UpdateTargetResponderRecipeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTargetResponderRecipeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTargetResponderRecipeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTargetResponderRecipeDetails(), (BmcRequest)retriedRequest);
                return (UpdateTargetResponderRecipeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTargetResponderRecipeResponderRuleResponse updateTargetResponderRecipeResponderRule(UpdateTargetResponderRecipeResponderRuleRequest request) {
        LOG.trace("Called updateTargetResponderRecipeResponderRule");
        UpdateTargetResponderRecipeResponderRuleRequest interceptedRequest = UpdateTargetResponderRecipeResponderRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTargetResponderRecipeResponderRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTargetResponderRecipeResponderRuleResponse> transformer = UpdateTargetResponderRecipeResponderRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTargetResponderRecipeResponderRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTargetResponderRecipeResponderRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTargetResponderRecipeResponderRuleDetails(), (BmcRequest)retriedRequest);
                return (UpdateTargetResponderRecipeResponderRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CloudGuardWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public CloudGuardPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, CloudGuardClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public CloudGuardClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new CloudGuardClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

