/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.cloudguard.model.ResponderExecutionCollection;
import com.oracle.bmc.cloudguard.requests.ListResponderExecutionsRequest;
import com.oracle.bmc.cloudguard.responses.ListResponderExecutionsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListResponderExecutionsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListResponderExecutionsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListResponderExecutionsRequest interceptRequest(ListResponderExecutionsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListResponderExecutionsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200131").path("responderExecutions");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getCompartmentIdInSubtree() != null) {
            target = target.queryParam("compartmentIdInSubtree", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentIdInSubtree())});
        }
        if (request.getAccessLevel() != null) {
            target = target.queryParam("accessLevel", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getAccessLevel().getValue())});
        }
        if (request.getResponderRuleIds() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"responderRuleIds", request.getResponderRuleIds(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getTimeCreatedGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timeCreatedGreaterThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeCreatedGreaterThanOrEqualTo())});
        }
        if (request.getTimeCreatedLessThanOrEqualTo() != null) {
            target = target.queryParam("timeCreatedLessThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeCreatedLessThanOrEqualTo())});
        }
        if (request.getTimeCompletedGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timeCompletedGreaterThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeCompletedGreaterThanOrEqualTo())});
        }
        if (request.getTimeCompletedLessThanOrEqualTo() != null) {
            target = target.queryParam("timeCompletedLessThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeCompletedLessThanOrEqualTo())});
        }
        if (request.getTargetId() != null) {
            target = target.queryParam("targetId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTargetId())});
        }
        if (request.getResourceType() != null) {
            target = target.queryParam("resourceType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getResourceType())});
        }
        if (request.getResponderType() != null) {
            target = target.queryParam("responderType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getResponderType().getValue())});
        }
        if (request.getResponderExecutionStatus() != null) {
            target = target.queryParam("responderExecutionStatus", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getResponderExecutionStatus().getValue())});
        }
        if (request.getResponderExecutionMode() != null) {
            target = target.queryParam("responderExecutionMode", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getResponderExecutionMode().getValue())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListResponderExecutionsResponse> fromResponse() {
        Function<Response, ListResponderExecutionsResponse> transformer = new Function<Response, ListResponderExecutionsResponse>(){

            public ListResponderExecutionsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.cloudguard.responses.ListResponderExecutionsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ResponderExecutionCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListResponderExecutionsResponse.Builder builder = ListResponderExecutionsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.responderExecutionCollection((ResponderExecutionCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListResponderExecutionsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

