/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.cloudguard.model.ProblemTrendAggregationCollection;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedTrendProblemsRequest;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedTrendProblemsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSummarizedTrendProblemsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestSummarizedTrendProblemsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static RequestSummarizedTrendProblemsRequest interceptRequest(RequestSummarizedTrendProblemsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, RequestSummarizedTrendProblemsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200131").path("problems").path("actions").path("summarizeTrend");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getTimeFirstDetectedGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timeFirstDetectedGreaterThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeFirstDetectedGreaterThanOrEqualTo())});
        }
        if (request.getTimeFirstDetectedLessThanOrEqualTo() != null) {
            target = target.queryParam("timeFirstDetectedLessThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeFirstDetectedLessThanOrEqualTo())});
        }
        if (request.getCompartmentIdInSubtree() != null) {
            target = target.queryParam("compartmentIdInSubtree", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentIdInSubtree())});
        }
        if (request.getAccessLevel() != null) {
            target = target.queryParam("accessLevel", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getAccessLevel().getValue())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, RequestSummarizedTrendProblemsResponse> fromResponse() {
        Function<Response, RequestSummarizedTrendProblemsResponse> transformer = new Function<Response, RequestSummarizedTrendProblemsResponse>(){

            public RequestSummarizedTrendProblemsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.cloudguard.responses.RequestSummarizedTrendProblemsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ProblemTrendAggregationCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                RequestSummarizedTrendProblemsResponse.Builder builder = RequestSummarizedTrendProblemsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.problemTrendAggregationCollection((ProblemTrendAggregationCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                RequestSummarizedTrendProblemsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

