/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.cloudguard.requests.TriggerResponderRequest;
import com.oracle.bmc.cloudguard.responses.TriggerResponderResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerResponderConverter {
    private static final Logger LOG = LoggerFactory.getLogger(TriggerResponderConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static TriggerResponderRequest interceptRequest(TriggerResponderRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, TriggerResponderRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getProblemId(), (String)"problemId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getTriggerResponderDetails(), (String)"triggerResponderDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200131").path("problems").path(HttpUtils.encodePathSegment((String)request.getProblemId())).path("actions").path("triggerResponder");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, TriggerResponderResponse> fromResponse() {
        Function<Response, TriggerResponderResponse> transformer = new Function<Response, TriggerResponderResponse>(){

            public TriggerResponderResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.cloudguard.responses.TriggerResponderResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                TriggerResponderResponse.Builder builder = TriggerResponderResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                TriggerResponderResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

