/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.cloudguard.model.DetectorRecipeDetectorRule;
import com.oracle.bmc.cloudguard.requests.UpdateDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.responses.UpdateDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDetectorRecipeDetectorRuleConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateDetectorRecipeDetectorRuleConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateDetectorRecipeDetectorRuleRequest interceptRequest(UpdateDetectorRecipeDetectorRuleRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateDetectorRecipeDetectorRuleRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDetectorRecipeId(), (String)"detectorRecipeId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDetectorRuleId(), (String)"detectorRuleId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateDetectorRecipeDetectorRuleDetails(), (String)"updateDetectorRecipeDetectorRuleDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200131").path("detectorRecipes").path(HttpUtils.encodePathSegment((String)request.getDetectorRecipeId())).path("detectorRules").path(HttpUtils.encodePathSegment((String)request.getDetectorRuleId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, UpdateDetectorRecipeDetectorRuleResponse> fromResponse() {
        Function<Response, UpdateDetectorRecipeDetectorRuleResponse> transformer = new Function<Response, UpdateDetectorRecipeDetectorRuleResponse>(){

            public UpdateDetectorRecipeDetectorRuleResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.cloudguard.responses.UpdateDetectorRecipeDetectorRuleResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(DetectorRecipeDetectorRule.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UpdateDetectorRecipeDetectorRuleResponse.Builder builder = UpdateDetectorRecipeDetectorRuleResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.detectorRecipeDetectorRule((DetectorRecipeDetectorRule)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                UpdateDetectorRecipeDetectorRuleResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

