/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetResponderExecutionRequest
extends BmcRequest<Void> {
    private String responderExecutionId;
    private String opcRequestId;

    @ConstructorProperties(value={"responderExecutionId", "opcRequestId"})
    GetResponderExecutionRequest(String responderExecutionId, String opcRequestId) {
        this.responderExecutionId = responderExecutionId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getResponderExecutionId() {
        return this.responderExecutionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetResponderExecutionRequest, Void> {
        private String responderExecutionId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetResponderExecutionRequest o) {
            this.responderExecutionId(o.getResponderExecutionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetResponderExecutionRequest build() {
            GetResponderExecutionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder responderExecutionId(String responderExecutionId) {
            this.responderExecutionId = responderExecutionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetResponderExecutionRequest buildWithoutInvocationCallback() {
            return new GetResponderExecutionRequest(this.responderExecutionId, this.opcRequestId);
        }

        public String toString() {
            return "GetResponderExecutionRequest.Builder(responderExecutionId=" + this.responderExecutionId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

