/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.cloudguard.model.ResponderDimension;
import com.oracle.bmc.cloudguard.model.ResponderExecutionStatus;
import com.oracle.bmc.cloudguard.model.ResponderType;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class RequestSummarizedResponderExecutionsRequest
extends BmcRequest<Void> {
    private List<ResponderDimension> responderExecutionsDimensions;
    private String compartmentId;
    private List<ResponderType> responderTypeFilter;
    private List<ResponderExecutionStatus> responderExecutionStatusFilter;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"responderExecutionsDimensions", "compartmentId", "responderTypeFilter", "responderExecutionStatusFilter", "compartmentIdInSubtree", "accessLevel", "limit", "page", "opcRequestId"})
    RequestSummarizedResponderExecutionsRequest(List<ResponderDimension> responderExecutionsDimensions, String compartmentId, List<ResponderType> responderTypeFilter, List<ResponderExecutionStatus> responderExecutionStatusFilter, Boolean compartmentIdInSubtree, AccessLevel accessLevel, Integer limit, String page, String opcRequestId) {
        this.responderExecutionsDimensions = responderExecutionsDimensions;
        this.compartmentId = compartmentId;
        this.responderTypeFilter = responderTypeFilter;
        this.responderExecutionStatusFilter = responderExecutionStatusFilter;
        this.compartmentIdInSubtree = compartmentIdInSubtree;
        this.accessLevel = accessLevel;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<ResponderDimension> getResponderExecutionsDimensions() {
        return this.responderExecutionsDimensions;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<ResponderType> getResponderTypeFilter() {
        return this.responderTypeFilter;
    }

    public List<ResponderExecutionStatus> getResponderExecutionStatusFilter() {
        return this.responderExecutionStatusFilter;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestSummarizedResponderExecutionsRequest, Void> {
        private List<ResponderDimension> responderExecutionsDimensions;
        private String compartmentId;
        private List<ResponderType> responderTypeFilter;
        private List<ResponderExecutionStatus> responderExecutionStatusFilter;
        private Boolean compartmentIdInSubtree;
        private AccessLevel accessLevel;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestSummarizedResponderExecutionsRequest o) {
            this.responderExecutionsDimensions(o.getResponderExecutionsDimensions());
            this.compartmentId(o.getCompartmentId());
            this.responderTypeFilter(o.getResponderTypeFilter());
            this.responderExecutionStatusFilter(o.getResponderExecutionStatusFilter());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestSummarizedResponderExecutionsRequest build() {
            RequestSummarizedResponderExecutionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder responderExecutionsDimensions(List<ResponderDimension> responderExecutionsDimensions) {
            this.responderExecutionsDimensions = responderExecutionsDimensions;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder responderTypeFilter(List<ResponderType> responderTypeFilter) {
            this.responderTypeFilter = responderTypeFilter;
            return this;
        }

        public Builder responderExecutionStatusFilter(List<ResponderExecutionStatus> responderExecutionStatusFilter) {
            this.responderExecutionStatusFilter = responderExecutionStatusFilter;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public RequestSummarizedResponderExecutionsRequest buildWithoutInvocationCallback() {
            return new RequestSummarizedResponderExecutionsRequest(this.responderExecutionsDimensions, this.compartmentId, this.responderTypeFilter, this.responderExecutionStatusFilter, this.compartmentIdInSubtree, this.accessLevel, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "RequestSummarizedResponderExecutionsRequest.Builder(responderExecutionsDimensions=" + this.responderExecutionsDimensions + ", compartmentId=" + this.compartmentId + ", responderTypeFilter=" + this.responderTypeFilter + ", responderExecutionStatusFilter=" + this.responderExecutionStatusFilter + ", compartmentIdInSubtree=" + this.compartmentIdInSubtree + ", accessLevel=" + (Object)((Object)this.accessLevel) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum AccessLevel {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

