/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class RequestSummarizedTrendResponderExecutionsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Date timeCompletedGreaterThanOrEqualTo;
    private Date timeCompletedLessThanOrEqualTo;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "timeCompletedGreaterThanOrEqualTo", "timeCompletedLessThanOrEqualTo", "compartmentIdInSubtree", "accessLevel", "limit", "page", "opcRequestId"})
    RequestSummarizedTrendResponderExecutionsRequest(String compartmentId, Date timeCompletedGreaterThanOrEqualTo, Date timeCompletedLessThanOrEqualTo, Boolean compartmentIdInSubtree, AccessLevel accessLevel, Integer limit, String page, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.timeCompletedGreaterThanOrEqualTo = timeCompletedGreaterThanOrEqualTo;
        this.timeCompletedLessThanOrEqualTo = timeCompletedLessThanOrEqualTo;
        this.compartmentIdInSubtree = compartmentIdInSubtree;
        this.accessLevel = accessLevel;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeCompletedGreaterThanOrEqualTo() {
        return this.timeCompletedGreaterThanOrEqualTo;
    }

    public Date getTimeCompletedLessThanOrEqualTo() {
        return this.timeCompletedLessThanOrEqualTo;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestSummarizedTrendResponderExecutionsRequest, Void> {
        private String compartmentId;
        private Date timeCompletedGreaterThanOrEqualTo;
        private Date timeCompletedLessThanOrEqualTo;
        private Boolean compartmentIdInSubtree;
        private AccessLevel accessLevel;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestSummarizedTrendResponderExecutionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.timeCompletedGreaterThanOrEqualTo(o.getTimeCompletedGreaterThanOrEqualTo());
            this.timeCompletedLessThanOrEqualTo(o.getTimeCompletedLessThanOrEqualTo());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestSummarizedTrendResponderExecutionsRequest build() {
            RequestSummarizedTrendResponderExecutionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder timeCompletedGreaterThanOrEqualTo(Date timeCompletedGreaterThanOrEqualTo) {
            this.timeCompletedGreaterThanOrEqualTo = timeCompletedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeCompletedLessThanOrEqualTo(Date timeCompletedLessThanOrEqualTo) {
            this.timeCompletedLessThanOrEqualTo = timeCompletedLessThanOrEqualTo;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public RequestSummarizedTrendResponderExecutionsRequest buildWithoutInvocationCallback() {
            return new RequestSummarizedTrendResponderExecutionsRequest(this.compartmentId, this.timeCompletedGreaterThanOrEqualTo, this.timeCompletedLessThanOrEqualTo, this.compartmentIdInSubtree, this.accessLevel, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "RequestSummarizedTrendResponderExecutionsRequest.Builder(compartmentId=" + this.compartmentId + ", timeCompletedGreaterThanOrEqualTo=" + this.timeCompletedGreaterThanOrEqualTo + ", timeCompletedLessThanOrEqualTo=" + this.timeCompletedLessThanOrEqualTo + ", compartmentIdInSubtree=" + this.compartmentIdInSubtree + ", accessLevel=" + (Object)((Object)this.accessLevel) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum AccessLevel {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

