/**
 * Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.http;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;

/**
 * Configurator allowing SDK users to customize the underlying REST client.
 */
public interface ClientConfigurator {

    /**
     * Customize the ClientBuilder instance.
     *
     * @param builder
     *            The client builder.
     */
    void customizeBuilder(ClientBuilder builder);

    /**
     * Customize the Client generated by the builder.
     *
     * @param client
     *            The client.
     */
    void customizeClient(Client client);
}
