/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import com.oracle.bmc.http.ClientConfigurator;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import lombok.NonNull;
import org.glassfish.jersey.logging.LoggingFeature;

public class JerseyLoggingClientConfigurator
implements ClientConfigurator {
    @NonNull
    private LoggingFeature.Verbosity verbosity;
    @NonNull
    private String loggingLevel;

    @Override
    public void customizeBuilder(ClientBuilder builder) {
    }

    @Override
    public void customizeClient(Client client) {
        client.property("jersey.config.client.logging.verbosity", (Object)this.verbosity);
        client.property("jersey.config.client.logging.logger.level", (Object)this.loggingLevel);
    }

    @ConstructorProperties(value={"verbosity", "loggingLevel"})
    public JerseyLoggingClientConfigurator(@NonNull LoggingFeature.Verbosity verbosity, @NonNull String loggingLevel) {
        if (verbosity == null) {
            throw new NullPointerException("verbosity is marked non-null but is null");
        }
        if (loggingLevel == null) {
            throw new NullPointerException("loggingLevel is marked non-null but is null");
        }
        this.verbosity = verbosity;
        this.loggingLevel = loggingLevel;
    }
}

