/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.computeinstanceagent.ComputeInstanceAgent;
import com.oracle.bmc.computeinstanceagent.ComputeInstanceAgentPaginators;
import com.oracle.bmc.computeinstanceagent.ComputeInstanceAgentWaiters;
import com.oracle.bmc.computeinstanceagent.internal.http.CancelInstanceAgentCommandConverter;
import com.oracle.bmc.computeinstanceagent.internal.http.CreateInstanceAgentCommandConverter;
import com.oracle.bmc.computeinstanceagent.internal.http.GetInstanceAgentCommandConverter;
import com.oracle.bmc.computeinstanceagent.internal.http.GetInstanceAgentCommandExecutionConverter;
import com.oracle.bmc.computeinstanceagent.internal.http.ListInstanceAgentCommandExecutionsConverter;
import com.oracle.bmc.computeinstanceagent.internal.http.ListInstanceAgentCommandsConverter;
import com.oracle.bmc.computeinstanceagent.requests.CancelInstanceAgentCommandRequest;
import com.oracle.bmc.computeinstanceagent.requests.CreateInstanceAgentCommandRequest;
import com.oracle.bmc.computeinstanceagent.requests.GetInstanceAgentCommandExecutionRequest;
import com.oracle.bmc.computeinstanceagent.requests.GetInstanceAgentCommandRequest;
import com.oracle.bmc.computeinstanceagent.requests.ListInstanceAgentCommandExecutionsRequest;
import com.oracle.bmc.computeinstanceagent.requests.ListInstanceAgentCommandsRequest;
import com.oracle.bmc.computeinstanceagent.responses.CancelInstanceAgentCommandResponse;
import com.oracle.bmc.computeinstanceagent.responses.CreateInstanceAgentCommandResponse;
import com.oracle.bmc.computeinstanceagent.responses.GetInstanceAgentCommandExecutionResponse;
import com.oracle.bmc.computeinstanceagent.responses.GetInstanceAgentCommandResponse;
import com.oracle.bmc.computeinstanceagent.responses.ListInstanceAgentCommandExecutionsResponse;
import com.oracle.bmc.computeinstanceagent.responses.ListInstanceAgentCommandsResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeInstanceAgentClient
implements ComputeInstanceAgent {
    private static final Logger LOG = LoggerFactory.getLogger(ComputeInstanceAgentClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("COMPUTEINSTANCEAGENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final ComputeInstanceAgentWaiters waiters;
    private final ComputeInstanceAgentPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public ComputeInstanceAgentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ComputeInstanceAgentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ComputeInstanceAgentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ComputeInstanceAgentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ComputeInstanceAgentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ComputeInstanceAgentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ComputeInstanceAgentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public ComputeInstanceAgentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected ComputeInstanceAgentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ComputeInstanceAgent-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ComputeInstanceAgentWaiters(executorService, this);
        this.paginators = new ComputeInstanceAgentPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CancelInstanceAgentCommandResponse cancelInstanceAgentCommand(CancelInstanceAgentCommandRequest request) {
        LOG.trace("Called cancelInstanceAgentCommand");
        CancelInstanceAgentCommandRequest interceptedRequest = CancelInstanceAgentCommandConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelInstanceAgentCommandConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelInstanceAgentCommandResponse> transformer = CancelInstanceAgentCommandConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CancelInstanceAgentCommandResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CancelInstanceAgentCommandResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (CancelInstanceAgentCommandResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateInstanceAgentCommandResponse createInstanceAgentCommand(CreateInstanceAgentCommandRequest request) {
        LOG.trace("Called createInstanceAgentCommand");
        CreateInstanceAgentCommandRequest interceptedRequest = CreateInstanceAgentCommandConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateInstanceAgentCommandConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateInstanceAgentCommandResponse> transformer = CreateInstanceAgentCommandConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateInstanceAgentCommandResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateInstanceAgentCommandResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateInstanceAgentCommandDetails(), (BmcRequest)retriedRequest);
                return (CreateInstanceAgentCommandResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetInstanceAgentCommandResponse getInstanceAgentCommand(GetInstanceAgentCommandRequest request) {
        LOG.trace("Called getInstanceAgentCommand");
        GetInstanceAgentCommandRequest interceptedRequest = GetInstanceAgentCommandConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetInstanceAgentCommandConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetInstanceAgentCommandResponse> transformer = GetInstanceAgentCommandConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetInstanceAgentCommandResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetInstanceAgentCommandResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetInstanceAgentCommandResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetInstanceAgentCommandExecutionResponse getInstanceAgentCommandExecution(GetInstanceAgentCommandExecutionRequest request) {
        LOG.trace("Called getInstanceAgentCommandExecution");
        GetInstanceAgentCommandExecutionRequest interceptedRequest = GetInstanceAgentCommandExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetInstanceAgentCommandExecutionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetInstanceAgentCommandExecutionResponse> transformer = GetInstanceAgentCommandExecutionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetInstanceAgentCommandExecutionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetInstanceAgentCommandExecutionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetInstanceAgentCommandExecutionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListInstanceAgentCommandExecutionsResponse listInstanceAgentCommandExecutions(ListInstanceAgentCommandExecutionsRequest request) {
        LOG.trace("Called listInstanceAgentCommandExecutions");
        ListInstanceAgentCommandExecutionsRequest interceptedRequest = ListInstanceAgentCommandExecutionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListInstanceAgentCommandExecutionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListInstanceAgentCommandExecutionsResponse> transformer = ListInstanceAgentCommandExecutionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListInstanceAgentCommandExecutionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListInstanceAgentCommandExecutionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListInstanceAgentCommandExecutionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListInstanceAgentCommandsResponse listInstanceAgentCommands(ListInstanceAgentCommandsRequest request) {
        LOG.trace("Called listInstanceAgentCommands");
        ListInstanceAgentCommandsRequest interceptedRequest = ListInstanceAgentCommandsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListInstanceAgentCommandsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListInstanceAgentCommandsResponse> transformer = ListInstanceAgentCommandsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListInstanceAgentCommandsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListInstanceAgentCommandsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListInstanceAgentCommandsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ComputeInstanceAgentWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ComputeInstanceAgentPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ComputeInstanceAgentClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ComputeInstanceAgentClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ComputeInstanceAgentClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

