/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousDbVersionSummary {
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="dbWorkload")
    private final DbWorkload dbWorkload;
    @JsonProperty(value="isDedicated")
    private final Boolean isDedicated;
    @JsonProperty(value="details")
    private final String details;
    @JsonProperty(value="isFreeTierEnabled")
    private final Boolean isFreeTierEnabled;
    @JsonProperty(value="isPaidEnabled")
    private final Boolean isPaidEnabled;
    @JsonProperty(value="isDefaultForFree")
    private final Boolean isDefaultForFree;
    @JsonProperty(value="isDefaultForPaid")
    private final Boolean isDefaultForPaid;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().version(this.version).dbWorkload(this.dbWorkload).isDedicated(this.isDedicated).details(this.details).isFreeTierEnabled(this.isFreeTierEnabled).isPaidEnabled(this.isPaidEnabled).isDefaultForFree(this.isDefaultForFree).isDefaultForPaid(this.isDefaultForPaid);
    }

    public String getVersion() {
        return this.version;
    }

    public DbWorkload getDbWorkload() {
        return this.dbWorkload;
    }

    public Boolean getIsDedicated() {
        return this.isDedicated;
    }

    public String getDetails() {
        return this.details;
    }

    public Boolean getIsFreeTierEnabled() {
        return this.isFreeTierEnabled;
    }

    public Boolean getIsPaidEnabled() {
        return this.isPaidEnabled;
    }

    public Boolean getIsDefaultForFree() {
        return this.isDefaultForFree;
    }

    public Boolean getIsDefaultForPaid() {
        return this.isDefaultForPaid;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutonomousDbVersionSummary)) {
            return false;
        }
        AutonomousDbVersionSummary other = (AutonomousDbVersionSummary)o;
        Boolean this$isDedicated = this.getIsDedicated();
        Boolean other$isDedicated = other.getIsDedicated();
        if (this$isDedicated == null ? other$isDedicated != null : !((Object)this$isDedicated).equals(other$isDedicated)) {
            return false;
        }
        Boolean this$isFreeTierEnabled = this.getIsFreeTierEnabled();
        Boolean other$isFreeTierEnabled = other.getIsFreeTierEnabled();
        if (this$isFreeTierEnabled == null ? other$isFreeTierEnabled != null : !((Object)this$isFreeTierEnabled).equals(other$isFreeTierEnabled)) {
            return false;
        }
        Boolean this$isPaidEnabled = this.getIsPaidEnabled();
        Boolean other$isPaidEnabled = other.getIsPaidEnabled();
        if (this$isPaidEnabled == null ? other$isPaidEnabled != null : !((Object)this$isPaidEnabled).equals(other$isPaidEnabled)) {
            return false;
        }
        Boolean this$isDefaultForFree = this.getIsDefaultForFree();
        Boolean other$isDefaultForFree = other.getIsDefaultForFree();
        if (this$isDefaultForFree == null ? other$isDefaultForFree != null : !((Object)this$isDefaultForFree).equals(other$isDefaultForFree)) {
            return false;
        }
        Boolean this$isDefaultForPaid = this.getIsDefaultForPaid();
        Boolean other$isDefaultForPaid = other.getIsDefaultForPaid();
        if (this$isDefaultForPaid == null ? other$isDefaultForPaid != null : !((Object)this$isDefaultForPaid).equals(other$isDefaultForPaid)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        DbWorkload this$dbWorkload = this.getDbWorkload();
        DbWorkload other$dbWorkload = other.getDbWorkload();
        if (this$dbWorkload == null ? other$dbWorkload != null : !((Object)((Object)this$dbWorkload)).equals((Object)other$dbWorkload)) {
            return false;
        }
        String this$details = this.getDetails();
        String other$details = other.getDetails();
        if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isDedicated = this.getIsDedicated();
        result = result * 59 + ($isDedicated == null ? 43 : ((Object)$isDedicated).hashCode());
        Boolean $isFreeTierEnabled = this.getIsFreeTierEnabled();
        result = result * 59 + ($isFreeTierEnabled == null ? 43 : ((Object)$isFreeTierEnabled).hashCode());
        Boolean $isPaidEnabled = this.getIsPaidEnabled();
        result = result * 59 + ($isPaidEnabled == null ? 43 : ((Object)$isPaidEnabled).hashCode());
        Boolean $isDefaultForFree = this.getIsDefaultForFree();
        result = result * 59 + ($isDefaultForFree == null ? 43 : ((Object)$isDefaultForFree).hashCode());
        Boolean $isDefaultForPaid = this.getIsDefaultForPaid();
        result = result * 59 + ($isDefaultForPaid == null ? 43 : ((Object)$isDefaultForPaid).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        DbWorkload $dbWorkload = this.getDbWorkload();
        result = result * 59 + ($dbWorkload == null ? 43 : ((Object)((Object)$dbWorkload)).hashCode());
        String $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "AutonomousDbVersionSummary(version=" + this.getVersion() + ", dbWorkload=" + (Object)((Object)this.getDbWorkload()) + ", isDedicated=" + this.getIsDedicated() + ", details=" + this.getDetails() + ", isFreeTierEnabled=" + this.getIsFreeTierEnabled() + ", isPaidEnabled=" + this.getIsPaidEnabled() + ", isDefaultForFree=" + this.getIsDefaultForFree() + ", isDefaultForPaid=" + this.getIsDefaultForPaid() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"version", "dbWorkload", "isDedicated", "details", "isFreeTierEnabled", "isPaidEnabled", "isDefaultForFree", "isDefaultForPaid"})
    @Deprecated
    public AutonomousDbVersionSummary(String version, DbWorkload dbWorkload, Boolean isDedicated, String details, Boolean isFreeTierEnabled, Boolean isPaidEnabled, Boolean isDefaultForFree, Boolean isDefaultForPaid) {
        this.version = version;
        this.dbWorkload = dbWorkload;
        this.isDedicated = isDedicated;
        this.details = details;
        this.isFreeTierEnabled = isFreeTierEnabled;
        this.isPaidEnabled = isPaidEnabled;
        this.isDefaultForFree = isDefaultForFree;
        this.isDefaultForPaid = isDefaultForPaid;
    }

    public static enum DbWorkload {
        Oltp("OLTP"),
        Dw("DW"),
        Ajd("AJD"),
        Apex("APEX"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DbWorkload> map;

        private DbWorkload(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DbWorkload create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DbWorkload', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DbWorkload.class);
            map = new HashMap<String, DbWorkload>();
            for (DbWorkload v : DbWorkload.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="dbWorkload")
        private DbWorkload dbWorkload;
        @JsonProperty(value="isDedicated")
        private Boolean isDedicated;
        @JsonProperty(value="details")
        private String details;
        @JsonProperty(value="isFreeTierEnabled")
        private Boolean isFreeTierEnabled;
        @JsonProperty(value="isPaidEnabled")
        private Boolean isPaidEnabled;
        @JsonProperty(value="isDefaultForFree")
        private Boolean isDefaultForFree;
        @JsonProperty(value="isDefaultForPaid")
        private Boolean isDefaultForPaid;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder dbWorkload(DbWorkload dbWorkload) {
            this.dbWorkload = dbWorkload;
            this.__explicitlySet__.add("dbWorkload");
            return this;
        }

        public Builder isDedicated(Boolean isDedicated) {
            this.isDedicated = isDedicated;
            this.__explicitlySet__.add("isDedicated");
            return this;
        }

        public Builder details(String details) {
            this.details = details;
            this.__explicitlySet__.add("details");
            return this;
        }

        public Builder isFreeTierEnabled(Boolean isFreeTierEnabled) {
            this.isFreeTierEnabled = isFreeTierEnabled;
            this.__explicitlySet__.add("isFreeTierEnabled");
            return this;
        }

        public Builder isPaidEnabled(Boolean isPaidEnabled) {
            this.isPaidEnabled = isPaidEnabled;
            this.__explicitlySet__.add("isPaidEnabled");
            return this;
        }

        public Builder isDefaultForFree(Boolean isDefaultForFree) {
            this.isDefaultForFree = isDefaultForFree;
            this.__explicitlySet__.add("isDefaultForFree");
            return this;
        }

        public Builder isDefaultForPaid(Boolean isDefaultForPaid) {
            this.isDefaultForPaid = isDefaultForPaid;
            this.__explicitlySet__.add("isDefaultForPaid");
            return this;
        }

        public AutonomousDbVersionSummary build() {
            AutonomousDbVersionSummary __instance__ = new AutonomousDbVersionSummary(this.version, this.dbWorkload, this.isDedicated, this.details, this.isFreeTierEnabled, this.isPaidEnabled, this.isDefaultForFree, this.isDefaultForPaid);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(AutonomousDbVersionSummary o) {
            Builder copiedBuilder = this.version(o.getVersion()).dbWorkload(o.getDbWorkload()).isDedicated(o.getIsDedicated()).details(o.getDetails()).isFreeTierEnabled(o.getIsFreeTierEnabled()).isPaidEnabled(o.getIsPaidEnabled()).isDefaultForFree(o.getIsDefaultForFree()).isDefaultForPaid(o.getIsDefaultForPaid());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "AutonomousDbVersionSummary.Builder(version=" + this.version + ", dbWorkload=" + (Object)((Object)this.dbWorkload) + ", isDedicated=" + this.isDedicated + ", details=" + this.details + ", isFreeTierEnabled=" + this.isFreeTierEnabled + ", isPaidEnabled=" + this.isPaidEnabled + ", isDefaultForFree=" + this.isDefaultForFree + ", isDefaultForPaid=" + this.isDefaultForPaid + ")";
        }
    }
}

