/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetBackupDestinationRequest
extends BmcRequest<Void> {
    private String backupDestinationId;
    private String opcRequestId;

    @ConstructorProperties(value={"backupDestinationId", "opcRequestId"})
    GetBackupDestinationRequest(String backupDestinationId, String opcRequestId) {
        this.backupDestinationId = backupDestinationId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBackupDestinationId() {
        return this.backupDestinationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetBackupDestinationRequest, Void> {
        private String backupDestinationId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetBackupDestinationRequest o) {
            this.backupDestinationId(o.getBackupDestinationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetBackupDestinationRequest build() {
            GetBackupDestinationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder backupDestinationId(String backupDestinationId) {
            this.backupDestinationId = backupDestinationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetBackupDestinationRequest buildWithoutInvocationCallback() {
            return new GetBackupDestinationRequest(this.backupDestinationId, this.opcRequestId);
        }

        public String toString() {
            return "GetBackupDestinationRequest.Builder(backupDestinationId=" + this.backupDestinationId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

