/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetExadataIormConfigRequest
extends BmcRequest<Void> {
    private String dbSystemId;
    private String opcRequestId;

    @ConstructorProperties(value={"dbSystemId", "opcRequestId"})
    GetExadataIormConfigRequest(String dbSystemId, String opcRequestId) {
        this.dbSystemId = dbSystemId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExadataIormConfigRequest, Void> {
        private String dbSystemId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExadataIormConfigRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExadataIormConfigRequest build() {
            GetExadataIormConfigRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetExadataIormConfigRequest buildWithoutInvocationCallback() {
            return new GetExadataIormConfigRequest(this.dbSystemId, this.opcRequestId);
        }

        public String toString() {
            return "GetExadataIormConfigRequest.Builder(dbSystemId=" + this.dbSystemId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

