/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetExternalContainerDatabaseRequest
extends BmcRequest<Void> {
    private String externalContainerDatabaseId;
    private String opcRequestId;

    @ConstructorProperties(value={"externalContainerDatabaseId", "opcRequestId"})
    GetExternalContainerDatabaseRequest(String externalContainerDatabaseId, String opcRequestId) {
        this.externalContainerDatabaseId = externalContainerDatabaseId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getExternalContainerDatabaseId() {
        return this.externalContainerDatabaseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExternalContainerDatabaseRequest, Void> {
        private String externalContainerDatabaseId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExternalContainerDatabaseRequest o) {
            this.externalContainerDatabaseId(o.getExternalContainerDatabaseId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExternalContainerDatabaseRequest build() {
            GetExternalContainerDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder externalContainerDatabaseId(String externalContainerDatabaseId) {
            this.externalContainerDatabaseId = externalContainerDatabaseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetExternalContainerDatabaseRequest buildWithoutInvocationCallback() {
            return new GetExternalContainerDatabaseRequest(this.externalContainerDatabaseId, this.opcRequestId);
        }

        public String toString() {
            return "GetExternalContainerDatabaseRequest.Builder(externalContainerDatabaseId=" + this.externalContainerDatabaseId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

