/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListDbHomePatchHistoryEntriesRequest
extends BmcRequest<Void> {
    private String dbHomeId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"dbHomeId", "limit", "page"})
    ListDbHomePatchHistoryEntriesRequest(String dbHomeId, Integer limit, String page) {
        this.dbHomeId = dbHomeId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDbHomeId() {
        return this.dbHomeId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDbHomePatchHistoryEntriesRequest, Void> {
        private String dbHomeId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDbHomePatchHistoryEntriesRequest o) {
            this.dbHomeId(o.getDbHomeId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDbHomePatchHistoryEntriesRequest build() {
            ListDbHomePatchHistoryEntriesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbHomeId(String dbHomeId) {
            this.dbHomeId = dbHomeId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListDbHomePatchHistoryEntriesRequest buildWithoutInvocationCallback() {
            return new ListDbHomePatchHistoryEntriesRequest(this.dbHomeId, this.limit, this.page);
        }

        public String toString() {
            return "ListDbHomePatchHistoryEntriesRequest.Builder(dbHomeId=" + this.dbHomeId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

