/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.databasemanagement.DbManagement;
import com.oracle.bmc.databasemanagement.model.JobExecutionSummary;
import com.oracle.bmc.databasemanagement.model.JobRunSummary;
import com.oracle.bmc.databasemanagement.model.JobSummary;
import com.oracle.bmc.databasemanagement.model.ManagedDatabaseGroupSummary;
import com.oracle.bmc.databasemanagement.model.ManagedDatabaseSummary;
import com.oracle.bmc.databasemanagement.requests.ListJobExecutionsRequest;
import com.oracle.bmc.databasemanagement.requests.ListJobRunsRequest;
import com.oracle.bmc.databasemanagement.requests.ListJobsRequest;
import com.oracle.bmc.databasemanagement.requests.ListManagedDatabaseGroupsRequest;
import com.oracle.bmc.databasemanagement.requests.ListManagedDatabasesRequest;
import com.oracle.bmc.databasemanagement.responses.ListJobExecutionsResponse;
import com.oracle.bmc.databasemanagement.responses.ListJobRunsResponse;
import com.oracle.bmc.databasemanagement.responses.ListJobsResponse;
import com.oracle.bmc.databasemanagement.responses.ListManagedDatabaseGroupsResponse;
import com.oracle.bmc.databasemanagement.responses.ListManagedDatabasesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class DbManagementPaginators {
    private final DbManagement client;

    public Iterable<ListJobExecutionsResponse> listJobExecutionsResponseIterator(final ListJobExecutionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJobExecutionsRequest.Builder>(){

            public ListJobExecutionsRequest.Builder get() {
                return ListJobExecutionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobExecutionsResponse, String>(){

            public String apply(ListJobExecutionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobExecutionsRequest.Builder>, ListJobExecutionsRequest>(){

            public ListJobExecutionsRequest apply(RequestBuilderAndToken<ListJobExecutionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListJobExecutionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobExecutionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListJobExecutionsRequest, ListJobExecutionsResponse>(){

            public ListJobExecutionsResponse apply(ListJobExecutionsRequest request) {
                return DbManagementPaginators.this.client.listJobExecutions(request);
            }
        });
    }

    public Iterable<JobExecutionSummary> listJobExecutionsRecordIterator(final ListJobExecutionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJobExecutionsRequest.Builder>(){

            public ListJobExecutionsRequest.Builder get() {
                return ListJobExecutionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobExecutionsResponse, String>(){

            public String apply(ListJobExecutionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobExecutionsRequest.Builder>, ListJobExecutionsRequest>(){

            public ListJobExecutionsRequest apply(RequestBuilderAndToken<ListJobExecutionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListJobExecutionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobExecutionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListJobExecutionsRequest, ListJobExecutionsResponse>(){

            public ListJobExecutionsResponse apply(ListJobExecutionsRequest request) {
                return DbManagementPaginators.this.client.listJobExecutions(request);
            }
        }, (Function)new Function<ListJobExecutionsResponse, List<JobExecutionSummary>>(){

            public List<JobExecutionSummary> apply(ListJobExecutionsResponse response) {
                return response.getJobExecutionCollection().getItems();
            }
        });
    }

    public Iterable<ListJobRunsResponse> listJobRunsResponseIterator(final ListJobRunsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJobRunsRequest.Builder>(){

            public ListJobRunsRequest.Builder get() {
                return ListJobRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobRunsResponse, String>(){

            public String apply(ListJobRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobRunsRequest.Builder>, ListJobRunsRequest>(){

            public ListJobRunsRequest apply(RequestBuilderAndToken<ListJobRunsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListJobRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobRunsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListJobRunsRequest, ListJobRunsResponse>(){

            public ListJobRunsResponse apply(ListJobRunsRequest request) {
                return DbManagementPaginators.this.client.listJobRuns(request);
            }
        });
    }

    public Iterable<JobRunSummary> listJobRunsRecordIterator(final ListJobRunsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJobRunsRequest.Builder>(){

            public ListJobRunsRequest.Builder get() {
                return ListJobRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobRunsResponse, String>(){

            public String apply(ListJobRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobRunsRequest.Builder>, ListJobRunsRequest>(){

            public ListJobRunsRequest apply(RequestBuilderAndToken<ListJobRunsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListJobRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobRunsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListJobRunsRequest, ListJobRunsResponse>(){

            public ListJobRunsResponse apply(ListJobRunsRequest request) {
                return DbManagementPaginators.this.client.listJobRuns(request);
            }
        }, (Function)new Function<ListJobRunsResponse, List<JobRunSummary>>(){

            public List<JobRunSummary> apply(ListJobRunsResponse response) {
                return response.getJobRunCollection().getItems();
            }
        });
    }

    public Iterable<ListJobsResponse> listJobsResponseIterator(final ListJobsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJobsRequest.Builder>(){

            public ListJobsRequest.Builder get() {
                return ListJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobsResponse, String>(){

            public String apply(ListJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobsRequest.Builder>, ListJobsRequest>(){

            public ListJobsRequest apply(RequestBuilderAndToken<ListJobsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListJobsRequest, ListJobsResponse>(){

            public ListJobsResponse apply(ListJobsRequest request) {
                return DbManagementPaginators.this.client.listJobs(request);
            }
        });
    }

    public Iterable<JobSummary> listJobsRecordIterator(final ListJobsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJobsRequest.Builder>(){

            public ListJobsRequest.Builder get() {
                return ListJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobsResponse, String>(){

            public String apply(ListJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobsRequest.Builder>, ListJobsRequest>(){

            public ListJobsRequest apply(RequestBuilderAndToken<ListJobsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListJobsRequest, ListJobsResponse>(){

            public ListJobsResponse apply(ListJobsRequest request) {
                return DbManagementPaginators.this.client.listJobs(request);
            }
        }, (Function)new Function<ListJobsResponse, List<JobSummary>>(){

            public List<JobSummary> apply(ListJobsResponse response) {
                return response.getJobCollection().getItems();
            }
        });
    }

    public Iterable<ListManagedDatabaseGroupsResponse> listManagedDatabaseGroupsResponseIterator(final ListManagedDatabaseGroupsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListManagedDatabaseGroupsRequest.Builder>(){

            public ListManagedDatabaseGroupsRequest.Builder get() {
                return ListManagedDatabaseGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListManagedDatabaseGroupsResponse, String>(){

            public String apply(ListManagedDatabaseGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListManagedDatabaseGroupsRequest.Builder>, ListManagedDatabaseGroupsRequest>(){

            public ListManagedDatabaseGroupsRequest apply(RequestBuilderAndToken<ListManagedDatabaseGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListManagedDatabaseGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListManagedDatabaseGroupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListManagedDatabaseGroupsRequest, ListManagedDatabaseGroupsResponse>(){

            public ListManagedDatabaseGroupsResponse apply(ListManagedDatabaseGroupsRequest request) {
                return DbManagementPaginators.this.client.listManagedDatabaseGroups(request);
            }
        });
    }

    public Iterable<ManagedDatabaseGroupSummary> listManagedDatabaseGroupsRecordIterator(final ListManagedDatabaseGroupsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListManagedDatabaseGroupsRequest.Builder>(){

            public ListManagedDatabaseGroupsRequest.Builder get() {
                return ListManagedDatabaseGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListManagedDatabaseGroupsResponse, String>(){

            public String apply(ListManagedDatabaseGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListManagedDatabaseGroupsRequest.Builder>, ListManagedDatabaseGroupsRequest>(){

            public ListManagedDatabaseGroupsRequest apply(RequestBuilderAndToken<ListManagedDatabaseGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListManagedDatabaseGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListManagedDatabaseGroupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListManagedDatabaseGroupsRequest, ListManagedDatabaseGroupsResponse>(){

            public ListManagedDatabaseGroupsResponse apply(ListManagedDatabaseGroupsRequest request) {
                return DbManagementPaginators.this.client.listManagedDatabaseGroups(request);
            }
        }, (Function)new Function<ListManagedDatabaseGroupsResponse, List<ManagedDatabaseGroupSummary>>(){

            public List<ManagedDatabaseGroupSummary> apply(ListManagedDatabaseGroupsResponse response) {
                return response.getManagedDatabaseGroupCollection().getItems();
            }
        });
    }

    public Iterable<ListManagedDatabasesResponse> listManagedDatabasesResponseIterator(final ListManagedDatabasesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListManagedDatabasesRequest.Builder>(){

            public ListManagedDatabasesRequest.Builder get() {
                return ListManagedDatabasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListManagedDatabasesResponse, String>(){

            public String apply(ListManagedDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListManagedDatabasesRequest.Builder>, ListManagedDatabasesRequest>(){

            public ListManagedDatabasesRequest apply(RequestBuilderAndToken<ListManagedDatabasesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListManagedDatabasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListManagedDatabasesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListManagedDatabasesRequest, ListManagedDatabasesResponse>(){

            public ListManagedDatabasesResponse apply(ListManagedDatabasesRequest request) {
                return DbManagementPaginators.this.client.listManagedDatabases(request);
            }
        });
    }

    public Iterable<ManagedDatabaseSummary> listManagedDatabasesRecordIterator(final ListManagedDatabasesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListManagedDatabasesRequest.Builder>(){

            public ListManagedDatabasesRequest.Builder get() {
                return ListManagedDatabasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListManagedDatabasesResponse, String>(){

            public String apply(ListManagedDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListManagedDatabasesRequest.Builder>, ListManagedDatabasesRequest>(){

            public ListManagedDatabasesRequest apply(RequestBuilderAndToken<ListManagedDatabasesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListManagedDatabasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListManagedDatabasesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListManagedDatabasesRequest, ListManagedDatabasesResponse>(){

            public ListManagedDatabasesResponse apply(ListManagedDatabasesRequest request) {
                return DbManagementPaginators.this.client.listManagedDatabases(request);
            }
        }, (Function)new Function<ListManagedDatabasesResponse, List<ManagedDatabaseSummary>>(){

            public List<ManagedDatabaseSummary> apply(ListManagedDatabasesResponse response) {
                return response.getManagedDatabaseCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public DbManagementPaginators(DbManagement client) {
        this.client = client;
    }
}

